/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.valueset.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Iterator;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.models.valueset.IBaseSimpleValueSet;
import kd.fi.v2.fah.models.valueset.base.AbstractBaseValueSetCollection;
import kd.fi.v2.fah.storage.impl.CacheableMutableArrayStorage;

public class SimpleBaseValueSetCollection<T extends IBaseSimpleValueSet>
extends AbstractBaseValueSetCollection<T, CacheableMutableArrayStorage<T>> {
    public SimpleBaseValueSetCollection() {
        this._storageDatas = new CacheableMutableArrayStorage[this.getTotalDataGroupCnt()];
        for (int i = 0; i < this.getTotalDataGroupCnt(); ++i) {
            ((CacheableMutableArrayStorage[])this._storageDatas)[i] = new CacheableMutableArrayStorage();
        }
        this.currentUsedDataGroupIndex = 0;
    }

    public SimpleBaseValueSetCollection(int columnCnt) {
        this();
        this.columnCnt = columnCnt;
    }

    protected SimpleBaseValueSetCollection(int currentDataGroupCode, int columnCnt, CacheableMutableArrayStorage<T> _storageDatas, boolean reserveColumnPosition, Object[] reserveColumnDataBuffer) {
        CacheableMutableArrayStorage[] cacheableMutableArrayStorageArray = new CacheableMutableArrayStorage[1];
        this._storageDatas = cacheableMutableArrayStorageArray;
        cacheableMutableArrayStorageArray[0] = _storageDatas;
        this.columnCnt = columnCnt;
        this.reserveColumnPosition = reserveColumnPosition;
        this.reserveColumnDataBuffer = reserveColumnDataBuffer;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int getTotalDataGroupCnt() {
        return 1;
    }

    @Override
    protected PairTuple<Boolean, Object[]> getReserveColumnData() {
        return new PairTuple((Object)this.reserveColumnPosition, (Object)this.reserveColumnDataBuffer);
    }

    @Override
    protected void updateItemReference(int rowDataGrpIdx) {
        if (this.reserveColumnDataBuffer != null && this.reserveColumnDataBuffer.length > 0) {
            PairTuple<Boolean, Object[]> supplier = this.getReserveColumnData();
            for (IBaseSimpleValueSet valueSet : ((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx]) {
                valueSet.setReserveDataSupplier(() -> supplier);
            }
        }
    }

    @Override
    protected T[] getValues(int rowDataGrpIdx) {
        return (IBaseSimpleValueSet[])((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx].getValues();
    }

    @Override
    protected CacheableMutableArrayStorage<T> getValueSetCollection(int rowDataGrpIdx) {
        return ((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx];
    }

    @Override
    protected T getValueSetCollection(int rowDataGrpIdx, int valueSetIndex) {
        return (T)((IBaseSimpleValueSet)((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx].get(valueSetIndex));
    }

    @Override
    protected T get(int rowDataGrpIdx, int index) {
        return (T)((IBaseSimpleValueSet)((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx].get(index));
    }

    @Override
    protected int cache(int rowDataGrpIdx, T value) {
        return ((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx].cache(value);
    }

    @Override
    protected int cachedSize(int rowDataGrpIdx) {
        return ((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx].cachedSize();
    }

    @Override
    protected boolean flush(int rowDataGrpIdx) {
        boolean result = ((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx].flush();
        if (result) {
            this.updateItemReference(rowDataGrpIdx);
        }
        return result;
    }

    @Override
    protected boolean clearCache(int rowDataGrpIdx) {
        return ((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx].clearCache();
    }

    protected CacheableMutableArrayStorage<T> get_RowDatas(int rowDataGrpIdx) {
        return ((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx];
    }

    protected void set_RowDatas(int rowDataGrpIdx, CacheableMutableArrayStorage<T> rowDatas) {
        ((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx] = rowDatas;
    }

    @Override
    protected long getTotalRowCnt(int rowDataGrpIdx) {
        return ((CacheableMutableArrayStorage[])this._storageDatas)[rowDataGrpIdx].size();
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int size() {
        return this.size(this.currentUsedDataGroupIndex);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isEmpty() {
        return this.isEmpty(this.currentUsedDataGroupIndex);
    }

    @Override
    public T get(int index) {
        return this.get(this.currentUsedDataGroupIndex, index);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this.currentUsedDataGroupIndex);
    }

    @Override
    public T[] toArray() {
        return this.toArray(this.currentUsedDataGroupIndex);
    }

    @Override
    public int moveToNextDataGroup() {
        if (this.currentUsedDataGroupIndex >= this.getTotalDataGroupCnt() - 1) {
            return -1;
        }
        return ++this.currentUsedDataGroupIndex;
    }

    @Override
    public int cache(T value) {
        return this.cache(this.currentUsedDataGroupIndex, value);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int cachedSize() {
        return this.cachedSize(this.currentUsedDataGroupIndex);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean flush() {
        return this.flush(this.currentUsedDataGroupIndex);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean clearCache() {
        return this.clearCache(this.currentUsedDataGroupIndex);
    }

    @Override
    public int getCurrentUsedDataGroupIndex() {
        return this.currentUsedDataGroupIndex;
    }

    @Override
    public void setCurrentUsedDataGroupIndex(int currentUsedDataGroupIndex) {
        this.currentUsedDataGroupIndex = currentUsedDataGroupIndex;
    }

    @Override
    public void setColumnCnt(int columnCnt) {
        this.columnCnt = columnCnt;
    }

    @Override
    public int getColumnCnt() {
        return this.columnCnt;
    }

    public CacheableMutableArrayStorage<T>[] get_storageDatas() {
        return (CacheableMutableArrayStorage[])this._storageDatas;
    }

    protected CacheableMutableArrayStorage<T>[] createStorage(int groupCnt) {
        CacheableMutableArrayStorage[] result = new CacheableMutableArrayStorage[groupCnt];
        for (int i = 0; i < groupCnt; ++i) {
            result[i] = new CacheableMutableArrayStorage();
        }
        return result;
    }

    public void set_storageDatas(CacheableMutableArrayStorage<T>[] _storageDatas) {
        this._storageDatas = _storageDatas;
    }

    @Override
    public boolean isReserveColumnPosition() {
        return this.reserveColumnPosition;
    }

    @Override
    public void setReserveColumnPosition(boolean reserveColumnPosition) {
        this.reserveColumnPosition = reserveColumnPosition;
    }

    @Override
    public Object[] getReserveColumnDataBuffer() {
        return this.reserveColumnDataBuffer;
    }

    @Override
    public void setReserveColumnDataBuffer(Object[] reserveColumnDataBuffer) {
        this.reserveColumnDataBuffer = reserveColumnDataBuffer;
    }
}

