/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.optimizor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.util.ConfigurationUtil;
import kd.fi.ai.enums.AccMapFuzzyMatchStrategyEnum;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.utils.StringUtils;

public class FahOptimizeControlPanel {
    private static final String MutexLock_Enable_Switch = "fi.fah.mutexlock.enable";
    private static final String Enable_BasePropDefaultValue_Switch = "fi.fah.enable.BasePropDefaultValue";
    public static final String sysProperty_FiFahUnitTestLevel = "FI_FAH_UNIT_TEST_LEVEL";

    public static boolean isMutexLock_Enabled() {
        return FahOptimizeControlPanel.getSysPropertyBoolean(MutexLock_Enable_Switch, true);
    }

    public static boolean isBasePropDefaultValue_Enabled() {
        return FahOptimizeControlPanel.getSysPropertyBoolean(Enable_BasePropDefaultValue_Switch, false);
    }

    public static Boolean getSysPropertyBoolean(String propertyName, Boolean defaultValue) {
        String val = ConfigurationUtil.getString((String)String.format("%s_%s", RequestContext.getOrCreate().getTenantId(), propertyName));
        if (null == val) {
            return IDataValueUtil.getBoolean((Object)ConfigurationUtil.getString((String)propertyName, (String)(defaultValue != false ? "true" : "false")));
        }
        return IDataValueUtil.getBoolean((Object)val);
    }

    public static int putVoucherMaxSizeData() {
        return Integer.parseInt(SysParamConfig.get("pushvouchermaxsize", "10000"));
    }

    public static int preSaveDBEntrySize() {
        return Integer.parseInt(SysParamConfig.get("presaveentrysize", "100000"));
    }

    public static AccMapFuzzyMatchStrategyEnum getAccMapStrategy() {
        String strategy = SysParamConfig.getCache("accountMapFuzzyMatchStrategy", AccMapFuzzyMatchStrategyEnum.LONG_NUMBER.getValue());
        return AccMapFuzzyMatchStrategyEnum.parseByValue(strategy);
    }

    public static Set<String> getSkipLeafBD() {
        String config = SysParamConfig.getCache("skipLeafCheckBaseData");
        HashSet<String> bds = new HashSet<String>(8);
        if (StringUtils.isNotEmpty((String)config)) {
            String[] configs = config.split(",");
            bds.addAll(Arrays.asList(configs));
        }
        return bds;
    }

    public static String getCodeRuleEntity() {
        return SysParamConfig.getCache("glVoucherExtensionEntityName", "gl_voucher");
    }

    public static int getBigEntrySize() {
        return Integer.parseInt(SysParamConfig.get("fah.evt.bigEntrySizeConfig", "5000"));
    }

    public static boolean isRecordMemUseInfo() {
        return Boolean.parseBoolean(SysParamConfig.get("fah.evt.isRecordMemUseInfo", "false"));
    }

    public static boolean isValidateBizVoucherDCBalance() {
        return Boolean.parseBoolean(SysParamConfig.getCache("fi.ai.dap.bizvoucher.validateBizVoucherDCBalance", "true"));
    }

    public static boolean supportMultiLangForVchTemplateFilter() {
        return Boolean.parseBoolean(SysParamConfig.getCache("fi.ai.dap.vchtemplate.supportMultiLangFilter", "false"));
    }

    public static int getParallelEntryJoinResultMaxSize() {
        return ObjectConverterFactory.getInteger(SysParamConfig.getCache("ParallelEntryJoinResultMaxSize"), 500000);
    }

    public static int getAddLockSelectTempSize() {
        return Integer.parseInt(SysParamConfig.getCache("ai.dap.addlockselecttempsize", "50"));
    }

    public static int getTemplateByBatchSize() {
        return Integer.parseInt(SysParamConfig.getCache("ai.dap.templatebybatchsize", "50"));
    }

    public static boolean getCacheExtractVariables() {
        return Boolean.parseBoolean(SysParamConfig.getCache("ai.dap.cacheextractvariables", "true"));
    }

    public static boolean getCacheParseFormula() {
        return Boolean.parseBoolean(SysParamConfig.getCache("ai.dap.cacheparseformula", "true"));
    }

    public static boolean getCacheVchTemplateMultiLang() {
        return Boolean.parseBoolean(SysParamConfig.getCache("ai.dap.vchtemplate.multilang", "true"));
    }

    public static Integer getDapGenEntryMaxSize() {
        return ObjectConverterFactory.getInteger(SysParamConfig.getCache("DAP_GEN_ENTRY_MAX_SIZE"), 100000);
    }
}

