/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.resource;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.v2.fah.resource.IPropResourceAssist;

public class PropResourceAssistFactory {
    public static <T> IPropResourceAssist<T, Map<String, T>> mapToPropResAssist(Map<String, T> sourceMap, T defaultValue) {
        return new MapPropResAssist(sourceMap, defaultValue);
    }

    public static <T> IPropResourceAssist<T, DynamicObject> dynamicObjectToPropResAssist(DynamicObject sourceDyn, T defaultValue) {
        return new DynamicPropResAssist<T>(sourceDyn, defaultValue);
    }

    public static class DynamicPropResAssist<T>
    extends SimplePropResAssist<T, DynamicObject> {
        public DynamicPropResAssist(DynamicObject source, T defaultValue) {
            super(source, defaultValue);
        }

        public DynamicPropResAssist(DynamicObject source) {
            super(source);
        }

        protected DynamicObject parseLastDynObject(String[] propPath) {
            DynamicObject currentEntryObj = (DynamicObject)this.source;
            if (propPath != null && propPath.length > 0) {
                for (String currentPath : propPath) {
                    if (currentPath == null) continue;
                    currentEntryObj = currentEntryObj.getDynamicObject(currentPath);
                }
            }
            return currentEntryObj;
        }

        @Override
        public T getPropValue(String[] propPath, String propName, Object ... params) {
            DynamicObject currentEntryObj = this.parseLastDynObject(propPath);
            return (T)(currentEntryObj != null ? currentEntryObj.get(propName) : this.defaultValue);
        }

        @Override
        public boolean isPropExists(String[] propPath, String propName, Object ... params) {
            try {
                DynamicObject currentEntryObj = this.parseLastDynObject(propPath);
                return currentEntryObj.containsProperty(propName);
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    public static class MapPropResAssist<T>
    extends SimplePropResAssist<T, Map<String, Map<String, T>>> {
        public MapPropResAssist(Map<String, Map<String, T>> source, T defaultValue) {
            super(source, defaultValue);
        }

        public MapPropResAssist(Map<String, Map<String, T>> source) {
            super(source);
        }

        @Override
        public T getPropValue(String[] propPath, String propName, Object ... params) {
            Object result = this.defaultValue;
            if (this.source != null) {
                result = ((Map)this.source).get(this.getPropFullPath(propPath, propName));
            }
            return (T)result;
        }

        @Override
        public boolean isPropExists(String[] propPath, String propName, Object ... params) {
            return this.source != null ? ((Map)this.source).containsKey(this.getPropFullPath(propPath, propName)) : false;
        }
    }

    public static abstract class SimplePropResAssist<T, E>
    implements IPropResourceAssist<T, E> {
        T defaultValue;
        E source;

        public SimplePropResAssist(E source, T defaultValue) {
            this.source = source;
            this.defaultValue = defaultValue;
        }

        public SimplePropResAssist(E source) {
            this(source, null);
        }

        @Override
        public IPropResourceAssist<T, E> setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        @JSONField(serialize=false)
        @JsonIgnore
        public T getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public IPropResourceAssist<T, E> setSource(E source) {
            this.source = source;
            return this;
        }

        @Override
        @JSONField(serialize=false)
        @JsonIgnore
        public E getSource() {
            return this.source;
        }
    }
}

