/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.serializer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import kd.fi.bd.util.bean.IDataBeanUtil;
import kd.fi.v2.fah.cache.thread.ClassSerializePropsCache;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.models.serialize.JsonSerializeNodeWrapper;
import kd.fi.v2.fah.serializer.CustomJsonSerializeHelper;
import kd.fi.v2.fah.serializer.ICustomJsonSerialize;

public class CustomCollectionModelSerializer
implements ObjectSerializer,
ObjectDeserializer {
    private static final String Data_FieldName = "datas";

    public int getFastMatchToken() {
        return 0;
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter writer = serializer.getWriter();
        if (object == null) {
            writer.writeNull();
            return;
        }
        Map<String, ClassSerializePropsCache> serializeFields = CustomJsonSerializeHelper.getSerializableProperties(object.getClass(), true, false);
        if (serializeFields == null || serializeFields.isEmpty()) {
            writer.writeNull();
            return;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            for (ClassSerializePropsCache fieldInfo : serializeFields.values()) {
                Object valueBuf = fieldInfo.getReadMethod().invoke(object, new Object[0]);
                if (valueBuf == null) continue;
                if (valueBuf instanceof ICustomJsonSerialize) {
                    if (!((ICustomJsonSerialize)valueBuf).needToSerialize()) continue;
                    jsonObject.put(fieldInfo.getFieldName(), (Object)new JsonSerializeNodeWrapper(valueBuf));
                    continue;
                }
                jsonObject.put(fieldInfo.getFieldName(), valueBuf);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IOException(e.getMessage(), e);
        }
        serializer.write((Object)jsonObject);
    }

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object o) {
        Object targetObject = parser.parse();
        if (targetObject instanceof JSONObject) {
            Class clazz = ParameterizedType.class.isAssignableFrom(type.getClass()) ? (Class)((ParameterizedType)type).getRawType() : IDataBeanUtil.getClassByName((String)type.getTypeName());
            if (clazz == null) {
                return null;
            }
            Object resultObject = IDataBeanUtil.getClassNewInstance((Class)clazz, (Object[])new Object[0]);
            if (resultObject == null) {
                return null;
            }
            Map<String, ClassSerializePropsCache> serializeFields = CustomJsonSerializeHelper.getSerializableProperties(clazz, true, false);
            if (serializeFields == null || serializeFields.isEmpty()) {
                return (T)parser.parseObject(type);
            }
            JSONObject jsonObject = (JSONObject)targetObject;
            String fieldName = null;
            try {
                for (ClassSerializePropsCache fieldInfo : serializeFields.values()) {
                    Object valueBuf;
                    fieldName = fieldInfo.getFieldName();
                    if (!jsonObject.containsKey((Object)fieldName) || (valueBuf = fieldInfo.isCustomSerialize() ? jsonObject.get((Object)fieldName) : jsonObject.getObject(fieldName, fieldInfo.getField().getType())) == null) continue;
                    if (valueBuf instanceof JSONObject) {
                        valueBuf = CustomJsonSerializeHelper.parseJsonSerializeNodeWrapper((JSONObject)valueBuf, fieldInfo.getField().getType(), fieldName);
                    } else {
                        if (valueBuf instanceof JSONArray) continue;
                        valueBuf = ObjectConverterFactory.convert(valueBuf, fieldInfo.getField().getType());
                    }
                    if (valueBuf == null) continue;
                    fieldInfo.getWriteMethod().invoke(resultObject, valueBuf);
                }
            }
            catch (JSONException | IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(fieldName + " : " + e.getMessage(), e);
            }
            return (T)resultObject;
        }
        if (targetObject instanceof JSONArray) {
            throw new UnsupportedOperationException();
        }
        return (T)targetObject;
    }
}

