/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.fi.bd.util.bean.IDataBeanUtil;
import kd.fi.v2.fah.cache.thread.ClassSerializePropsCache;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.models.common.ThreeValueTuple;
import kd.fi.v2.fah.models.serialize.JsonSerializeNodeWrapper;
import kd.fi.v2.fah.serializer.ICustomJsonSerialize;
import kd.fi.v2.fah.serializer.ICustomJsonSerializeOutputClassName;
import kd.fi.v2.fah.utils.StringUtils;

public class CustomJsonSerializeHelper {
    private static final ThreadLocal<ThreadLocalMapContainer<ThreeValueTuple<Class<?>, Boolean, Boolean>, Map<String, ClassSerializePropsCache>>> Thread_Cache_ClassSerializeInfo = ThreadLocal.withInitial(() -> new ThreadLocalMapContainer());
    private static final ThreadLocal<ThreadLocalMapContainer<Class<?>, Map<String, ClassSerializePropsCache>>> Thread_Cache_Custom_Data_SerializeInfo = ThreadLocal.withInitial(() -> new ThreadLocalMapContainer());
    public static final String Data_FieldName = "datas";

    public static String iteratorToJSONArrayString(Iterator sourceIterator) {
        LinkedList bufferList = new LinkedList();
        sourceIterator.forEachRemaining(v -> bufferList.add(v));
        return JSON.toJSONString((Object)bufferList.toArray());
    }

    public static <T> T parseJsonSerializeNodeWrapper(String sourceJson) {
        if (sourceJson == null || "".equals(sourceJson.trim())) {
            return null;
        }
        return CustomJsonSerializeHelper.parseJsonSerializeNodeWrapper(JSON.parseObject((String)sourceJson), null, null);
    }

    public static ParameterizedType buildParameterizedType(Class rawType, Type[] actualTypeArguments, Type ownerType) {
        return new ParameterizedTypeImpl(actualTypeArguments, ownerType, (Type)rawType);
    }

    public static ParameterizedType buildParameterizedType(Class rawType) {
        return new ParameterizedTypeImpl(null, null, (Type)rawType);
    }

    public static <T> T parseJsonSerializeNodeWrapper(JSONObject sourceJson, Type type, Object fieldName) {
        if (sourceJson == null || sourceJson.isEmpty()) {
            return null;
        }
        String customClassTypeKey = sourceJson.getString("__$custom_json_real_class$");
        if (customClassTypeKey != null) {
            type = IDataBeanUtil.getClassByName((String)customClassTypeKey);
        }
        if (!JsonSerializeNodeWrapper.isJsonSerializeNodeWrapper(sourceJson)) {
            Object dataBuf = sourceJson.get((Object)Data_FieldName);
            if (dataBuf instanceof JSONObject) {
                ClassSerializePropsCache propsCache = CustomJsonSerializeHelper.getFirstCustomSerializeFields(type);
                if (propsCache == null) {
                    throw new IllegalArgumentException(String.format("JSONObject:%s Type:%s Object:%s", sourceJson, type, fieldName));
                }
                T dataValueBuf = CustomJsonSerializeHelper.parseJsonSerializeNodeWrapper((JSONObject)dataBuf, propsCache == null ? null : propsCache.getField().getType(), propsCache.getFieldName());
                sourceJson.remove((Object)Data_FieldName);
                Object result = sourceJson.toJavaObject(type);
                try {
                    propsCache.getWriteMethod().invoke(result, dataValueBuf);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return (T)result;
            }
            return (T)sourceJson.toJavaObject(type);
        }
        JsonSerializeNodeWrapper wrapper = (JsonSerializeNodeWrapper)sourceJson.toJavaObject(JsonSerializeNodeWrapper.class);
        Object wrapperData = wrapper.getData();
        if (wrapperData == null) {
            return null;
        }
        if (wrapperData instanceof JSONObject) {
            if (!wrapper.isUseCustomSerializeClass()) {
                return (T)JSON.toJavaObject((JSON)((JSONObject)wrapper.getData()), (Class)wrapper.getSourceClass());
            }
            JSONArray jsonArray = ((JSONObject)wrapperData).getJSONArray(Data_FieldName);
            if (jsonArray == null) {
                return null;
            }
            return (T)CustomJsonSerializeHelper.parseCustomSerializeClassFromArray(jsonArray, wrapper, null);
        }
        if (wrapperData instanceof JSONArray) {
            return (T)CustomJsonSerializeHelper.parseCustomSerializeClassFromArray(wrapper, null);
        }
        return (T)wrapperData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseCustomCollectionJsonObject(JSONObject srcJsonObject, Class<T> customCollectionClazz, T outputResult) {
        Map<String, ClassSerializePropsCache> serializeFields;
        if (srcJsonObject == null || customCollectionClazz == null) {
            return outputResult;
        }
        if (!ICustomJsonSerialize.class.isAssignableFrom(customCollectionClazz)) {
            return (T)srcJsonObject.toJavaObject(customCollectionClazz);
        }
        if (outputResult == null) {
            try {
                outputResult = customCollectionClazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        if ((serializeFields = CustomJsonSerializeHelper.getSerializableProperties(customCollectionClazz)) == null || serializeFields.isEmpty()) {
            return outputResult;
        }
        String fieldName = null;
        try {
            for (Map.Entry en : srcJsonObject.entrySet()) {
                Object valueBuf;
                ClassSerializePropsCache fieldInfo;
                block14: {
                    fieldInfo = serializeFields.get(en.getKey());
                    if (fieldInfo == null) continue;
                    fieldName = fieldInfo.getFieldName();
                    Class<?> fieldType = fieldInfo.getField().getType();
                    if (fieldInfo.isCustomSerialize()) {
                        valueBuf = srcJsonObject.get((Object)fieldName);
                        if (valueBuf == null) continue;
                        if (valueBuf instanceof JSONObject) {
                            JSONObject jsonObjectBuf = (JSONObject)valueBuf;
                            valueBuf = JsonSerializeNodeWrapper.isJsonSerializeNodeWrapper(jsonObjectBuf) ? CustomJsonSerializeHelper.parseJsonSerializeNodeWrapper((JSONObject)valueBuf, fieldType, fieldName) : CustomJsonSerializeHelper.parseCustomCollectionJsonObject(jsonObjectBuf, fieldInfo.getField().getType(), null);
                            break block14;
                        } else {
                            if (!(valueBuf instanceof JSONArray)) continue;
                            JSONArray jsonArrayBuf = (JSONArray)valueBuf;
                            ArrayList<T> valueBufList = new ArrayList<T>(jsonArrayBuf.size());
                            for (Object v : jsonArrayBuf) {
                                JSONObject jsonObjectBuf2;
                                if (!(v instanceof JSONObject) || !JsonSerializeNodeWrapper.isJsonSerializeNodeWrapper(jsonObjectBuf2 = (JSONObject)v)) throw new UnsupportedOperationException("UnSupport JsonObject in JsonArray: " + v);
                                valueBufList.add(CustomJsonSerializeHelper.parseJsonSerializeNodeWrapper(jsonObjectBuf2, fieldType, fieldName));
                            }
                            ((ICustomJsonSerialize)outputResult).setJsonSerializeV(valueBufList, fieldType, true);
                            continue;
                        }
                    }
                    valueBuf = srcJsonObject.getObject(fieldName, fieldInfo.getField().getType());
                    if (valueBuf == null) continue;
                    valueBuf = ObjectConverterFactory.convert(valueBuf, fieldInfo.getField().getType());
                }
                if (valueBuf == null) continue;
                fieldInfo.getWriteMethod().invoke(outputResult, valueBuf);
            }
            return outputResult;
        }
        catch (JSONException | IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException(fieldName + " : " + e.getMessage(), e);
        }
    }

    public static Object parseCustomSerializeClassFromArray(JsonSerializeNodeWrapper wrapper, ICustomJsonSerialize outputTemplate) {
        return CustomJsonSerializeHelper.parseCustomSerializeClassFromArray((JSONArray)wrapper.getData(), outputTemplate, wrapper.getSourceClass(), wrapper.getCustomSerializeClass(), wrapper.isRequiredRebuild(), wrapper.isCaseSensitive());
    }

    public static Object parseCustomSerializeClassFromArray(JSONArray jsonArray, JsonSerializeNodeWrapper wrapper, ICustomJsonSerialize outputTemplate) {
        return CustomJsonSerializeHelper.parseCustomSerializeClassFromArray(jsonArray, outputTemplate, wrapper.getSourceClass(), wrapper.getCustomSerializeClass(), wrapper.isRequiredRebuild(), wrapper.isCaseSensitive());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object parseCustomSerializeClassFromArray(JSONArray jsonArray, ICustomJsonSerialize outputTemplate, Class sourceClass, Class customSerializeClass, boolean requiredRebuild, boolean isCaseSensitive) {
        Object[] subItems;
        if (sourceClass == null) {
            throw new IllegalArgumentException("Unknown Source Class for Json De-Serialize!");
        }
        if (jsonArray != null && !jsonArray.isEmpty()) {
            subItems = new Object[jsonArray.size()];
            Class childItemClassType = null;
            boolean needParseCustomOutputClassType = false;
            int classModifier = customSerializeClass.getModifiers();
            if (Modifier.isInterface(classModifier) || Modifier.isAbstract(classModifier)) {
                if (!ICustomJsonSerializeOutputClassName.class.isAssignableFrom(customSerializeClass)) throw new IllegalArgumentException(String.format("CustomSerialize Class Cannot be Interface or Abstract! (Try to extends [%s] from ICustomJsonSerializeOutputClassName.class)", customSerializeClass));
                needParseCustomOutputClassType = true;
            } else {
                childItemClassType = customSerializeClass;
            }
            int i = 0;
            for (Object obj : jsonArray) {
                if (obj == null) continue;
                if (needParseCustomOutputClassType) {
                    childItemClassType = CustomJsonSerializeHelper.parseClassFromName(((JSONObject)obj).get((Object)"__$custom_json_real_class$"));
                }
                subItems[i++] = CustomJsonSerializeHelper.parseJsonSerializeNodeWrapper((JSONObject)obj, childItemClassType, null);
            }
        } else {
            subItems = (Object[])Array.newInstance(customSerializeClass != null ? customSerializeClass : Object.class, 0);
        }
        if (outputTemplate == null) {
            try {
                Object newInstance = sourceClass.newInstance();
                if (!ICustomJsonSerialize.class.isAssignableFrom(newInstance.getClass())) {
                    return subItems;
                }
                outputTemplate = (ICustomJsonSerialize)newInstance;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        outputTemplate.setJsonSerializeV(subItems, customSerializeClass, isCaseSensitive);
        if (!requiredRebuild) return outputTemplate;
        outputTemplate.rebuildAfterDeSerialize();
        return outputTemplate;
    }

    public static Map<String, ClassSerializePropsCache> getSerializableProperties(Class<?> clazz, boolean allowNonSerializableProps, boolean allowNonPublicWriteMethod, boolean forceReload) {
        Map<String, ClassSerializePropsCache> properties;
        ThreadLocalMapContainer<ThreeValueTuple<Class<?>, Boolean, Boolean>, Map<String, ClassSerializePropsCache>> threadCache = Thread_Cache_ClassSerializeInfo.get();
        ThreeValueTuple key = new ThreeValueTuple(clazz, allowNonSerializableProps, allowNonPublicWriteMethod);
        if (!forceReload && (properties = threadCache.get(key)) != null && !properties.isEmpty()) {
            return properties;
        }
        properties = CustomJsonSerializeHelper.parseSerializableProperties(clazz, allowNonSerializableProps, allowNonPublicWriteMethod);
        if (!properties.isEmpty()) {
            threadCache.put(key, properties);
        }
        return properties;
    }

    public static Map<String, ClassSerializePropsCache> getSerializableProperties(Class<?> clazz, boolean allowNonSerializableProps, boolean allowNonPublicWriteMethod) {
        return CustomJsonSerializeHelper.getSerializableProperties(clazz, allowNonSerializableProps, allowNonPublicWriteMethod, false);
    }

    public static Map<String, ClassSerializePropsCache> getSerializableProperties(Class<?> clazz, boolean allowNonPublicWriteMethod) {
        return CustomJsonSerializeHelper.getSerializableProperties(clazz, true, false, allowNonPublicWriteMethod);
    }

    public static Map<String, ClassSerializePropsCache> getSerializableProperties(Class<?> clazz) {
        return CustomJsonSerializeHelper.getSerializableProperties(clazz, true, false, false);
    }

    public static List<ClassSerializePropsCache> _parseSerializablePropertiesEx(Class<?> clazz, boolean allowNonSerializableProps, boolean allowNonPublicWriteMethod) {
        Field[] fields;
        LinkedList<ClassSerializePropsCache> properties = new LinkedList<ClassSerializePropsCache>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String jsonFieldName;
            Method writeMethod;
            Method readMethod;
            PropertyDescriptor descriptor;
            try {
                descriptor = new PropertyDescriptor(field.getName(), clazz);
                readMethod = descriptor.getReadMethod();
                writeMethod = descriptor.getWriteMethod();
            }
            catch (IntrospectionException e) {
                continue;
            }
            if (readMethod == null || !Modifier.isPublic(readMethod.getModifiers()) || !allowNonPublicWriteMethod && (writeMethod == null || !Modifier.isPublic(writeMethod.getModifiers())) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || !allowNonSerializableProps && !Serializable.class.isAssignableFrom(field.getType()) || !StringUtils.isNotEmpty((String)(jsonFieldName = CustomJsonSerializeHelper.isJSONFieldSerializable(field, field.getName())))) continue;
            properties.add(new ClassSerializePropsCache(descriptor, field, jsonFieldName));
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            properties.addAll(CustomJsonSerializeHelper._parseSerializablePropertiesEx(superClass, allowNonSerializableProps, allowNonPublicWriteMethod));
        }
        properties.sort(Comparator.comparingInt(propertyInfo -> {
            JSONField jsonField = propertyInfo.getField().getAnnotation(JSONField.class);
            return jsonField != null ? jsonField.ordinal() : 0;
        }));
        return properties;
    }

    public static Map<String, ClassSerializePropsCache> parseSerializableProperties(Class<?> clazz, boolean allowNonSerializableProps, boolean allowNonPublicWriteMethod) {
        List<ClassSerializePropsCache> bufList = CustomJsonSerializeHelper._parseSerializablePropertiesEx(clazz, allowNonSerializableProps, allowNonPublicWriteMethod);
        if (bufList.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, ClassSerializePropsCache> result = new LinkedHashMap<String, ClassSerializePropsCache>(bufList.size());
        for (ClassSerializePropsCache field : bufList) {
            result.put(field.getFieldName(), field);
        }
        return result;
    }

    public static Map<String, ClassSerializePropsCache> parseSerializableProperties(Class<?> clazz) {
        return CustomJsonSerializeHelper.parseSerializableProperties(clazz, false, false);
    }

    public static Map<String, ClassSerializePropsCache> getCustomSerializeFields(Class clazz, boolean forceReload) {
        Map<String, ClassSerializePropsCache> properties;
        ThreadLocalMapContainer<Class<?>, Map<String, ClassSerializePropsCache>> threadCache = Thread_Cache_Custom_Data_SerializeInfo.get();
        if (!forceReload && (properties = threadCache.get(clazz)) != null && !properties.isEmpty()) {
            return properties;
        }
        properties = CustomJsonSerializeHelper._parseCustomSerializeFieldsEx(clazz, new String[]{Data_FieldName});
        if (!properties.isEmpty()) {
            threadCache.put(clazz, properties);
        }
        return properties;
    }

    public static Map<String, ClassSerializePropsCache> getCustomSerializeFields(Class clazz) {
        return CustomJsonSerializeHelper.getCustomSerializeFields(clazz, false);
    }

    public static Map<String, ClassSerializePropsCache> getCustomSerializeFields(Type clazzType) {
        return CustomJsonSerializeHelper.getCustomSerializeFields(CustomJsonSerializeHelper.parseClassFromType(clazzType), false);
    }

    public static ClassSerializePropsCache getFirstCustomSerializeFields(Type clazzType) {
        Map<String, ClassSerializePropsCache> map = CustomJsonSerializeHelper.getCustomSerializeFields(CustomJsonSerializeHelper.parseClassFromType(clazzType), false);
        return map.isEmpty() ? null : map.values().iterator().next();
    }

    public static Class parseClassFromType(Type clazzType) {
        try {
            if (clazzType instanceof ParameterizedType) {
                return Class.forName(((ParameterizedType)clazzType).getRawType().getTypeName());
            }
            if (clazzType instanceof TypeVariable) {
                return CustomJsonSerializeHelper.parseClassFromType(((TypeVariable)clazzType).getBounds()[0]);
            }
            return Class.forName(clazzType.getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static Class parseClassFromName(Object clazzFullName) {
        try {
            return Class.forName(String.valueOf(clazzFullName));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static void visitClassAllFields(Class clazz, Function<Field, Boolean> consumer) {
        if (clazz == null || consumer == null) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (consumer.apply(field).booleanValue()) continue;
            return;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            CustomJsonSerializeHelper.visitClassAllFields(superClass, consumer);
        }
    }

    public static void visitClassAllMethods(Class clazz, Function<Method, Boolean> consumer) {
        if (clazz == null || consumer == null) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (consumer.apply(method).booleanValue()) continue;
            return;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            CustomJsonSerializeHelper.visitClassAllMethods(superClass, consumer);
        }
    }

    public static Map<String, ClassSerializePropsCache> _parseCustomSerializeFieldsEx(Class<?> clazz, String[] propertyNames) {
        if (clazz == null || propertyNames == null || propertyNames.length == 0) {
            return Collections.emptyMap();
        }
        boolean useFilterPropertyNames = propertyNames != null && propertyNames.length > 0;
        HashSet<String> _filterNames = new HashSet<String>(Arrays.asList(propertyNames));
        LinkedHashMap<String, ClassSerializePropsCache> properties = new LinkedHashMap<String, ClassSerializePropsCache>(8);
        HashSet lookupJsonProperties = new HashSet(8);
        CustomJsonSerializeHelper.visitClassAllFields(clazz, field -> {
            String jsonFieldName = CustomJsonSerializeHelper.isJSONFieldSerializable(field, field.getName());
            if (StringUtils.isEmpty((String)jsonFieldName) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) {
                return true;
            }
            if (!useFilterPropertyNames && !ICustomJsonSerialize.class.isAssignableFrom(field.getType()) || useFilterPropertyNames && !_filterNames.contains(jsonFieldName)) {
                return true;
            }
            try {
                Method writeMethod;
                PropertyDescriptor descriptor = new PropertyDescriptor(field.getName(), clazz);
                Method readMethod = descriptor.getReadMethod();
                if (readMethod == null || !Modifier.isPublic(readMethod.getModifiers()) || CustomJsonSerializeHelper.isJSONFieldSerializable(readMethod, readMethod.getName()) == null) {
                    descriptor.setReadMethod(null);
                    lookupJsonProperties.add(jsonFieldName);
                }
                if ((writeMethod = descriptor.getWriteMethod()) == null || !Modifier.isPublic(writeMethod.getModifiers()) || CustomJsonSerializeHelper.isJSONFieldSerializable(writeMethod, writeMethod.getName()) == null) {
                    descriptor.setWriteMethod(null);
                    lookupJsonProperties.add(jsonFieldName);
                }
                properties.put(jsonFieldName, new ClassSerializePropsCache(descriptor, (Field)field, jsonFieldName));
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e.getMessage());
            }
            return true;
        });
        if (!lookupJsonProperties.isEmpty()) {
            for (Method method : clazz.getMethods()) {
                JSONField jsonField;
                if (!Modifier.isPublic(method.getModifiers()) || !method.isAnnotationPresent(JSONField.class) || !(jsonField = method.getAnnotation(JSONField.class)).serialize() || !StringUtils.isNotEmpty((String)jsonField.name()) || !lookupJsonProperties.contains(jsonField.name())) continue;
                if (method.getParameterCount() > 0) {
                    ((ClassSerializePropsCache)properties.get(jsonField.name())).setWriteMethod(method);
                    continue;
                }
                ((ClassSerializePropsCache)properties.get(jsonField.name())).setReadMethod(method);
            }
        }
        return properties;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            return superClass != null && !superClass.equals(Object.class) ? CustomJsonSerializeHelper.getField(superClass, fieldName) : null;
        }
    }

    private static String isJSONFieldSerializable(AccessibleObject field, String objectName) {
        String jsonName = objectName;
        if (field.isAnnotationPresent(JSONField.class)) {
            JSONField jsonField = field.getAnnotation(JSONField.class);
            if (jsonField.serialize()) {
                return StringUtils.isNotEmpty((String)jsonField.name()) ? jsonField.name() : objectName;
            }
            return null;
        }
        return objectName;
    }

    private static class ThreadLocalMapContainer<K, V> {
        private final Map<K, V> map = new HashMap(4);

        private ThreadLocalMapContainer() {
        }

        public V get(K key) {
            return this.map.get(key);
        }

        public void put(K key, V value) {
            this.map.put(key, value);
        }
    }
}

