/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.v2.fah.cache.thread.ClassSerializePropsCache;
import kd.fi.v2.fah.serializer.CustomJsonSerializeHelper;
import kd.fi.v2.fah.utils.Assert;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;

public class SerializeCheckHelper {
    private static SerializeCheckHelper instance;
    private final Consumer<String> logOutputFunc;
    private final boolean enableLogOutput;

    private SerializeCheckHelper(Consumer<String> logOutputFunc) {
        this.logOutputFunc = logOutputFunc;
        this.enableLogOutput = this.logOutputFunc != null;
    }

    public static synchronized SerializeCheckHelper getOrBuildInstance(Consumer<String> logOutputFunc) {
        if (instance == null) {
            instance = new SerializeCheckHelper(logOutputFunc);
        }
        return instance;
    }

    private void printLog(String outputLogMsg) {
        if (this.enableLogOutput) {
            this.logOutputFunc.accept(outputLogMsg);
        }
    }

    public static SerializeConfig buildSerializeConfig(Class clazz, ObjectSerializer serializer) {
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.put((Type)clazz, serializer);
        return serializeConfig;
    }

    public static ParserConfig buildParserConfig(Class clazz, ObjectDeserializer deserializer) {
        ParserConfig parserConfig = new ParserConfig();
        parserConfig.putDeserializer((Type)clazz, deserializer);
        return parserConfig;
    }

    public <T> void checkJsonSerializeEx(T source, Class<T> clazz, SerializeConfig serializeConfig, ParserConfig parserConfig, boolean printLog, String logPrefix, Object ... checkContainValues) {
        Assert.assertNotNull(source);
        if (printLog) {
            this.printLog(String.format("%s[%s] Json Serialize Check:", logPrefix, clazz.getName()));
        }
        Object checkModel = null;
        SerializeConfig config = new SerializeConfig();
        String firstJsonStr = null;
        block4: for (int checkLoop = 0; checkLoop < 2; ++checkLoop) {
            String checkValueTxtBuf;
            switch (checkLoop) {
                case 0: {
                    String string = firstJsonStr = serializeConfig != null ? JSON.toJSONString(source, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]) : JSON.toJSONString(source, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
                    if (printLog) {
                        this.printLog(String.format("\t%sOriginal=%s", logPrefix, firstJsonStr));
                    }
                    checkValueTxtBuf = firstJsonStr;
                    break;
                }
                case 1: {
                    String reCheckJsonStr;
                    checkModel = parserConfig != null ? JSON.parseObject((String)firstJsonStr, clazz, (ParserConfig)parserConfig, (Feature[])new Feature[0]) : JSON.parseObject(firstJsonStr, clazz);
                    Assert.assertNotNull(checkModel);
                    String string = reCheckJsonStr = serializeConfig != null ? JSON.toJSONString((Object)checkModel, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]) : JSON.toJSONString((Object)checkModel, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
                    if (printLog) {
                        this.printLog(String.format("\t%sRe-Check=%s", logPrefix, reCheckJsonStr));
                    }
                    checkValueTxtBuf = reCheckJsonStr;
                    Assert.assertEquals(firstJsonStr, reCheckJsonStr);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            Assert.assertTrue(checkValueTxtBuf != null && !"".equals(checkValueTxtBuf.trim()));
            if (checkContainValues == null || checkContainValues.length <= 0) continue;
            for (Object check : checkContainValues) {
                if (check == null) continue;
                if (check instanceof Number || check instanceof Boolean) {
                    Assert.assertTrue(String.format("Expect Number Value:%s", check), checkValueTxtBuf != null && checkValueTxtBuf.contains(":" + check));
                    continue;
                }
                Assert.assertTrue(String.format("Expect String Value:%s", check), checkValueTxtBuf != null && checkValueTxtBuf.contains("\"" + check + "\""));
            }
        }
        if (printLog) {
            this.printLog(String.format("\t%sCompare Serialize and De-Serialize Model Properties:", logPrefix));
        }
        this.compareSerializeModel(source, checkModel, clazz);
    }

    public <T> void checkJsonSerializeEx(T source, Class<T> clazz, SerializeConfig serializeConfig, ParserConfig parserConfig, boolean printLog, Object ... checkContainValues) {
        this.checkJsonSerializeEx(source, clazz, serializeConfig, parserConfig, printLog, "", checkContainValues);
    }

    public <T> void checkJsonSerialize(T source, Class<T> clazz, ObjectSerializer serializer, ObjectDeserializer deserializer, boolean printLog, String logPrefix, Object ... checkContainValues) {
        SerializeConfig serializeConfig = serializer != null ? SerializeCheckHelper.buildSerializeConfig(clazz, serializer) : null;
        ParserConfig parserConfig = deserializer != null ? SerializeCheckHelper.buildParserConfig(clazz, deserializer) : null;
        this.checkJsonSerializeEx(source, clazz, serializeConfig, parserConfig, printLog, logPrefix, checkContainValues);
    }

    public <T> void checkJsonSerialize(T source, Class<T> clazz, ObjectSerializer serializer, ObjectDeserializer deserializer, boolean printLog, Object ... checkContainValues) {
        this.checkJsonSerialize(source, clazz, serializer, deserializer, printLog, "", checkContainValues);
    }

    public <T> T doJsonReSerialize(T source, Class<T> clazz, ObjectSerializer serializer, ObjectDeserializer deserializer, boolean printLog, String logPrefix) {
        String firstJsonStr;
        if (printLog) {
            this.printLog(String.format("%s[%s] Get Json Re-Serialize Java Object:", logPrefix, clazz.getName()));
        }
        String string = firstJsonStr = serializer != null ? JSON.toJSONString(source, (SerializeConfig)SerializeCheckHelper.buildSerializeConfig(clazz, serializer), (SerializerFeature[])new SerializerFeature[0]) : JSON.toJSONString(source);
        if (printLog) {
            this.printLog(String.format("\t%sOriginal=%s", logPrefix, firstJsonStr));
        }
        return (T)(deserializer != null ? JSON.parseObject((String)firstJsonStr, clazz, (ParserConfig)SerializeCheckHelper.buildParserConfig(clazz, deserializer), (Feature[])new Feature[0]) : JSON.parseObject((String)firstJsonStr, clazz));
    }

    public <T> T doJsonReSerialize(T source, Class<T> clazz, ObjectSerializer serializer, ObjectDeserializer deserializer, boolean printLog) {
        return this.doJsonReSerialize(source, clazz, serializer, deserializer, printLog, "");
    }

    public <T> T doJsonReSerialize(T source, Class<T> clazz, boolean printLog, String logPrefix) {
        return this.doJsonReSerialize(source, clazz, null, null, printLog, logPrefix);
    }

    public <T> T doJsonReSerialize(T source, Class<T> clazz, boolean printLog) {
        return this.doJsonReSerialize(source, clazz, null, null, printLog);
    }

    public <T> void checkJsonSerialize(T source, Class<T> clazz, boolean printLog, String logPrefix, Object ... checkContainValues) {
        this.checkJsonSerialize(source, clazz, null, null, printLog, logPrefix, checkContainValues);
    }

    public <T> void checkJsonSerialize(T source, Class<T> clazz, boolean printLog, Object ... checkContainValues) {
        this.checkJsonSerialize(source, clazz, null, null, printLog, "", checkContainValues);
    }

    public <T> void compareSerializeModel(T source, T checkTarget, Class<T> clazz) {
        Map<String, ClassSerializePropsCache> fieldInfos = CustomJsonSerializeHelper.parseSerializableProperties(clazz, true, false);
        ClassSerializePropsCache currentFeild = null;
        try {
            Iterator<ClassSerializePropsCache> iterator = fieldInfos.values().iterator();
            while (iterator.hasNext()) {
                ClassSerializePropsCache field;
                currentFeild = field = iterator.next();
                Object expectValue = field.getReadMethod().invoke(source, new Object[0]);
                Object checkValue = field.getReadMethod().invoke(checkTarget, new Object[0]);
                if (Date.class.isAssignableFrom(field.getField().getDeclaringClass())) {
                    expectValue = ((Date)expectValue).getTime();
                    checkValue = ((Date)checkValue).getTime();
                }
                Assert.assertTrue(String.format("Error on field:[%s.%s], %s: \n\tExpect:%s, \n\tActual:%s", clazz.getName(), currentFeild.getFieldName(), currentFeild, expectValue, checkValue), ICommonDataValueUtil.deepEquals(expectValue, checkValue));
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(currentFeild + ": " + e.getMessage(), e);
        }
    }

    public <T> void checkBase64Serialize(T source, Class<T> clazz, boolean printLog, String logPrefix) {
        Assert.assertNotNull(source);
        if (printLog) {
            this.printLog(String.format("%s[%s] Base64 Serialize Check:", logPrefix, clazz.getName()));
        }
        String firstSerializeStr = SerializationUtils.serializeToBase64(source);
        if (printLog) {
            this.printLog(String.format("\t%sOriginal:%s", logPrefix, firstSerializeStr));
        }
        Assert.assertNotNull(firstSerializeStr);
        Object checkModel = SerializationUtils.deSerializeFromBase64((String)firstSerializeStr);
        Assert.assertNotNull(checkModel);
        String reCheckSerializeStr = SerializationUtils.serializeToBase64((Object)checkModel);
        if (printLog) {
            this.printLog(String.format("\t%sRe-Check:%s", logPrefix, reCheckSerializeStr));
        }
        Assert.assertNotNull(reCheckSerializeStr);
        this.compareSerializeModel(source, checkModel, clazz);
    }

    public <T> void checkBase64Serialize(T source, Class<T> clazz, boolean printLog) {
        this.checkBase64Serialize(source, clazz, printLog, "");
    }
}

