/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.sqlbuilder.filter;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import kd.bos.orm.query.QFilter;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.sqlbuilder.filter.ISimpleQFilterGroupItem;

public class SimpleQFilter
implements ISimpleQFilterGroupItem,
Serializable {
    public static String in = "in";
    public static String like = "like";
    public static String large_equals = ">=";
    public static String less_equals = "<=";
    @JSONField(ordinal=1)
    protected String property;
    @JSONField(ordinal=2)
    protected String cp;
    @JSONField(ordinal=3)
    protected ObjectConverterFactory.CommonDataTypeEnums dataValueType;
    @JSONField(ordinal=4)
    protected Object filterValue;
    protected boolean useAndJoin;
    protected transient boolean hasMulValue;

    public SimpleQFilter() {
    }

    public SimpleQFilter(String property, String cp, Object value, ObjectConverterFactory.CommonDataTypeEnums dataValueType) {
        this.property = property;
        this.dataValueType = dataValueType;
        this.cp = cp;
        this.hasMulValue = false;
        this.setFilterValue(value);
    }

    public SimpleQFilter(String cp, Object value, ObjectConverterFactory.CommonDataTypeEnums dataValueType) {
        this(null, cp, value, dataValueType);
    }

    public SimpleQFilter(Object value, ObjectConverterFactory.CommonDataTypeEnums dataValueType) {
        this(null, null, value, dataValueType);
        if (this.cp == null) {
            this.cp = this.hasMulValue ? "in" : "=";
        }
    }

    public SimpleQFilter(QFilter filter) {
        this(filter.getProperty(), filter.getCP(), filter.getValue(), ObjectConverterFactory.CommonDataTypeEnums.ObjectType);
    }

    public String toString() {
        return "SimpleQFilter{property='" + this.property + '\'' + ", cp='" + this.cp + '\'' + ", value=" + this.filterValue + ", hasMulValue=" + this.hasMulValue + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleQFilter)) {
            return false;
        }
        SimpleQFilter that = (SimpleQFilter)o;
        return Objects.equals(this.property, that.property) && Objects.equals(this.cp, that.cp) && Objects.equals(this.filterValue, that.filterValue);
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int hashCode() {
        return Objects.hash(this.property, this.cp, this.filterValue);
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getCp() {
        return this.cp;
    }

    public void setCp(String cp) {
        this.cp = cp;
    }

    public Object getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(Object filterValue) {
        this.hasMulValue = false;
        if (filterValue != null) {
            if (filterValue instanceof Collection || filterValue.getClass().isArray() || filterValue instanceof Iterator) {
                this.hasMulValue = true;
                filterValue = this.dataValueType != null ? IDataValueUtil.enumerateObjectToList((Object)filterValue, this.dataValueType.getConverter()::convert) : IDataValueUtil.enumerateObjectToList((Object)filterValue);
            } else if (this.dataValueType == ObjectConverterFactory.CommonDataTypeEnums.Date) {
                filterValue = ObjectConverterFactory.convert(filterValue, Date.class);
            }
        }
        this.filterValue = filterValue;
    }

    public QFilter converToQFilter(QFilter targetFilter) {
        QFilter newFilter = this.converToQFilter();
        return targetFilter == null ? newFilter : (this.useAndJoin ? targetFilter.and(newFilter) : targetFilter.or(newFilter));
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public QFilter converToQFilter() {
        return new QFilter(this.property, this.cp, this.dataValueType != null ? this.dataValueType.getConverter().convert(this.filterValue) : this.filterValue);
    }

    public static QFilter[] convertToQFilter(SimpleQFilter[] srcFilters) {
        if (srcFilters == null || srcFilters.length == 0) {
            return null;
        }
        QFilter[] qFilters = new QFilter[srcFilters.length];
        int i = 0;
        for (SimpleQFilter filter : srcFilters) {
            qFilters[i++] = filter.converToQFilter();
        }
        return qFilters;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isHasMulValue() {
        return this.hasMulValue;
    }

    public ObjectConverterFactory.CommonDataTypeEnums getDataValueType() {
        return this.dataValueType;
    }

    public void setDataValueType(ObjectConverterFactory.CommonDataTypeEnums dataValueType) {
        this.dataValueType = dataValueType;
    }

    public boolean isUseAndJoin() {
        return this.useAndJoin;
    }

    public void setUseAndJoin(boolean useAndJoin) {
        this.useAndJoin = useAndJoin;
    }
}

