/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.sqlbuilder.impl;

import java.util.Arrays;
import java.util.BitSet;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.utils.FastHashHelper;

public class ArrayBaseSqlParamBuffer
implements ISqlParamBuffer {
    protected final int[] bufRealAddress;
    private Object[] values;
    private IInsertSqlBuilder parentBuilder;
    protected int currentRowIndex;
    protected int paramWritePos;
    protected transient BitSet dataIsDirtyFlag;
    protected final transient boolean __hasWriteableColumn;
    protected transient boolean __hasRowBuffer;

    public ArrayBaseSqlParamBuffer(IInsertSqlBuilder parentBuilder, int paramWritePos, int[] bufRealAddress) {
        this.parentBuilder = parentBuilder;
        this.bufRealAddress = bufRealAddress;
        this.__hasWriteableColumn = bufRealAddress != null ? bufRealAddress.length > 0 : false;
        this.__hasRowBuffer = false;
        this.currentRowIndex = -1;
        this.paramWritePos = paramWritePos;
        this.dataIsDirtyFlag = new BitSet();
    }

    @Override
    public int size() {
        return this.__hasRowBuffer ? this.values.length : 0;
    }

    @Override
    public void updateParamBuffer(int currentRowIndex, Object[] values) {
        this.currentRowIndex = currentRowIndex;
        this.dataIsDirtyFlag.clear();
        this.values = values;
        this.__hasRowBuffer = values != null && values.length > 0;
    }

    @Override
    public int moveToNextParamRow() {
        if (this.parentBuilder == null) {
            throw new IllegalArgumentException("Parent Sql Builder is null!");
        }
        this.currentRowIndex = this.parentBuilder.moveToNextParamRow(this);
        return this.currentRowIndex;
    }

    @Override
    public boolean hasUnchangedCacheRow() {
        return this.__hasRowBuffer && this.dataIsDirtyFlag.isEmpty();
    }

    @Override
    public void clearDataChangeFlag() {
        this.dataIsDirtyFlag.clear();
    }

    @Override
    public boolean isColumnBufferHashData(int columnIndex) {
        return this.dataIsDirtyFlag.get(columnIndex);
    }

    @Override
    public int getParamWritePos() {
        return this.paramWritePos;
    }

    @Override
    public Object get(int columnIndex) {
        return this.__hasWriteableColumn && this.__hasRowBuffer ? this.values[this.getColumnWritePos(columnIndex)] : null;
    }

    @Override
    public Object directGetValue(int columnIndex) {
        return this.__hasRowBuffer ? this.values[columnIndex] : null;
    }

    @Override
    public long getHashCode() {
        return FastHashHelper.getHashCode(this.values);
    }

    @Override
    public Object[] getValues() {
        return this.values;
    }

    @Override
    public void set(int columnIndex, Object newValue) {
        if (this.__hasWriteableColumn) {
            this.__directSetValue(columnIndex, this.getColumnWritePos(columnIndex), newValue);
        }
    }

    @Override
    public void directSetValue(int columnIndex, Object newValue) {
        this.__directSetValue(columnIndex, columnIndex, newValue);
    }

    private void __directSetValue(int realColumnIndex, int arrayReadIndex, Object newValue) {
        if (!this.__hasRowBuffer) {
            this.moveToNextParamRow();
        }
        this.values[arrayReadIndex] = newValue;
        if (newValue == null && this.dataIsDirtyFlag.get(realColumnIndex)) {
            this.dataIsDirtyFlag.clear(realColumnIndex);
        } else {
            this.dataIsDirtyFlag.set(realColumnIndex);
        }
    }

    @Override
    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    @Override
    public void clear() {
        this.values = null;
        this.__hasRowBuffer = false;
        this.currentRowIndex = -1;
        this.clearDataChangeFlag();
    }

    @Override
    public void resetRowData() {
        if (this.parentBuilder == null) {
            throw new IllegalArgumentException("Parent Sql Builder is null!");
        }
        if (!this.__hasRowBuffer) {
            return;
        }
        Object[] template = this.parentBuilder.getConstantColumnValues();
        this.clearDataChangeFlag();
        if (template != null) {
            System.arraycopy(template, 0, this.values, 0, template.length);
        } else {
            Arrays.fill(this.values, null);
        }
    }

    @Override
    public void fetchStorageDataRow(Object[] srcRowData, Object[] outputBuffer, int[] srcColumnPos) {
        if (!this.__hasWriteableColumn) {
            return;
        }
        int out_i = 0;
        for (int srcColPos : srcColumnPos) {
            outputBuffer[out_i++] = srcRowData[this.getColumnWritePos(srcColPos)];
        }
    }

    @Override
    public int getColumnWritePos(int columnPos) {
        return this.__hasWriteableColumn ? this.paramWritePos + this.bufRealAddress[columnPos] : -1;
    }

    @Override
    public int getWriteableColumnCnt() {
        return this.bufRealAddress != null ? this.bufRealAddress.length : 0;
    }
}

