/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.sqlbuilder.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.constant.enums.NotNull;
import kd.fi.v2.fah.constant.enums.SqlStatementType;
import kd.fi.v2.fah.sqlbuilder.AbstractBaseSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.IAddSqlColumn;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.SQLColumnInfo;
import kd.fi.v2.fah.sqlbuilder.impl.ArrayBaseSqlParamBuffer;
import kd.fi.v2.fah.utils.StringUtils;

public class BaseInsertSqlBuilder<BATCH_ID>
extends AbstractBaseSqlBuilder<BATCH_ID>
implements IInsertSqlBuilder<BATCH_ID> {
    protected Object[] _constantColumnValues;
    protected int _paramBufferWritePos = -1;
    protected List<Object[]> sqlParams = new ArrayList<Object[]>(32);
    protected ISqlParamBuffer sqlParamBuffer;
    protected transient boolean _newRowCopyFromTemplate = false;
    protected transient Function<Integer, Object[]> idGeneratorFunction;
    protected long startSeqNo;
    protected boolean needGetLastMaxSeqNo;
    protected boolean needAutoUpdateSeqNo;
    protected transient int _lastAutoUpdateRowPos;

    public BaseInsertSqlBuilder(BATCH_ID batchId, String tableName, Function<Integer, Object[]> idGeneratorFunction) {
        super(batchId, SqlStatementType.Insert, tableName);
        this.idGeneratorFunction = idGeneratorFunction;
        this.startSeqNo = -1L;
        this._lastAutoUpdateRowPos = -1;
        this.needGetLastMaxSeqNo = true;
        this.needAutoUpdateSeqNo = false;
    }

    public BaseInsertSqlBuilder(BATCH_ID batchId, String tableName) {
        this(batchId, tableName, null);
    }

    @Override
    public String toString() {
        return "BaseInsertSqlBuilder{sqlStatementType=" + (Object)((Object)this.sqlStatementType) + ", batchId=" + this.batchId + ", tableName='" + this.tableName + '\'' + ", columns=" + this.columns + ", _totalColumnCnt=" + this._totalColumnCnt + ", _paramBufferWritePos=" + this._paramBufferWritePos + ", sqlParamBuffer=" + this.sqlParamBuffer + ", _newRowCopyFromTemplate=" + this._newRowCopyFromTemplate + ", needAutoUpdateSeqNo=" + this.needAutoUpdateSeqNo + ", idGeneratorFunction=" + this.idGeneratorFunction + ", _constantColumnValues=" + Arrays.toString(this._constantColumnValues) + '}';
    }

    @Override
    public int addSingleColumn(IAddSqlColumn.ColumnGrpType columnGrpType, String columnNumber, IAddSqlColumn.ColumnUsageType columnUsageType, Object ... columnParams) {
        int colIndex = super.addSingleColumn(columnGrpType, columnNumber, columnUsageType, columnParams);
        if (columnGrpType == IAddSqlColumn.ColumnGrpType.ConstantValueColumn) {
            ++this._paramBufferWritePos;
        }
        return colIndex;
    }

    public int getWriteableColumnCnt() {
        return this._totalColumnCnt - this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()];
    }

    protected int[] getColumnAddressMapping() {
        int[] columnTypeWriteOffset = new int[IAddSqlColumn.ColumnGrpType.values().length];
        columnTypeWriteOffset[IAddSqlColumn.ColumnGrpType.FixPosColumn.getSeq()] = 0;
        columnTypeWriteOffset[IAddSqlColumn.ColumnGrpType.FlexColumn.getSeq()] = this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.FixPosColumn.getSeq()];
        int[] colAdrMapping = new int[this.getWriteableColumnCnt()];
        int writeColIdx = 0;
        for (SQLColumnInfo col : this.columns) {
            if (col.getColumnGrpType() == IAddSqlColumn.ColumnGrpType.ConstantValueColumn) continue;
            colAdrMapping[writeColIdx++] = columnTypeWriteOffset[col.getColumnGrpType().getSeq()] + col.getColumnGrpSeq();
        }
        return colAdrMapping;
    }

    @Override
    public void clearSqlParamData() {
        if (this.sqlParams != null) {
            this.sqlParams.clear();
        }
        if (this.sqlParamBuffer != null) {
            this.sqlParamBuffer.clear();
        }
        this._lastAutoUpdateRowPos = -1;
    }

    @Override
    public ISqlParamBuffer getSqlParamBuffer() {
        if (this.sqlParamBuffer == null) {
            this.sqlParamBuffer = new ArrayBaseSqlParamBuffer(this, this.columnTypeCnt != null ? this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()] : 0, this.getColumnAddressMapping());
        }
        return this.sqlParamBuffer;
    }

    protected Object[] createNewRow(Object[] template) {
        if (this.sqlParamBuffer != null && this.sqlParamBuffer.getValues() != null && this.sqlParamBuffer.hasUnchangedCacheRow()) {
            return null;
        }
        Object[] newRow = new Object[this._totalColumnCnt];
        if (this._newRowCopyFromTemplate) {
            System.arraycopy(template, 0, newRow, 0, template.length);
        }
        return newRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int moveToNextParamRow(@NotNull ISqlParamBuffer paramBuffer) {
        int index;
        Object[] newRow = this.createNewRow(this.getConstantColumnValues());
        if (newRow == null) {
            return paramBuffer.getCurrentRowIndex();
        }
        BaseInsertSqlBuilder baseInsertSqlBuilder = this;
        synchronized (baseInsertSqlBuilder) {
            index = this.sqlParams.size();
            this.sqlParams.add(newRow);
        }
        paramBuffer.updateParamBuffer(index, newRow);
        return index;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void completeAndPack() {
        if (this.sqlParamBuffer != null && !this.sqlParams.isEmpty() && this.sqlParamBuffer.hasUnchangedCacheRow()) {
            if (this.sqlParams instanceof LinkedList) {
                ((LinkedList)this.sqlParams).removeLast();
            } else if (this.sqlParams instanceof ArrayList) {
                ((ArrayList)this.sqlParams).remove(this.sqlParams.size() - 1);
            }
        }
        if (this.sqlParamBuffer != null) {
            this.sqlParamBuffer.clear();
        }
    }

    @Override
    public StringBuilder buildSqlStatement(Object ... params) {
        int sqlParamCnt;
        Collection<String> columNames = this.getSqlColumnNames();
        int n = sqlParamCnt = columNames != null ? columNames.size() : 0;
        if (sqlParamCnt == 0) {
            throw new IllegalArgumentException("SQL Column cannot be null");
        }
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("insert into ").append(this.getSqlTableName());
        sqlBuffer.append(" (").append(StringUtils.collectionToString(columNames)).append(") values ").append(QFilterBuilder.buildSQLParamHolder((int)sqlParamCnt));
        return sqlBuffer;
    }

    @Override
    public int getSqlParamColumnCnt() {
        return this._totalColumnCnt;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int getSqlParamRowCnt() {
        return this.sqlParams.size();
    }

    public int updateAutoColumnValues(boolean onlyNewAddRow) {
        int newRowCnt;
        if (this.sqlParams == null || this.sqlParams.isEmpty() || !this.needAutoUpdateSeqNo && this.idGeneratorFunction == null) {
            return 0;
        }
        int totalRowCnt = this.sqlParams.size();
        boolean onlyUpdateNewRow = onlyNewAddRow && this._lastAutoUpdateRowPos > 0;
        int newRowStartPos = this._lastAutoUpdateRowPos + 1;
        int n = newRowCnt = onlyUpdateNewRow ? totalRowCnt - newRowStartPos : totalRowCnt;
        if (newRowCnt <= 0) {
            return 0;
        }
        boolean needUpdatePk = this.idGeneratorFunction != null && this.PK_Column_Index >= 0;
        Object[] ids = needUpdatePk ? this.idGeneratorFunction.apply(newRowCnt) : null;
        long seq = onlyUpdateNewRow ? this.startSeqNo + (long)newRowStartPos : this.startSeqNo;
        int rowIdx = 0;
        int pkIdx = 0;
        for (Object[] row : this.sqlParams) {
            if (onlyUpdateNewRow && rowIdx++ < newRowStartPos) continue;
            if (this.needAutoUpdateSeqNo) {
                row[this.Seq_Column_Index] = seq++;
            }
            if (!needUpdatePk || ids == null) continue;
            row[this.PK_Column_Index] = ids[pkIdx++];
        }
        this._lastAutoUpdateRowPos = totalRowCnt - 1;
        return newRowCnt;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public List<Object[]> getSqlParams() {
        ArrayList<Object[]> result;
        if (null == this.sqlParams) {
            return Collections.emptyList();
        }
        this.updateAutoColumnValues(true);
        ArrayList<Object[]> arrayList = result = this.sqlParams instanceof ArrayList ? this.sqlParams : new ArrayList<Object[]>(this.sqlParams);
        if (this.sqlParamBuffer != null && this.sqlParamBuffer.hasUnchangedCacheRow()) {
            return result.subList(0, this.sqlParams.size() - 1);
        }
        return result;
    }

    @Override
    public Iterator<List<Object[]>> getSqlParams(final int batchSize) {
        this.updateAutoColumnValues(true);
        if (batchSize < 0) {
            LinkedList<ArrayList<Object[]>> result = new LinkedList<ArrayList<Object[]>>();
            result.add(new ArrayList<Object[]>(this.sqlParams));
            return result.iterator();
        }
        return new Iterator<List<Object[]>>(){
            final boolean eof;
            final Iterator<Object[]> srcIterator;
            final List<Object[]> bufferList;
            {
                this.eof = BaseInsertSqlBuilder.this.sqlParams == null;
                this.srcIterator = BaseInsertSqlBuilder.this.sqlParams != null ? BaseInsertSqlBuilder.this.sqlParams.iterator() : null;
                this.bufferList = new ArrayList<Object[]>(batchSize);
            }

            @Override
            public boolean hasNext() {
                return !this.eof && this.srcIterator.hasNext();
            }

            @Override
            public List<Object[]> next() {
                this.bufferList.clear();
                int currentRowIdx = 0;
                while (currentRowIdx < batchSize && this.srcIterator.hasNext()) {
                    Object[] rowBuf = this.srcIterator.next();
                    if (rowBuf == null) continue;
                    this.bufferList.add(rowBuf);
                    ++currentRowIdx;
                }
                return this.bufferList;
            }
        };
    }

    public boolean isNewRowCopyFromTemplate() {
        return this._newRowCopyFromTemplate;
    }

    @Override
    public int getParamBufferWritePos() {
        return this._paramBufferWritePos;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Object[] getConstantColumnValues() {
        if (this._constantColumnValues == null && this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()] > 0) {
            this._constantColumnValues = new Object[this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()]];
            int i = 0;
            for (SQLColumnInfo col : this.columns) {
                if (col.getColumnGrpType() != IAddSqlColumn.ColumnGrpType.ConstantValueColumn) continue;
                this._constantColumnValues[i++] = col.getColumnValue();
            }
            this._newRowCopyFromTemplate = true;
        }
        return this._constantColumnValues;
    }

    @Override
    public void cleanColumns(IAddSqlColumn.ColumnGrpType ... columnGrpTypes) {
        super.cleanColumns(columnGrpTypes);
        this._paramBufferWritePos = -1;
        this._lastAutoUpdateRowPos = -1;
        this.sqlParams.clear();
        this.sqlParamBuffer = null;
    }

    public Iterator<Object[]> selectSqlParamDataRows(final int[] columnPos, final boolean duplicateCopy) {
        if (this.sqlParams == null || columnPos == null || columnPos.length == 0) {
            throw new IllegalArgumentException();
        }
        return new Iterator<Object[]>(){
            final int totalOutputColumnCnt;
            final int[] outputColumnPos;
            final Iterator<Object[]> srcDataIterator;
            Object[] outputBuffer;
            Object[] srcRowBuffer;
            {
                this.totalOutputColumnCnt = columnPos.length;
                this.outputColumnPos = columnPos;
                this.srcDataIterator = BaseInsertSqlBuilder.this.sqlParams.iterator();
                this.outputBuffer = duplicateCopy ? null : new Object[this.totalOutputColumnCnt];
            }

            @Override
            public boolean hasNext() {
                return this.srcDataIterator.hasNext();
            }

            @Override
            public Object[] next() {
                if (this.hasNext()) {
                    if (duplicateCopy) {
                        this.outputBuffer = new Object[this.totalOutputColumnCnt];
                    } else {
                        Arrays.fill(this.outputBuffer, null);
                    }
                    this.srcRowBuffer = this.srcDataIterator.next();
                    if (this.srcRowBuffer != null) {
                        BaseInsertSqlBuilder.this.sqlParamBuffer.fetchStorageDataRow(this.srcRowBuffer, this.outputBuffer, this.outputColumnPos);
                    }
                }
                return this.outputBuffer;
            }
        };
    }

    @Override
    public Collection<SQLColumnInfo> getAddColumns() {
        return this.columns;
    }

    @Override
    public Function<Integer, Object[]> getIdGeneratorFunction() {
        return this.idGeneratorFunction;
    }

    @Override
    public void setIdGeneratorFunction(Function<Integer, Object[]> idGeneratorFunction) {
        this.idGeneratorFunction = idGeneratorFunction;
    }

    @Override
    public long getStartSeqNo() {
        return this.startSeqNo;
    }

    @Override
    public void setStartSeqNo(long startSeqNo) {
        this.startSeqNo = startSeqNo;
    }

    @Override
    public boolean isNeedGetLastMaxSeqNo() {
        return this.needGetLastMaxSeqNo;
    }

    public void setNeedGetLastMaxSeqNo(boolean needGetLastMaxSeqNo) {
        this.needGetLastMaxSeqNo = needGetLastMaxSeqNo;
    }

    public boolean isNeedAutoUpdateSeqNo() {
        return this.needAutoUpdateSeqNo;
    }

    public void setNeedAutoUpdateSeqNo(boolean needAutoUpdateSeqNo) {
        this.needAutoUpdateSeqNo = needAutoUpdateSeqNo;
    }

    public void setSqlParams(List<Object[]> sqlParams) {
        this.sqlParams = sqlParams;
    }

    public void setColumnValue(int columnPos, Object value) {
        if (this.sqlParams != null) {
            int columnWritePos = this.sqlParamBuffer.getColumnWritePos(columnPos);
            this.sqlParams.forEach(rowBuffer -> {
                rowBuffer[columnWritePos] = value;
            });
        }
    }

    public void updateColumnValue(int columnPos, Function<Object, Object> valueUpdateFunc) {
        if (this.sqlParams != null) {
            int columnWritePos = this.sqlParamBuffer.getColumnWritePos(columnPos);
            this.sqlParams.forEach(rowBuffer -> {
                rowBuffer[columnWritePos] = valueUpdateFunc.apply(rowBuffer[columnWritePos]);
            });
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int get_lastAutoUpdateRowPos() {
        return this._lastAutoUpdateRowPos;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public boolean is_newRowCopyFromTemplate() {
        return this._newRowCopyFromTemplate;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int get_paramBufferWritePos() {
        return this._paramBufferWritePos;
    }
}

