/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.sqlbuilder.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import kd.fi.bd.util.iterators.impl.IntArraySequenceIterator;
import kd.fi.bd.util.iterators.impl.IntArraySequenceIteratorBuilder;
import kd.fi.v2.fah.sqlbuilder.IAddSqlColumn;
import kd.fi.v2.fah.sqlbuilder.IMultiValueInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.SQLColumnInfo;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;

public class MulValueInsertSqlBuilder<BATCH_ID>
extends BaseInsertSqlBuilder<BATCH_ID>
implements IMultiValueInsertSqlBuilder<BATCH_ID> {
    public static final int Default_Batch_Size = 2000;
    protected int multiValueColumnCnt;
    protected transient int[] mulValColPos;

    public MulValueInsertSqlBuilder(BATCH_ID batchId, String tableName, long startSeqNo, Function<Integer, Object[]> idGeneratorFunction) {
        super(batchId, tableName, idGeneratorFunction);
        this.startSeqNo = startSeqNo;
        this.needGetLastMaxSeqNo = this.startSeqNo < 0L;
        this.multiValueColumnCnt = 0;
    }

    public MulValueInsertSqlBuilder(BATCH_ID batchId, String tableName, Function<Integer, Object[]> idGeneratorFunction) {
        super(batchId, tableName, idGeneratorFunction);
        this.startSeqNo = -1L;
        this.needGetLastMaxSeqNo = true;
        this.multiValueColumnCnt = 0;
    }

    public MulValueInsertSqlBuilder(BATCH_ID batchId, String tableName, long startSeqNo) {
        super(batchId, tableName);
        this.startSeqNo = startSeqNo;
        this.multiValueColumnCnt = 0;
    }

    public int addMultiValueColumn(String columnNumber, Object ... columnParams) {
        int pos = this.addSingleColumn(IAddSqlColumn.ColumnGrpType.FixPosColumn, columnNumber, IAddSqlColumn.ColumnUsageType.Multi_Value, columnParams);
        if (pos >= 0) {
            ++this.multiValueColumnCnt;
        }
        return pos;
    }

    protected int[] getMultiValueColumnPos(int constColumnOffset) {
        if (this.multiValueColumnCnt <= 0) {
            return new int[0];
        }
        if (this.mulValColPos == null) {
            int i = 0;
            int writeableColndex = 0;
            this.mulValColPos = new int[this.multiValueColumnCnt];
            for (SQLColumnInfo columnInfo : this.columns) {
                if (columnInfo == null || columnInfo.getColumnGrpType() == IAddSqlColumn.ColumnGrpType.ConstantValueColumn) continue;
                if (columnInfo.getColumnUsageType() == IAddSqlColumn.ColumnUsageType.Multi_Value) {
                    this.mulValColPos[i++] = constColumnOffset + writeableColndex;
                }
                ++writeableColndex;
            }
        }
        return this.mulValColPos;
    }

    protected BitSet getMultiValueColumnPosBitSet(int constColumnOffset) {
        int[] mulValColPos = this.getMultiValueColumnPos(constColumnOffset);
        BitSet result = new BitSet(this.multiValueColumnCnt);
        for (int i : mulValColPos) {
            result.set(i);
        }
        return result;
    }

    protected BitSet getMultiValueColumnPosBitSet() {
        return this.getMultiValueColumnPosBitSet(this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()]);
    }

    @Override
    public int getSqlParamRowCnt() {
        if (this.multiValueColumnCnt <= 0) {
            return this.sqlParams != null ? this.sqlParams.size() : 0;
        }
        int totalRowCnt = 0;
        int[] mulValColPos = this.getMultiValueColumnPos(this.columnTypeCnt[IAddSqlColumn.ColumnGrpType.ConstantValueColumn.getSeq()]);
        for (Object[] param : this.sqlParams) {
            if (param == null || param.length == 0) continue;
            int grpRowCnt = 1;
            int[] nArray = mulValColPos;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Collection multiValListBuf;
                Integer idx = nArray[i];
                if (!(param[idx] instanceof Collection) || (multiValListBuf = (Collection)param[idx]).isEmpty()) continue;
                grpRowCnt *= multiValListBuf.size();
            }
            totalRowCnt += grpRowCnt;
        }
        return totalRowCnt;
    }

    @Override
    public List<Object[]> getSqlParams() {
        if (this.sqlParams == null || this.sqlParams.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        BitSet mulValuePos = this.getMultiValueColumnPosBitSet();
        if (mulValuePos.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        MultiValueIterator valueIterator = new MultiValueIterator(this._totalColumnCnt, this.startSeqNo, 2000, mulValuePos, this.sqlParams.iterator());
        if (!valueIterator.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Object[]> resultList = new LinkedList<Object[]>();
        while (valueIterator.hasNext()) {
            valueIterator.next().forEach(v -> resultList.add((Object[])v));
        }
        return resultList;
    }

    public static int getMaxArrayLength() {
        Runtime runtime = Runtime.getRuntime();
        return (int)((runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory())) / 8L);
    }

    @Override
    public Iterator<List<Object[]>> getSqlParams(int batchSize) {
        if (batchSize <= 0 || this.sqlParams == null || this.sqlParams.isEmpty()) {
            return super.getSqlParams(batchSize);
        }
        return new MultiValueIterator(this._totalColumnCnt, this.startSeqNo, batchSize, this.getMultiValueColumnPosBitSet(), this.sqlParams.iterator());
    }

    public class MultiValueIterator
    implements Iterator<List<Object[]>> {
        protected final int totalColumnCnt;
        protected final int _batchSize;
        protected long lastSeqNo;
        protected final BitSet mulValColPos;
        protected Iterator<Object[]> srcValueIterator;
        protected transient IntArraySequenceIterator comboValueIterator;
        protected boolean eof = false;
        protected transient List<Object[]> rowBufferList;

        public MultiValueIterator(int totalColumnCnt, long startSeqNo, int batchSize, BitSet mulValColPos, Iterator<Object[]> srcValueIterator) {
            this.srcValueIterator = srcValueIterator;
            if (this.srcValueIterator == null) {
                throw new IllegalArgumentException("Source Value Iterator cannot be null!");
            }
            this.mulValColPos = mulValColPos;
            if (this.mulValColPos == null || mulValColPos.isEmpty()) {
                throw new IllegalArgumentException("Multi-Value Source Column Index cannot be null!");
            }
            this._batchSize = batchSize;
            if (this._batchSize <= 0) {
                throw new IllegalArgumentException("Batch Size must greater than 0!");
            }
            this.lastSeqNo = startSeqNo;
            this.totalColumnCnt = totalColumnCnt;
            this.rowBufferList = new ArrayList<Object[]>(batchSize);
        }

        @Override
        public boolean hasNext() {
            return this.eof || this.comboValueIterator == null ? this.moveToNextSourceRow() : this.comboValueIterator.hasNext();
        }

        protected boolean moveToNextSourceRow() {
            Object[] newSrcRow;
            do {
                if (this.srcValueIterator.hasNext()) continue;
                return false;
            } while ((newSrcRow = this.srcValueIterator.next()) == null || newSrcRow.length == 0);
            IntArraySequenceIteratorBuilder builder = new IntArraySequenceIteratorBuilder();
            for (int i = 0; i < newSrcRow.length; ++i) {
                Object colValBuf = newSrcRow[i];
                if (colValBuf != null && this.mulValColPos.get(i)) {
                    builder.addArrayValue(((Collection)colValBuf).toArray());
                    continue;
                }
                builder.addFixedValue(i, colValBuf);
            }
            this.comboValueIterator = builder.build();
            return this.comboValueIterator.hasNext();
        }

        @Override
        public List<Object[]> next() {
            this.rowBufferList.clear();
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException("Multi-Value Iterator EOF!");
            }
            int currentRowIdx = 0;
            Object[] ids = (Object[])MulValueInsertSqlBuilder.this.idGeneratorFunction.apply(this._batchSize);
            while (true) {
                if (currentRowIdx < this._batchSize && this.comboValueIterator.hasNext()) {
                    Object[] rowBuf = this.comboValueIterator.next();
                    rowBuf = Arrays.copyOf(rowBuf, rowBuf.length);
                    this.rowBufferList.add(rowBuf);
                    rowBuf[((MulValueInsertSqlBuilder)MulValueInsertSqlBuilder.this).PK_Column_Index] = ids[currentRowIdx];
                    rowBuf[((MulValueInsertSqlBuilder)MulValueInsertSqlBuilder.this).Seq_Column_Index] = this.lastSeqNo++;
                    ++currentRowIdx;
                    continue;
                }
                if (currentRowIdx >= this._batchSize || (this.eof = !this.moveToNextSourceRow())) break;
            }
            return this.rowBufferList;
        }
    }
}

