/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.IDataStorage;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.fi.v2.fah.models.valueset.IReadMultiValue;
import kd.fi.v2.fah.models.valueset.IWritableMulValue;
import org.jetbrains.annotations.NotNull;

public interface IOpenDataStorage<V>
extends IDataStorage,
Serializable,
Iterable<V>,
IWritableMulValue<V>,
IReadMultiValue<V> {
    public void reset(int var1, Class<V> var2);

    default public V removeByIndex(int index) {
        List<V> resultList = this.batchRemoveByRange(index, index);
        return resultList.isEmpty() ? null : (V)resultList.get(0);
    }

    public List<V> batchRemoveByRange(int var1, int var2);

    default public Collection<V> toCollection() {
        Object[] resultArray = this.getValues();
        return resultArray == null ? Collections.EMPTY_LIST : Arrays.asList(resultArray);
    }

    public boolean sort(int var1, int var2, Comparator<V> var3);

    default public boolean sort(Comparator<V> comparator) {
        return this.sort(0, this.size(), comparator);
    }

    default public Object getLocalValue(IDataEntityProperty property) {
        return property != null ? this.get(property.getOrdinal()) : null;
    }

    default public void setLocalValue(IDataEntityProperty property, Object value) {
        if (property != null) {
            this.set(property.getOrdinal(), value);
        }
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    @NotNull
    default public Iterator<V> iterator() {
        return Arrays.asList(this.getValues()).iterator();
    }

    default public boolean addAll(@NotNull Collection<? extends V> c) {
        return this.batchAdd(new ArrayList<V>(c)) >= 0;
    }

    default public boolean contains(Object targetValue) {
        if (targetValue == null || this.isEmpty()) {
            return false;
        }
        for (Object v : this.getValues()) {
            if (!targetValue.equals(v)) continue;
            return true;
        }
        return false;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    @NotNull
    default public Object[] toArray() {
        return this.getValues();
    }

    @NotNull
    default public <T> T[] toArray(@NotNull T[] a) {
        throw new UnsupportedOperationException();
    }

    default public boolean containsAll(@NotNull Collection<?> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        HashSet<Object> set = new HashSet<Object>(collection.size());
        set.addAll(Arrays.asList(this.getValues()));
        for (Object e : collection) {
            if (set.contains(e)) continue;
            return false;
        }
        return true;
    }

    default public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    default public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    default public IDataStorage memberClone() {
        throw new UnsupportedOperationException();
    }
}

