/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.v2.fah.storage.ICacheableOpenDataStorage;
import kd.fi.v2.fah.storage.impl.MutableArrayStorage;

public class CacheableMutableArrayStorage<V>
extends MutableArrayStorage<V>
implements ICacheableOpenDataStorage<V> {
    protected transient List<V> cacheList;
    protected transient int cachedSize = 0;

    public CacheableMutableArrayStorage() {
    }

    public CacheableMutableArrayStorage(V[] values, Class<V> clazzType) {
        super(values, clazzType);
    }

    public CacheableMutableArrayStorage(int initialSize, Class<V> clazzType) {
        super(initialSize, clazzType);
    }

    @Override
    public String toString() {
        return "CacheableMutableArrayStorage{cacheList=" + this.cacheList + ", cachedSize=" + this.cachedSize + ", values=" + Arrays.toString(this.values) + ", __current_store_pos=" + this.__current_store_pos + '}';
    }

    @JSONField(serialize=false)
    @JsonIgnore
    protected List<V> createCacheList() {
        return new LinkedList();
    }

    @Override
    public int cache(V value) {
        if (this.cacheList == null) {
            this.cacheList = this.createCacheList();
        }
        return this.cacheList.add(value) ? (this.cachedSize = this.cachedSize + 1) : -1;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int cachedSize() {
        return this.cachedSize;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean flush() {
        if (this.cachedSize > 0) {
            if (this.values == null) {
                this.values = this.cacheListToArray();
                this.__current_store_pos = this.cachedSize;
            } else {
                super.batchAdd(this.cacheList);
            }
            this.cachedSize = 0;
            this.cacheList = null;
            return true;
        }
        return false;
    }

    protected V[] cacheListToArray() {
        if (this.cacheList == null || this.cacheList.isEmpty()) {
            return null;
        }
        Class<?> _itemClass = this.getItemClazzType();
        if (_itemClass == null) {
            for (V itemBuf : this.cacheList) {
                if (itemBuf == null) continue;
                _itemClass = itemBuf.getClass();
            }
        }
        if (_itemClass == null) {
            throw new IllegalArgumentException("Cannot found Valid Item Class Type");
        }
        if (null == this._clazzType) {
            this._clazzType = _itemClass;
        }
        Object[] buffer = (Object[])Array.newInstance(_itemClass, this.cacheList.size());
        int i = 0;
        for (V itemBuf : this.cacheList) {
            if (itemBuf != null) {
                buffer[i] = itemBuf;
            }
            ++i;
        }
        return buffer;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean clearCache() {
        if (this.cachedSize > 0) {
            this.cacheList.clear();
            return true;
        }
        return false;
    }

    @Override
    @JSONField(name="data")
    public void setJsonSerializeV(Object values, Class clazzType, boolean caseSensitive) {
        this._clazzType = clazzType;
        this.values = null;
        this.__current_store_pos = 0;
        if (IDataValueUtil.getObjectEnumType((Object)values) > 0) {
            if (this.cacheList == null) {
                this.cacheList = this.createCacheList();
            }
            int oldCacheLength = this.cacheList.size();
            IDataValueUtil.enumerateObject((Object)values, (index, item) -> this.cacheList.add(item));
            this.cachedSize += this.cacheList.size() - oldCacheLength;
            this.flush();
        }
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public List<V> getCacheList() {
        return this.cacheList != null && !this.cacheList.isEmpty() ? Collections.unmodifiableList(this.cacheList) : Collections.EMPTY_LIST;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public int getTotalRowCnt() {
        return this.values.length + this.cachedSize;
    }
}

