/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.impl;

import java.util.LinkedList;
import java.util.List;
import kd.fi.v2.fah.storage.ICacheableStorageWrapper;
import kd.fi.v2.fah.storage.IOpenDataStorage;

public class CacheableStorageWrapper<V, T extends IOpenDataStorage<V>>
implements ICacheableStorageWrapper<V, T> {
    protected transient List<V> cacheList;
    protected transient int cachedSize = 0;
    protected T dataStorage;

    public CacheableStorageWrapper(T dataStorage) {
        this.dataStorage = dataStorage;
    }

    protected List<V> createCacheList() {
        return new LinkedList();
    }

    @Override
    public int cache(V value) {
        if (this.cacheList == null) {
            this.cacheList = this.createCacheList();
        }
        return this.cacheList.add(value) ? (this.cachedSize = this.cachedSize + 1) : -1;
    }

    @Override
    public int cachedSize() {
        return this.cachedSize;
    }

    @Override
    public void flush() {
        if (this.cachedSize > 0) {
            this.dataStorage.batchAdd(this.cacheList);
            this.cachedSize = 0;
            this.cacheList = null;
        }
    }

    @Override
    public void clearCache() {
        if (this.cachedSize > 0) {
            this.cacheList.clear();
        }
    }

    @Override
    public T getDataStorage() {
        return this.dataStorage;
    }

    public void setDataStorage(T dataStorage) {
        this.dataStorage = dataStorage;
    }
}

