/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.tables;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.models.modeling.base.BaseModelCollection;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableMeta;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableRelationshipMeta;
import kd.fi.v2.fah.models.valueset.IBaseFieldMeta;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;

public class TableSpaceManager
extends BaseModelCollection<String, SimpleTableMeta<String>> {
    protected Set<SimpleTableRelationshipMeta> tableRelationship = new LinkedHashSet<SimpleTableRelationshipMeta>(4);
    protected transient Map<String, Set<SimpleTableRelationshipMeta>> _tabRelationshipLookupIdx = new HashMap<String, Set<SimpleTableRelationshipMeta>>(4);
    protected transient Map<String, List<SimpleTableMeta>> _fieldIdxMap = new HashMap<String, List<SimpleTableMeta>>(4);

    @Override
    public String toString() {
        return "TableSpaceManager{tableRelationship=" + this.tableRelationship + ", _tabRelationshipLookupIdx=" + this._tabRelationshipLookupIdx + ", collections=" + this.collections + ", id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + '}';
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public void rebuildIndex() {
        this._tabRelationshipLookupIdx.clear();
        if (this.tableRelationship != null) {
            this.tableRelationship.forEach((? super T v) -> this.addTableRelationship((SimpleTableRelationshipMeta)v));
        }
        this._fieldIdxMap.clear();
        if (this.collections != null) {
            for (SimpleTableMeta tableMeta : (BaseMutableArrayMapStorage)this.collections) {
                if (tableMeta == null || tableMeta.isEmpty()) continue;
                for (IBaseFieldMeta field : tableMeta) {
                    this._fieldIdxMap.computeIfAbsent((String)field.getItemKey(), (Function<String, List<SimpleTableMeta>>)((Function<String, List>)v -> new LinkedList())).add(tableMeta);
                }
            }
        }
    }

    protected void removeTableRelationShip(String tableNum) {
        if (tableNum == null) {
            return;
        }
        Set<SimpleTableRelationshipMeta> removedRelationship = this._tabRelationshipLookupIdx.remove(tableNum);
        if (removedRelationship != null && !removedRelationship.isEmpty()) {
            this.tableRelationship.removeAll(removedRelationship);
            for (SimpleTableRelationshipMeta relationship : removedRelationship) {
                this._tabRelationshipLookupIdx.get(relationship.getLinkTargetTable(tableNum)).remove(relationship);
            }
        }
    }

    @Override
    public List<SimpleTableMeta<String>> batchRemoveByRange(int start, int end) {
        List<SimpleTableMeta<String>> result = super.batchRemoveByRange(start, end);
        if (result != null) {
            result.forEach((? super T v) -> this.removeTableRelationShip(v.getNumber()));
        }
        return result;
    }

    public boolean addTableRelationship(SimpleTableRelationshipMeta relationship) {
        if (relationship == null || this.tableRelationship.contains(relationship)) {
            return false;
        }
        if (!((BaseMutableArrayMapStorage)this.collections).containsKey(relationship.getLeftTableNum()) || !((BaseMutableArrayMapStorage)this.collections).containsKey(relationship.getRightTableNum())) {
            return false;
        }
        this.tableRelationship.add(relationship);
        this._tabRelationshipLookupIdx.computeIfAbsent(relationship.getLeftTableNum(), v -> new LinkedHashSet(1)).add(relationship);
        this._tabRelationshipLookupIdx.computeIfAbsent(relationship.getRightTableNum(), v -> new LinkedHashSet(1)).add(relationship);
        return true;
    }

    public boolean addTableRelationship(String leftTable, String rightTable, List<PairTuple<String, String>> joinFields) {
        return this.addTableRelationship(new SimpleTableRelationshipMeta(leftTable, rightTable, joinFields));
    }

    public boolean addTableRelationship(String leftTable, String rightTable, String leftField, String rightField) {
        return this.addTableRelationship(new SimpleTableRelationshipMeta(leftTable, rightTable, leftField, rightField));
    }

    public void removeTableRelationship(SimpleTableRelationshipMeta relationship) {
        if (relationship == null || !this.tableRelationship.remove(relationship)) {
            return;
        }
        this._tabRelationshipLookupIdx.get(relationship.getLeftTableNum()).remove(relationship);
        this._tabRelationshipLookupIdx.get(relationship.getRightTableNum()).remove(relationship);
    }

    public Set<SimpleTableRelationshipMeta> getTableRelationship() {
        return this.tableRelationship;
    }

    public void setTableRelationship(Set<SimpleTableRelationshipMeta> tableRelationship) {
        this.tableRelationship = tableRelationship;
    }

    public List<SimpleTableMeta> getFieldTables(String fieldNum) {
        return this._fieldIdxMap.get(fieldNum);
    }
}

