/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.tables.impl;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.function.Function;
import kd.fi.v2.fah.meta.SimpleTableMeta;
import kd.fi.v2.fah.storage.IDataItemKey;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.storage.tables.IDataTableStorage;
import kd.fi.v2.fah.storage.tables.impl.AbstractSimpleTableStorage;
import kd.fi.v2.fah.storage.tables.impl.IMemTableManager;
import kd.fi.v2.fah.storage.tables.impl.SimpleTableColStorage;
import kd.fi.v2.fah.storage.tables.impl.SimpleTableRowStorage;
import kd.fi.v2.fah.storage.tables.impl.TableInfoPairTuple;

public class SimpleMemTableManager
implements IDataItemKey<String>,
IMemTableManager {
    protected String tabMangerKey;
    protected BaseMutableArrayMapStorage<String, TableInfoPairTuple> tableStorages;

    public SimpleMemTableManager(String key, int tableCnt) {
        if (tableCnt <= 0) {
            throw new IllegalArgumentException(String.format("Total Table Space Count cannot be %d, must greater than 0!", tableCnt));
        }
        this.tabMangerKey = key;
        this.tableStorages = new BaseMutableArrayMapStorage(tableCnt, TableInfoPairTuple.class, false);
    }

    protected SimpleMemTableManager(String key) {
        this.tabMangerKey = key;
        this.tableStorages = new BaseMutableArrayMapStorage(0, TableInfoPairTuple.class, false);
    }

    protected <T extends AbstractSimpleTableStorage> T createTableSpace(boolean columnStorageType, int columnCnt, int maxRowCnt) {
        return (T)(columnStorageType ? new SimpleTableColStorage(columnCnt, maxRowCnt) : new SimpleTableRowStorage(columnCnt, maxRowCnt));
    }

    protected <T extends AbstractSimpleTableStorage> T createTableSpace(boolean columnStorageType, int columnCnt) {
        return this.createTableSpace(columnStorageType, columnCnt, -1);
    }

    @Override
    public int registerTableSpace(Object tableKey, boolean columnStorageType, int columnCnt, int maxRowCnt) {
        return this.tableStorages.addEx(new TableInfoPairTuple((IDataTableStorage)this.createTableSpace(columnStorageType, columnCnt, maxRowCnt), tableKey));
    }

    @Override
    public int registerTableSpace(Object tableKey, boolean columnStorageType, int columnCnt) {
        return this.registerTableSpace(tableKey, columnStorageType, columnCnt, -1);
    }

    @Override
    public int registerTableSpace(boolean columnStorageType, SimpleTableMeta tableMeta) {
        return this.tableStorages.addEx(new TableInfoPairTuple((IDataTableStorage)this.createTableSpace(columnStorageType, tableMeta.getColumnCnt(), -1), tableMeta));
    }

    @Override
    public TableInfoPairTuple getTableStorageAndInfoByIndex(int tableIdx) {
        if (tableIdx < 0) {
            return null;
        }
        return (TableInfoPairTuple)this.tableStorages.get((String)tableIdx);
    }

    @Override
    public TableInfoPairTuple releaseTableStorage(int tableIdx) {
        if (tableIdx < 0) {
            return null;
        }
        return (TableInfoPairTuple)this.tableStorages.removeByIndex(tableIdx);
    }

    @Override
    public int getTableIndex(String tableKey) {
        return this.tableStorages.getIndex(tableKey);
    }

    @Override
    public <T> T accessTable(int tableIdx, Function<IDataTableStorage, T> accessTableFunc, T optionValue) {
        TableInfoPairTuple tableInfo;
        if (tableIdx >= 0 && (tableInfo = (TableInfoPairTuple)this.tableStorages.get((String)tableIdx)) != null) {
            return accessTableFunc.apply((IDataTableStorage)tableInfo.getKey());
        }
        return optionValue;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public String getItemKey() {
        return this.tabMangerKey;
    }
}

