/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.tables.index;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Map;
import kd.fi.v2.fah.models.modeling.base.AbstractBasePropModelCfg;
import kd.fi.v2.fah.storage.tables.common.MultiDimValueKey;
import kd.fi.v2.fah.storage.tables.enums.TableIndexTypeEnum;
import kd.fi.v2.fah.storage.tables.index.ITableIndexStorage;

public abstract class AbstractTableIndexStorage<INDEX_VAL>
extends AbstractBasePropModelCfg<Object, Object>
implements ITableIndexStorage {
    protected TableIndexTypeEnum indexType;
    protected int[] indexColumnPos;
    protected Map<Object, INDEX_VAL> indexDatas;

    protected AbstractTableIndexStorage() {
    }

    public AbstractTableIndexStorage(TableIndexTypeEnum indexType, int[] indexColumnPos) {
        this(null, indexType, indexColumnPos);
    }

    public AbstractTableIndexStorage(Object indexKey, TableIndexTypeEnum indexType, int[] indexColumnPos) {
        super(indexKey, null, null);
        this.indexType = indexType;
        this.indexColumnPos = indexColumnPos;
    }

    @Override
    public String toString() {
        return "AbstractTableIndexStorage{indexType=" + (Object)((Object)this.indexType) + ", indexColums=" + Arrays.toString(this.indexColumnPos) + ", indexDatas=" + this.indexDatas + ", id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + '}';
    }

    @Override
    public int getMatchDataRowCnt(Object indexKey) {
        if (this.indexDatas != null && !this.indexDatas.isEmpty()) {
            return this.indexDatas.containsKey(indexKey) ? 1 : 0;
        }
        return 0;
    }

    @Override
    public Object buildIndexKey(Object[] rowData) {
        return new MultiDimValueKey(rowData, this.indexColumnPos);
    }

    public Object get(int index) {
        throw new UnsupportedOperationException("Not Support this Method");
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public Object[] getValues() {
        return this.indexDatas != null && !this.indexDatas.isEmpty() ? this.indexDatas.keySet().toArray(new Object[0]) : new Object[]{};
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public int size() {
        return this.indexDatas != null ? this.indexDatas.size() : 0;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isEmpty() {
        return this.indexDatas != null ? this.indexDatas.isEmpty() : false;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public Object getItemKey() {
        return this.id;
    }

    @Override
    public void clear() {
        if (this.indexDatas != null) {
            this.indexDatas.clear();
        }
    }

    public TableIndexTypeEnum getIndexType() {
        return this.indexType;
    }

    public void setIndexType(TableIndexTypeEnum indexType) {
        this.indexType = indexType;
    }

    @Override
    public int[] getIndexColumnPos() {
        return this.indexColumnPos;
    }

    public void setIndexColumnPos(int[] indexColumnPos) {
        this.indexColumnPos = indexColumnPos;
    }

    public Map<Object, INDEX_VAL> getIndexDatas() {
        return this.indexDatas;
    }

    public void setIndexDatas(Map<Object, INDEX_VAL> indexDatas) {
        this.indexDatas = indexDatas;
    }
}

