/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.storage.tables.index;

import java.util.BitSet;
import kd.bos.dataentity.collections.IKeyedCollectionBase;
import kd.fi.v2.fah.storage.ICacheableOpenDataStorage;
import kd.fi.v2.fah.storage.IOpenDataStorage;
import kd.fi.v2.fah.storage.tables.IDataTableStorage;
import kd.fi.v2.fah.storage.tables.enums.TableIndexTypeEnum;
import kd.fi.v2.fah.storage.tables.index.ITableIndexStorage;

public interface ITableIndexGrpStorage
extends ICacheableOpenDataStorage<ITableIndexStorage>,
IKeyedCollectionBase<Object, ITableIndexStorage>,
IOpenDataStorage<ITableIndexStorage> {
    public IDataTableStorage getTableStorage();

    public void setTableStorage(IDataTableStorage var1);

    public ITableIndexStorage createIndexStorage(TableIndexTypeEnum var1, int[] var2);

    default public int[] getIndexColumnPos(Object indexKey) {
        ITableIndexStorage indexStorage = (ITableIndexStorage)this.get(indexKey);
        return indexStorage != null ? indexStorage.getIndexColumnPos() : null;
    }

    default public BitSet addIndexRow(int rowIndex, Object[] rowData) {
        BitSet successCnt = new BitSet(0);
        if (!this.isEmpty()) {
            for (ITableIndexStorage indexStorage : (ITableIndexStorage[])this.getValues()) {
                if (indexStorage == null || !indexStorage.addIndexRow(rowIndex, rowData)) continue;
                successCnt.set(rowIndex);
            }
        }
        return successCnt;
    }

    default public BitSet batchAddIndexRow(IDataTableStorage srcTable, int startRow, int endRow) {
        BitSet successCnt = new BitSet(0);
        if (this.isEmpty() || srcTable == null || srcTable.isEmpty()) {
            return successCnt;
        }
        int tableSize = srcTable.size();
        for (int idx = Math.max(startRow, 0); idx < Math.min(endRow, tableSize); ++idx) {
            if (this.addIndexRow(idx, (Object[])srcTable.get(idx)).isEmpty()) continue;
            successCnt.set(idx);
        }
        return successCnt;
    }
}

