/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.fi.bd.util.exception.IExceptionListener;
import kd.fi.v2.fah.task.builder.IDataProcessTaskBuilder;
import kd.fi.v2.fah.task.common.FahTaskGroupCondition;
import kd.fi.v2.fah.task.common.IFahDataWorkTask;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;

public abstract class AbstractDataProcessTaskBuilder<TASK extends IFahDataWorkTask, BUILD_PARAM>
implements IDataProcessTaskBuilder<TASK, BUILD_PARAM> {
    protected RequestContext requestContext = RequestContext.getOrCreate();
    protected Map<String, Object> taskParams;
    protected ITaskStatusChangeListener statusChangeListener;
    protected IExceptionListener exceptionListener;
    protected FahTaskGroupCondition taskGroupCondition;
    protected Supplier<Log> logSupplier;
    protected BiFunction<String, Integer, long[]> idSupplier;

    @Override
    public void resetTaskBuilderParams() {
        if (this.taskParams != null) {
            this.taskParams.clear();
        }
        this.requestContext = RequestContext.getOrCreate();
        this.taskGroupCondition = null;
        this.statusChangeListener = null;
        this.exceptionListener = null;
    }

    protected TASK setTaskCommonFields(TASK srcTask) {
        if (this.taskGroupCondition != null) {
            srcTask.setTaskGroupCondition(this.taskGroupCondition);
        }
        if (this.statusChangeListener != null) {
            srcTask.setTaskStatusChangeListener(this.statusChangeListener);
        }
        return srcTask;
    }

    @Override
    public boolean addTaskParam(String paramKey, Object paramValue) {
        if (this.taskParams == null) {
            this.taskParams = new HashMap<String, Object>(4);
        }
        this.taskParams.put(paramKey, paramValue);
        return true;
    }

    @Override
    public void setTenantRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    @Override
    public void setTaskStatusChangeListener(ITaskStatusChangeListener statusChangeListener) {
        this.statusChangeListener = statusChangeListener;
    }

    @Override
    public void setExceptionListener(IExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public void setLogSupplier(Supplier<Log> logSupplier) {
        this.logSupplier = logSupplier;
    }

    @Override
    public void setIdSupplier(BiFunction<String, Integer, long[]> idSupplier) {
        this.idSupplier = idSupplier;
    }

    @Override
    public void setTaskGroupCondition(FahTaskGroupCondition taskGroupCondition) {
        this.taskGroupCondition = taskGroupCondition;
    }
}

