/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.fi.v2.fah.models.common.ThreeValueTuple;
import kd.fi.v2.fah.storage.IDataItemKey;
import kd.fi.v2.fah.task.common.BaseTaskMetaInfo;
import kd.fi.v2.fah.task.common.IFahDataWorkTask;
import kd.fi.v2.fah.task.statistics.BaseTaskStatisticInfo;
import kd.fi.v2.fah.task.status.TaskStatusEnum;

public class FahTaskGroupCondition {
    protected volatile TaskStatusEnum taskStatus;
    protected Map<Object, SubTaskCondition> taskErrorInfos;
    protected volatile int totalErrorCnt;
    protected volatile boolean active;
    protected volatile boolean withFatalError;
    protected BaseTaskStatisticInfo taskStatistic;
    protected boolean enableGrpCondition;

    public FahTaskGroupCondition() {
        this(TaskStatusEnum.NEW, false, true);
    }

    public FahTaskGroupCondition(TaskStatusEnum initialStage) {
        this(initialStage, false, true);
    }

    public FahTaskGroupCondition(TaskStatusEnum initialStage, boolean enableGrpCondition) {
        this(initialStage, enableGrpCondition, true);
    }

    public FahTaskGroupCondition(TaskStatusEnum initialStage, boolean enableGrpCondition, boolean active) {
        this.active = active;
        this.enableGrpCondition = enableGrpCondition;
        this.withFatalError = false;
        this.taskStatus = initialStage;
        this.totalErrorCnt = 0;
        this.taskErrorInfos = new HashMap<Object, SubTaskCondition>(4);
        this.taskStatistic = new BaseTaskStatisticInfo();
    }

    public String toString() {
        return "FahTaskGroupCondition{taskStatus=" + (Object)((Object)this.taskStatus) + ", taskErrorInfos=" + this.taskErrorInfos + ", totalErrorCnt=" + this.totalErrorCnt + ", active=" + this.active + ", withFatalError=" + this.withFatalError + ", taskStatistic=" + this.taskStatistic + '}';
    }

    public boolean isEnableGrpCondition() {
        return this.enableGrpCondition;
    }

    public void setEnableGrpCondition(boolean enableGrpCondition) {
        this.enableGrpCondition = enableGrpCondition;
    }

    protected synchronized void updateGroupCondition(TaskStatusEnum newStatus, boolean withFatalError) {
        this.taskStatus = newStatus;
        this.withFatalError = withFatalError;
    }

    protected synchronized void addSubTaskError(IFahDataWorkTask subTask, Object errorCode, String errorMessage) {
        this.taskErrorInfos.computeIfAbsent(subTask.getTaskMeta(), v -> new SubTaskCondition(subTask)).addError(this.totalErrorCnt++, errorCode, errorMessage);
    }

    public SubTaskCondition getSubTaskCondition(Object subTaskKey) {
        return this.taskErrorInfos.get(subTaskKey);
    }

    public synchronized void updateSubTaskStatusCondition(IFahDataWorkTask subTask, TaskStatusEnum newStatus, Object errorCode, String errorMessage) {
        SubTaskCondition condition = this.taskErrorInfos.computeIfAbsent(subTask.getTaskMeta(), v -> new SubTaskCondition(subTask));
        if (newStatus != null) {
            condition.setTaskStatus(newStatus);
        }
        if (errorCode != null && errorMessage != null) {
            condition.addError(this.totalErrorCnt++, errorCode, errorMessage);
        }
    }

    public void updateSubTaskStatusCondition(IFahDataWorkTask subTask, TaskStatusEnum newStatus) {
        this.updateSubTaskStatusCondition(subTask, newStatus, null, null);
    }

    public void updateGroupStatisticPoint(TaskStatusEnum status, int deltaCnt) {
        this.updateGroupStatisticPoint(status.getCode(), deltaCnt);
    }

    public synchronized void updateGroupStatisticPoint(int statusIdx, int deltaCnt) {
        this.taskStatistic.updateStatisticPoint(statusIdx, deltaCnt);
    }

    public synchronized void setActive(boolean active) {
        this.active = active;
    }

    public void cancel(boolean withError) {
        this.updateGroupCondition(TaskStatusEnum.CANCELLED, withError);
    }

    public void markGroupCompleted(boolean withError) {
        this.updateGroupCondition(TaskStatusEnum.COMPLETED, withError);
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized boolean isCancelled() {
        return this.taskStatus.isCancelled();
    }

    public synchronized boolean isCompleted() {
        return !this.active && this.taskStatus.isTaskEnd();
    }

    public boolean isWithFatalError() {
        return this.withFatalError;
    }

    public int getStatisticCnt(TaskStatusEnum status) {
        return this.taskStatistic.getStatisticPoint(status.getCode());
    }

    public TaskStatusEnum getTaskStatus() {
        return this.taskStatus;
    }

    public int getTotalErrorCnt() {
        return this.totalErrorCnt;
    }

    public BaseTaskStatisticInfo getTaskStatistic() {
        return this.taskStatistic;
    }

    public Map<Object, SubTaskCondition> getTaskErrorInfos() {
        return this.taskErrorInfos;
    }

    public static class SubTaskCondition
    implements Serializable,
    IDataItemKey<Object> {
        protected int errorSeqNo;
        protected Object subTaskKey;
        protected IFahDataWorkTask srcSubTask;
        protected TaskStatusEnum taskStatus;
        protected List<ThreeValueTuple<Integer, Object, String>> errors;

        public SubTaskCondition(IFahDataWorkTask srcSubTask) {
            this.srcSubTask = srcSubTask;
            this.errors = new LinkedList<ThreeValueTuple<Integer, Object, String>>();
        }

        public void addError(int errorSeqNo, Object errorCode, String errorMessage) {
            this.errors.add(new ThreeValueTuple<Integer, Object, String>(errorSeqNo, errorCode, errorMessage));
        }

        @Override
        public Object getItemKey() {
            return ((BaseTaskMetaInfo)this.srcSubTask.getTaskMeta()).getItemKey();
        }

        public Object getSubTaskKey() {
            return this.subTaskKey;
        }

        public void setSubTaskKey(Object subTaskKey) {
            this.subTaskKey = subTaskKey;
        }

        public IFahDataWorkTask getSrcSubTask() {
            return this.srcSubTask;
        }

        public void setSrcSubTask(IFahDataWorkTask srcSubTask) {
            this.srcSubTask = srcSubTask;
        }

        public List<ThreeValueTuple<Integer, Object, String>> getErrors() {
            return this.errors;
        }

        public int getErrorSeqNo() {
            return this.errorSeqNo;
        }

        public TaskStatusEnum getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(TaskStatusEnum taskStatus) {
            this.taskStatus = taskStatus;
        }
    }
}

