/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.common;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.fi.v2.fah.task.common.BaseTaskMetaInfo;
import kd.fi.v2.fah.task.common.FahTaskGroupCondition;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;
import kd.fi.v2.fah.task.statistics.BaseTaskStatisticInfo;
import kd.fi.v2.fah.task.status.TaskStatusEnum;

public interface IFahDataWorkTask<GRP_KEY extends Serializable, TASK_ID extends Serializable, TASK_TYPE extends Serializable, V, META extends BaseTaskMetaInfo<GRP_KEY, TASK_ID, TASK_TYPE>>
extends Callable<V>,
Runnable {
    public META getTaskMeta();

    public void setTaskMeta(META var1);

    public RequestContext getTenantRequestContext();

    public void setTaskStatusChangeListener(ITaskStatusChangeListener var1);

    public void setTaskGroupCondition(FahTaskGroupCondition var1);

    public FahTaskGroupCondition getTaskGroupCondition();

    public V getResult();

    public boolean hasError();

    public void cancel(boolean var1);

    default public BaseTaskStatisticInfo getTaskStatistic() {
        return this.accessTaskGroupCondition(grp -> grp.getTaskStatistic());
    }

    default public TaskStatusEnum getTaskStatus() {
        return this.accessTaskMeta(meta -> meta.getTaskStatus());
    }

    default public GRP_KEY getGroupId() {
        return (GRP_KEY)this.accessTaskMeta(meta -> meta.getGroupId());
    }

    default public TASK_ID getTaskId() {
        return (TASK_ID)this.accessTaskMeta(meta -> meta.getTaskId());
    }

    default public TASK_TYPE getTaskTypeCode() {
        return (TASK_TYPE)this.accessTaskMeta(meta -> meta.getTaskTypeCode());
    }

    default public GRP_KEY getTaskGrpTypeCode() {
        return (GRP_KEY)this.accessTaskMeta(meta -> meta.getGroupId());
    }

    default public boolean isInitialized() {
        return this.accessTaskMeta(meta -> meta.isInitialized());
    }

    default public <T> T accessTaskMeta(Function<META, T> func) {
        META meta = this.getTaskMeta();
        return meta != null ? (T)func.apply(meta) : null;
    }

    default public <T> T accessTaskGroupCondition(Function<FahTaskGroupCondition, T> func) {
        FahTaskGroupCondition groupCondition = this.getTaskGroupCondition();
        return groupCondition != null ? (T)func.apply(groupCondition) : null;
    }

    default public void cancel() {
        this.cancel(false);
    }

    default public boolean isCancelled() {
        return this.getTaskStatus().getCode() == TaskStatusEnum.CANCELLED.getCode();
    }

    default public boolean isCompleted() {
        return this.getTaskStatus().getCode() >= TaskStatusEnum.COMPLETED.getCode();
    }
}

