/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.enums;

import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.StringUtils;

public enum FahTaskGrpTypeEnum {
    Config_Migration_Export(1),
    Config_Migration_Import(2),
    Submit_Bill_Request_TaskGrp(10),
    Process_BillTypeData_RootTaskGrp(11),
    Found_Bill_DispatchRule_TaskGrp(22),
    Bill_Dispatch_TaskGrp(12),
    Bill_To_Event_TaskGrp(13),
    Event_To_XLA_TaskGrp(14),
    XLA_To_InterfaceVoucher_TaskGrp(15),
    InterfaceVoucher_Validate_TaskGrp(16),
    InterfaceVoucher_PushTo_GL_TaskGrp(17),
    GLVoucher_Validate_And_Sumbit_TaskGrp(18),
    GLVoucher_Writeback_TaskGrp(19),
    Create_BizDimGrp_TaskGrp(20),
    Create_BizDimGrp_Index_TaskGrp(21),
    Reverse_Bill_Data_RootTaskGrp(40),
    Reverse_GL_Voucher_TaskGrp(41),
    Reverse_XLA_TaskGrp(42),
    Reverse_Event_TaskGrp(43),
    Reverse_Update_Evt_Xla_Tracker_TaskGrp(44),
    Clean_Data_TaskGrp(90);

    private int code;

    private FahTaskGrpTypeEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static FahTaskGrpTypeEnum parseByCode(int code) {
        switch (code) {
            case 1: {
                return Config_Migration_Export;
            }
            case 2: {
                return Config_Migration_Import;
            }
            case 10: {
                return Submit_Bill_Request_TaskGrp;
            }
            case 11: {
                return Process_BillTypeData_RootTaskGrp;
            }
            case 12: {
                return Bill_Dispatch_TaskGrp;
            }
            case 13: {
                return Bill_To_Event_TaskGrp;
            }
            case 14: {
                return Event_To_XLA_TaskGrp;
            }
            case 15: {
                return XLA_To_InterfaceVoucher_TaskGrp;
            }
            case 16: {
                return InterfaceVoucher_Validate_TaskGrp;
            }
            case 17: {
                return InterfaceVoucher_PushTo_GL_TaskGrp;
            }
            case 18: {
                return GLVoucher_Validate_And_Sumbit_TaskGrp;
            }
            case 19: {
                return GLVoucher_Writeback_TaskGrp;
            }
            case 20: {
                return Create_BizDimGrp_TaskGrp;
            }
            case 21: {
                return Create_BizDimGrp_Index_TaskGrp;
            }
            case 22: {
                return Found_Bill_DispatchRule_TaskGrp;
            }
            case 40: {
                return Reverse_Bill_Data_RootTaskGrp;
            }
            case 41: {
                return Reverse_GL_Voucher_TaskGrp;
            }
            case 42: {
                return Reverse_XLA_TaskGrp;
            }
            case 43: {
                return Reverse_Event_TaskGrp;
            }
            case 44: {
                return Reverse_Update_Evt_Xla_Tracker_TaskGrp;
            }
            case 90: {
                return Clean_Data_TaskGrp;
            }
        }
        return null;
    }

    public static FahTaskGrpTypeEnum parseByCodeValue(Object code) {
        try {
            return FahTaskGrpTypeEnum.parseByCode(Integer.parseInt(String.valueOf(code)));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static FahTaskGrpTypeEnum[][] parseTaskTypes(String taskGrpString) {
        if (StringUtils.isEmpty((String)taskGrpString)) {
            throw new IllegalArgumentException("Task Group JSON String is null!");
        }
        int[][] taskGrpIdx = FahSerializeHelper.fromJsonString(taskGrpString, int[][].class);
        FahTaskGrpTypeEnum[][] result = new FahTaskGrpTypeEnum[taskGrpIdx.length][];
        int idx = 0;
        for (int[] grp : taskGrpIdx) {
            result[idx] = new FahTaskGrpTypeEnum[grp.length];
            for (int i = 0; i < grp.length; ++i) {
                result[idx][i] = FahTaskGrpTypeEnum.parseByCode(grp[i]);
            }
            ++idx;
        }
        return result;
    }
}

