/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.statistics;

import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;

public class BatchBarrierStatistics
implements Serializable {
    public static int IDX_WAITING_BATCH = 0;
    public static int IDX_PROCESSING_BATCH = 1;
    public static int IDX_COMPLETED_BATCH = 2;
    protected List<Object> batchBarrierKey;
    protected int[] barrierStatisticCounter;
    protected BitSet errorBatchFlags = new BitSet();

    public BatchBarrierStatistics() {
        this.barrierStatisticCounter = new int[IDX_COMPLETED_BATCH + 1];
        Arrays.fill(this.barrierStatisticCounter, 0);
    }

    public String toString() {
        return "BatchBarrierStatistics{batchBarrierKey=" + this.batchBarrierKey + ", barrierStatisticCounter=" + Arrays.toString(this.barrierStatisticCounter) + ", errorBatchFlags=" + this.errorBatchFlags + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchBarrierStatistics)) {
            return false;
        }
        BatchBarrierStatistics that = (BatchBarrierStatistics)o;
        return Objects.equals(this.batchBarrierKey, that.batchBarrierKey);
    }

    public int hashCode() {
        return Objects.hash(this.batchBarrierKey);
    }

    public void addNewBatch() {
        this.increaseCounter(IDX_WAITING_BATCH);
    }

    public void reportProcessingBatch() {
        this.increaseCounter(IDX_PROCESSING_BATCH);
    }

    public void reportBatchCompleted(int batchSeqNo, boolean hasError) {
        this.increaseCounter(IDX_COMPLETED_BATCH);
        if (hasError) {
            if (this.errorBatchFlags == null) {
                this.errorBatchFlags = new BitSet();
            }
            this.errorBatchFlags.set(batchSeqNo);
        }
    }

    protected void increaseCounter(int idx) {
        int n = idx;
        this.barrierStatisticCounter[n] = this.barrierStatisticCounter[n] + 1;
    }

    public int getCounterValue(int idx) {
        return this.barrierStatisticCounter[idx];
    }

    public boolean isBarrierOpen() {
        return this.barrierStatisticCounter[IDX_WAITING_BATCH] == this.barrierStatisticCounter[IDX_COMPLETED_BATCH];
    }

    public boolean hasErrorBatch() {
        return this.errorBatchFlags != null && !this.errorBatchFlags.isEmpty();
    }

    public List<Object> getBatchBarrierKey() {
        return this.batchBarrierKey;
    }

    public void setBatchBarrierKey(List<Object> batchBarrierKey) {
        this.batchBarrierKey = batchBarrierKey;
    }

    public int[] getBarrierStatisticCounter() {
        return this.barrierStatisticCounter;
    }

    public void setBarrierStatisticCounter(int[] barrierStatisticCounter) {
        this.barrierStatisticCounter = barrierStatisticCounter;
    }

    public BitSet getErrorBatchFlags() {
        return this.errorBatchFlags;
    }

    public void setErrorBatchFlags(BitSet errorBatchFlags) {
        this.errorBatchFlags = errorBatchFlags;
    }
}

