/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.statistics;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class TaskBatchStatusStatistics
implements Iterator<Integer> {
    private BitSet registerBatchFlags;
    private volatile int maxRegisterBatchNo;
    private AtomicInteger maxUsedBatchNo;
    protected String cacheTypeKey;
    protected Class<?> targetCacheClassType;
    private transient ReentrantLock lock;

    public TaskBatchStatusStatistics() {
    }

    public TaskBatchStatusStatistics(String cacheTypeKey, int totalBatchCnt) {
        this.registerBatchFlags = new BitSet(0);
        this.maxRegisterBatchNo = totalBatchCnt;
        this.maxUsedBatchNo = new AtomicInteger(0);
        this.cacheTypeKey = cacheTypeKey;
        this.lock = new ReentrantLock();
    }

    public TaskBatchStatusStatistics(String cacheTypeKey) {
        this(cacheTypeKey, 0);
    }

    protected TaskBatchStatusStatistics(Class<?> targetCacheClassType) {
        this(null, 0);
        this.targetCacheClassType = targetCacheClassType;
    }

    public void registerBatch(int batchSeqNo, boolean error) {
        this.lock.lock();
        try {
            if (this.maxRegisterBatchNo < batchSeqNo) {
                this.maxRegisterBatchNo = batchSeqNo;
            }
            if (error) {
                this.registerBatchFlags.set(batchSeqNo);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void registerBatch(int batchSeqNo) {
        this.registerBatch(batchSeqNo, false);
    }

    @Override
    public boolean hasNext() {
        this.lock.lock();
        try {
            int currentUseBatchNo = this.maxUsedBatchNo.get();
            boolean bl = this.maxRegisterBatchNo > currentUseBatchNo && this.registerBatchFlags.nextClearBit(currentUseBatchNo + 1) >= 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Integer next() {
        if (this.hasNext()) {
            return this.maxUsedBatchNo.incrementAndGet();
        }
        throw new NoSuchElementException();
    }

    public String getCacheTypeKey() {
        return this.cacheTypeKey;
    }

    public void setCacheTypeKey(String cacheTypeKey) {
        this.cacheTypeKey = cacheTypeKey;
    }

    public Class<?> getTargetCacheClassType() {
        return this.targetCacheClassType;
    }

    public void setTargetCacheClassType(Class<?> targetCacheClassType) {
        this.targetCacheClassType = targetCacheClassType;
    }
}

