/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.status;

public enum TaskStatusEnum {
    NEW(0),
    PROCESSING(2),
    SUSPENSED(3),
    COMPLETED(4),
    CANCELLED(5),
    WAIN(7),
    FAILURE(8),
    DELETED(9);

    private int code;

    private TaskStatusEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static int getMaxCode() {
        return TaskStatusEnum.DELETED.code;
    }

    public String getStringValue() {
        return String.valueOf(this.code);
    }

    public char getCharCode() {
        return String.valueOf(this.code).charAt(0);
    }

    public boolean isCancelled() {
        return this.code == TaskStatusEnum.CANCELLED.code;
    }

    public boolean isTaskEnd() {
        return this.code >= TaskStatusEnum.COMPLETED.code;
    }

    public boolean isFailure() {
        return this.code == TaskStatusEnum.FAILURE.code;
    }

    public static TaskStatusEnum getTaskStatusEnumByCode(int code) {
        switch (code) {
            case 2: {
                return PROCESSING;
            }
            case 3: {
                return SUSPENSED;
            }
            case 4: {
                return COMPLETED;
            }
            case 5: {
                return CANCELLED;
            }
            case 7: {
                return WAIN;
            }
            case 8: {
                return FAILURE;
            }
            case 9: {
                return DELETED;
            }
        }
        return NEW;
    }
}

