/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import com.alibaba.fastjson.JSONArray;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.function.BiFunction;
import java.util.function.Function;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class ArrayUtils {
    public static final int[] Empty_Int_Array = new int[0];

    public static String compareArrayValue(int seq, Object[] expect, Object[] actual) {
        return ICommonDataValueUtil.deepEquals(expect, actual) ? null : String.format("\n%d).Array Compare Error:\n\tExp=%s\n\tAct=%s", seq, Arrays.deepToString(expect), Arrays.deepToString(actual));
    }

    public static int[] getArrayDimensionMaxCnts(Object srcArray, int additionalDimCnts) {
        int length;
        if (srcArray == null) {
            return Empty_Int_Array;
        }
        boolean isJsonArray = srcArray instanceof JSONArray;
        int n = length = isJsonArray ? ArrayUtils.getJSonArrayLevelCnt((JSONArray)srcArray) : ArrayUtils.getArrayDimensions(srcArray);
        if (length == 0) {
            return additionalDimCnts > 0 ? new int[additionalDimCnts] : Empty_Int_Array;
        }
        int[] dimCnts = new int[length + additionalDimCnts];
        Arrays.fill(dimCnts, 0);
        ArrayUtils.getArrayDimensionMaxCntsEx(srcArray, dimCnts, 0, isJsonArray);
        return dimCnts;
    }

    public static int[] getArrayDimensionMaxCnts(Object srcArray) {
        return ArrayUtils.getArrayDimensionMaxCnts(srcArray, 0);
    }

    private static int getArrayDimensionMaxCntsEx(Object srcArray, int[] outputDimCnts, int level, boolean isJsonArray) {
        int length;
        if (srcArray == null) {
            return -1;
        }
        if (isJsonArray && !(srcArray instanceof JSONArray) || !isJsonArray && !srcArray.getClass().isArray()) {
            return 0;
        }
        int levelMaxLength = outputDimCnts[level];
        int n = length = isJsonArray ? ((JSONArray)srcArray).size() : Array.getLength(srcArray);
        if (length == 0) {
            return 0;
        }
        if (levelMaxLength < length) {
            levelMaxLength = outputDimCnts[level] = length;
        }
        if (outputDimCnts.length == level + 1) {
            return levelMaxLength;
        }
        int childMaxLength = outputDimCnts[level + 1];
        if (isJsonArray) {
            boolean i = false;
            for (Object jsonChild : (JSONArray)srcArray) {
                if (!(jsonChild instanceof JSONArray)) continue;
                int childArrayLength = ((JSONArray)jsonChild).size();
                if (childMaxLength < childArrayLength) {
                    childMaxLength = childArrayLength;
                }
                ArrayUtils.getArrayDimensionMaxCntsEx(jsonChild, outputDimCnts, level + 1, true);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Object child = Array.get(srcArray, i);
                if (child == null || !child.getClass().isArray()) continue;
                int childArrayLength = Array.getLength(srcArray);
                if (childMaxLength < childArrayLength) {
                    childMaxLength = childArrayLength;
                }
                ArrayUtils.getArrayDimensionMaxCntsEx(child, outputDimCnts, level + 1, false);
            }
        }
        return levelMaxLength;
    }

    public static Class getArrayComponentType(Object srcArray) {
        return ArrayUtils.getArrayComponentType(srcArray, true);
    }

    public static Class getArrayComponentType(Object srcArray, boolean nest) {
        if (srcArray == null) {
            return null;
        }
        Class<?> clazz = srcArray.getClass();
        if (nest) {
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        return clazz.isArray() ? clazz.getComponentType() : clazz;
    }

    public static int getArrayDimensions(Object srcArray, Class targetComponentType) {
        if (srcArray == null) {
            return -1;
        }
        int dimensions = 0;
        Class<?> clazz = srcArray.getClass();
        while (clazz.isArray()) {
            ++dimensions;
            clazz = clazz.getComponentType();
        }
        return targetComponentType == null || targetComponentType != null && targetComponentType.isAssignableFrom(clazz) ? dimensions : -1;
    }

    public static int getArrayDimensions(Object srcArray) {
        return ArrayUtils.getArrayDimensions(srcArray, null);
    }

    public static <T> void convertArray(Object srcObject, IMulDimArrayAccessFunc outputArrayFunc, int[] currentLevelPath, int currentLevel, boolean isJsonArray, Function<Object, T> convertFunc) {
        if (srcObject == null) {
            return;
        }
        int childLevelIndex = currentLevelPath == null ? 0 : currentLevelPath.length;
        int[] childLevelPath = currentLevelPath == null ? new int[1] : Arrays.copyOf(currentLevelPath, currentLevelPath.length + 1);
        int curLevelArrayLength = isJsonArray ? ((JSONArray)srcObject).size() : Array.getLength(srcObject);
        boolean isLastLevel = currentLevel + 1 >= outputArrayFunc.getDimArrayMaxLevel();
        outputArrayFunc.adjustArraySize(currentLevelPath, curLevelArrayLength);
        if (isJsonArray) {
            int i = 0;
            for (Object child : (JSONArray)srcObject) {
                childLevelPath[childLevelIndex] = i++;
                if (!isLastLevel && child instanceof JSONArray) {
                    ArrayUtils.convertArray(child, outputArrayFunc, childLevelPath, currentLevel + 1, isJsonArray, convertFunc);
                    continue;
                }
                if (child == null) {
                    outputArrayFunc.setNull(childLevelPath);
                    continue;
                }
                outputArrayFunc.setValueByPath(childLevelPath, convertFunc.apply(child));
            }
        } else {
            for (int i = 0; i < curLevelArrayLength; ++i) {
                childLevelPath[childLevelIndex] = i;
                Object child = Array.get(srcObject, i);
                if (child != null && !isLastLevel && child.getClass().isArray()) {
                    ArrayUtils.convertArray(child, outputArrayFunc, childLevelPath, currentLevel + 1, isJsonArray, convertFunc);
                    continue;
                }
                if (child == null) {
                    outputArrayFunc.setNull(childLevelPath);
                    continue;
                }
                outputArrayFunc.setValueByPath(childLevelPath, convertFunc.apply(child));
            }
        }
    }

    public static <T> void convertArray(Object srcObject, IMulDimArrayAccessFunc outputArrayFunc, boolean isJsonArray, Function<Object, T> convertFunc) {
        ArrayUtils.convertArray(srcObject, outputArrayFunc, null, 0, isJsonArray, convertFunc);
    }

    public static Object getMulDimArrayByPath(Object srcMulDimArrays, int[] targetArrayPath) {
        if (srcMulDimArrays == null || targetArrayPath == null) {
            return null;
        }
        int pathLength = targetArrayPath.length;
        if (pathLength == 0) {
            return srcMulDimArrays;
        }
        Object result = srcMulDimArrays;
        for (int i = 0; i < pathLength; ++i) {
            result = Array.get(result, targetArrayPath[i]);
        }
        return result;
    }

    public static boolean setMulDimArrayByPath(Object srcMulDimArrays, int[] targetArrayPath, Object newValue) {
        if (srcMulDimArrays == null || targetArrayPath == null) {
            return false;
        }
        int pathLength = targetArrayPath.length;
        if (pathLength == 0) {
            return false;
        }
        Object result = srcMulDimArrays;
        if (pathLength > 1) {
            for (int i = 0; i < pathLength - 1; ++i) {
                result = Array.get(result, targetArrayPath[i]);
            }
        }
        Array.set(result, targetArrayPath[pathLength - 1], newValue);
        return true;
    }

    public static IMulDimArrayAccessFunc buildMulDimArrayLookupFunc(Object srcMulDimArrays) {
        return new MulDimArrayAccessWrapperFunc(srcMulDimArrays);
    }

    public static int getJSonArrayLevelCnt(JSONArray jsonArray) {
        if (jsonArray == null) {
            return -1;
        }
        int maxLevel = 1;
        for (Object object : jsonArray) {
            int childLevel;
            if (!(object instanceof JSONArray) || maxLevel >= (childLevel = 1 + ArrayUtils.getJSonArrayLevelCnt((JSONArray)object))) continue;
            maxLevel = childLevel;
        }
        return maxLevel;
    }

    public static <T> T[] combineArray(T[] reserveData, T[] sourceData, int reservePosition, Class targetClassType) {
        if (sourceData == null) {
            return null;
        }
        if (reserveData != null && reserveData.length > 0) {
            Object[] newCopyBuf;
            int oldLength = sourceData.length;
            int extendLength = reserveData.length;
            int newLength = extendLength + oldLength;
            Object[] objectArray = newCopyBuf = targetClassType == Object.class ? new Object[newLength] : (Object[])Array.newInstance(targetClassType.getComponentType(), newLength);
            if (reservePosition < 0) {
                reservePosition = 0;
            } else if (reservePosition > oldLength) {
                reservePosition = oldLength;
            }
            if (reservePosition == 0) {
                System.arraycopy(reserveData, 0, newCopyBuf, 0, extendLength);
                System.arraycopy(sourceData, 0, newCopyBuf, extendLength, oldLength);
            } else if (reservePosition >= oldLength) {
                System.arraycopy(sourceData, 0, newCopyBuf, 0, oldLength);
                System.arraycopy(reserveData, 0, newCopyBuf, oldLength - 1, extendLength);
            } else {
                System.arraycopy(reserveData, 0, newCopyBuf, 0, reservePosition);
                System.arraycopy(sourceData, 0, newCopyBuf, reservePosition, oldLength);
                System.arraycopy(reserveData, reservePosition, newCopyBuf, reservePosition + oldLength, extendLength - reservePosition);
            }
            return newCopyBuf;
        }
        return sourceData;
    }

    public static <T> T[] combineArray(T[] reserveData, T[] sourceData, int reservePosition) {
        if (sourceData == null) {
            return null;
        }
        return ArrayUtils.combineArray(reserveData, sourceData, reservePosition, sourceData.getClass());
    }

    public static <T> T[] combineArray(T[] reserveData, T[] sourceData, boolean reservePosition) {
        if (sourceData == null) {
            return null;
        }
        return ArrayUtils.combineArray(reserveData, sourceData, reservePosition ? 0 : sourceData.length, sourceData.getClass());
    }

    public static void fillArray(Object srcArray, Object fillValue) {
        if (srcArray == null || !srcArray.getClass().isArray()) {
            return;
        }
        int sourceLength = Array.getLength(srcArray);
        for (int i = 0; i < sourceLength; ++i) {
            Object valBuf = Array.get(srcArray, i);
            if (valBuf == null) continue;
            if (valBuf.getClass().isArray()) {
                ArrayUtils.fillArray(valBuf, fillValue);
                continue;
            }
            Array.set(srcArray, i, fillValue);
        }
    }

    public static Object copyArrayObject(Object srcArrayObject, int newSize, int copyStartPos, int copyEndPos, int writeStartPos) {
        if (newSize <= 0 || copyEndPos == 0 || srcArrayObject == null || !srcArrayObject.getClass().isArray()) {
            return null;
        }
        if (copyStartPos < 0) {
            copyStartPos = 0;
        }
        if (copyEndPos < 0) {
            copyEndPos = Array.getLength(srcArrayObject);
        }
        copyEndPos = Math.min(copyEndPos, newSize);
        Object result = Array.newInstance(srcArrayObject.getClass().getComponentType(), newSize);
        int pos = writeStartPos;
        for (int i = copyStartPos; i < copyEndPos; ++i) {
            Array.set(result, pos++, Array.get(srcArrayObject, i));
        }
        return result;
    }

    public static Object copyArrayObject(Object srcArrayObject, int newSize, int copyStartPos, int copyEndPos) {
        return ArrayUtils.copyArrayObject(srcArrayObject, newSize, copyStartPos, copyEndPos, 0);
    }

    public static Object copyArrayObject(Object srcArrayObject, int newSize) {
        return ArrayUtils.copyArrayObject(srcArrayObject, newSize, -1, -1, 0);
    }

    public static <T> T[] copyArray(Object[] src, Class<T> classType, int additionalSize, Function<Object, T> convertFunc) {
        if (src == null) {
            return null;
        }
        int length = src.length;
        Object[] result = (Object[])Array.newInstance(classType, src.length + Math.max(additionalSize, 0));
        for (int i = 0; i < length; ++i) {
            result[i] = convertFunc.apply(src[i]);
        }
        return result;
    }

    public static <T> T[] copyArray(Object[] src, Class<T> classType, Function<Object, T> convertFunc) {
        return ArrayUtils.copyArray(src, classType, 0, convertFunc);
    }

    public static <T> T[] copyArray(Object[] src, Class<T> classType) {
        return ArrayUtils.copyArray(src, classType, 0, o -> o);
    }

    public static StringBuilder dumpArray(Object srcArray, int level, String prefix, BiFunction<Integer, Object, String> dumpFunc) {
        if (srcArray == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (!srcArray.getClass().isArray()) {
            buf.append(dumpFunc.apply(level, srcArray));
        } else {
            int i;
            int arrayLength = Array.getLength(srcArray);
            LinkedList<CharSequence> lineBuffer = new LinkedList<CharSequence>();
            boolean hasChild = false;
            for (i = 0; i < arrayLength; ++i) {
                Object child = Array.get(srcArray, i);
                if (child == null) {
                    lineBuffer.add(null);
                    continue;
                }
                if (child.getClass().isArray()) {
                    lineBuffer.add(ArrayUtils.dumpArray(child, level + 1, prefix, dumpFunc));
                    hasChild = true;
                    continue;
                }
                lineBuffer.add(dumpFunc.apply(level, child));
            }
            if (!hasChild) {
                buf.append(lineBuffer);
            } else {
                i = 1;
                int childLevel = level + 1;
                buf.append(String.format("(Level:%d, Size:%d)", level, lineBuffer.size()));
                String levelPrefix = StringUtils.buildPrefix(prefix, childLevel);
                for (Object e : lineBuffer) {
                    buf.append(String.format("\n%s[L:%d] %d).%s", levelPrefix, childLevel, i++, e));
                }
            }
        }
        return buf;
    }

    public static StringBuilder dumpArray(Object srcArray, BiFunction<Integer, Object, String> dumpFunc) {
        return ArrayUtils.dumpArray(srcArray, 0, "  ", dumpFunc);
    }

    public static StringBuilder dumpArray(Object srcArray) {
        return ArrayUtils.dumpArray(srcArray, (level, obj) -> String.valueOf(obj));
    }

    public static class MulDimArrayAccessWrapperFunc
    implements IMulDimArrayAccessFunc {
        private Object srcArray;
        private boolean eof;
        private int maxLevel;

        public MulDimArrayAccessWrapperFunc(Object srcMulDimArrays) {
            this.srcArray = srcMulDimArrays;
            this.eof = this.srcArray == null;
            this.maxLevel = ArrayUtils.getArrayDimensions(this.srcArray);
        }

        @Override
        public int getDimArrayMaxLevel() {
            return this.maxLevel;
        }

        @Override
        public Object getValueByPath(int[] path) {
            return this.eof ? null : ArrayUtils.getMulDimArrayByPath(this.srcArray, path);
        }

        @Override
        public boolean setValueByPath(int[] path, Object newValue) {
            return this.eof ? false : ArrayUtils.setMulDimArrayByPath(this.srcArray, path, newValue);
        }

        @Override
        public void clearAll() {
            if (this.srcArray.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(this.srcArray); ++i) {
                    Array.set(this.srcArray, i, null);
                }
            }
        }

        public Object getSrcArray() {
            return this.srcArray;
        }

        public void setSrcArray(Object srcArray) {
            this.srcArray = srcArray;
            this.eof = this.srcArray == null;
            this.maxLevel = ArrayUtils.getArrayDimensions(srcArray);
        }

        public boolean isEof() {
            return this.eof;
        }
    }

    public static interface IMulDimArrayAccessFunc {
        public int getDimArrayMaxLevel();

        public Object getValueByPath(int[] var1);

        public boolean setValueByPath(int[] var1, Object var2);

        default public boolean adjustArraySize(int[] path, int expectSize) {
            Object target = this.getValueByPath(path);
            if (target == null || !target.getClass().isArray()) {
                return false;
            }
            int oldLength = Array.getLength(target);
            if (oldLength != expectSize) {
                this.setValueByPath(path, ArrayUtils.copyArrayObject(target, expectSize));
            }
            return true;
        }

        default public void setNull(int[] path) {
            this.setValueByPath(path, null);
        }

        public void clearAll();
    }
}

