/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.metadata.entity.fielddefvalue.DefValueDesign;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.MasterDataGroupTypeEnum;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.ExtDataModelSystemFieldEnum;
import kd.fi.v2.fah.constant.enums.FieldPropEnum;
import kd.fi.v2.fah.constant.enums.NotNull;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldPropCfg;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.validator.context.BasePropReferenceInfo;
import kd.fi.v2.fah.validator.processor.IMasterDataBatchValidateProcessor;

public class DataModelUtils {
    private static final Pattern NumberMatch_Pattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");
    private static final Pattern Chinese_Pattern = Pattern.compile("[\\u4e00-\\u9fa5]|[\\u3000-\\u303F\\uFF00-\\uFFEF]");

    public static BaseMutableArrayMapStorage<String, DataModelFieldPropCfg> fromJsonToDataModelField(String propertyJSON) {
        DataModelFieldCfg.FieldPropCollectionImpl props = new DataModelFieldCfg.FieldPropCollectionImpl();
        if (StringUtils.isEmpty((String)propertyJSON)) {
            return props;
        }
        DataModelFieldPropCfg[] propCfgs = (DataModelFieldPropCfg[])JSON.parseObject((String)propertyJSON, DataModelFieldPropCfg[].class);
        if (propCfgs != null && propCfgs.length > 0) {
            for (DataModelFieldPropCfg propCfg : propCfgs) {
                if (propCfg == null) continue;
                DataModelFieldPropCfg dataModelFieldPropCfg = new DataModelFieldPropCfg(propCfg.getName(), propCfg.getPropDataType(), propCfg.getPropValue(), propCfg.getDescription());
                props.cache(dataModelFieldPropCfg);
            }
            props.flush();
        }
        return props;
    }

    public static String getNumber(String longNumber) {
        String number = StringUtils.getHeaderOrTailWord(longNumber, '|', false);
        return "".equals(number) ? longNumber : number;
    }

    public static String getParentLongNumber(String longNumber) {
        String parentLongNumber = StringUtils.getHeaderOrTailSegment(longNumber, '|', false);
        return "".equals(parentLongNumber) ? longNumber : parentLongNumber;
    }

    public static String getRootNumber(String longNumber) {
        String rootNumber = StringUtils.getHeaderOrTailWord(longNumber, '|', true);
        return "".equals(rootNumber) ? longNumber : rootNumber;
    }

    public static boolean isNumberMatch(String number) {
        return NumberMatch_Pattern.matcher(number).matches();
    }

    public static boolean isContainChinese(String number) {
        return Chinese_Pattern.matcher(number).find();
    }

    public static DataModelCfg updateDataModel(DataModelCfg dataModel) {
        HashMap<String, Long> groupNumberMap = new HashMap<String, Long>();
        SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
        for (DataModelFieldCollection group : dataModel) {
            Long[] sequences = (Long[])sReader.getSequences((Object[])new Long[1], "fah_ext_model_fldgrp", 1);
            Long newId = sequences[0];
            group.setId(newId);
            groupNumberMap.put(group.getNumber(), newId);
        }
        for (DataModelFieldCollection group : dataModel) {
            String parentLongNumber;
            if (group.getParentId() == 0L || StringUtils.isEmpty((String)(parentLongNumber = DataModelUtils.getParentLongNumber(group.getNumber())))) continue;
            group.setParentId((Long)groupNumberMap.get(parentLongNumber));
        }
        return dataModel;
    }

    public static JSONObject buildJsonTemplate(Long modelId, int dataCnt) {
        JSONObject rootJson = new JSONObject(new LinkedHashMap(2));
        JSONArray dataArray = new JSONArray();
        rootJson.put("datas", (Object)dataArray);
        JSONObject datasJson = new JSONObject(new LinkedHashMap());
        dataArray.add((Object)datasJson);
        datasJson.put("eventclass", (Object)ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u7f16\u7801", (String)"DataModelUtils_0", (String)"fi-ai-common", (Object[])new Object[0]));
        for (ExtDataModelSystemFieldEnum systemFieldEnum : ExtDataModelSystemFieldEnum.values()) {
            if (ExtDataModelSystemFieldEnum.PAGING == systemFieldEnum || ExtDataModelSystemFieldEnum.SAVE_DEFAULT == systemFieldEnum) {
                datasJson.put(systemFieldEnum.getNumber(), (Object)Boolean.FALSE);
                continue;
            }
            datasJson.put(systemFieldEnum.getNumber(), (Object)systemFieldEnum.getName());
        }
        DataModelCfg dataModelCfg = (DataModelCfg)DataModelDaoImpl.loadFromDBById(modelId).getKey();
        if (null != dataModelCfg) {
            JSONObject dataJson = dataModelCfg.buildJson(dataCnt);
            datasJson.put("data", (Object)dataJson);
        }
        return rootJson;
    }

    public static String outputFormattedJsonString(JSONObject srcJson) {
        return JSON.toJSONString((Object)srcJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
    }

    public static Object getFieldMasterDataDefaultValue(@NotNull DataModelFieldCfg srcField) {
        Object defualtValue = null;
        if (MasterDataGroupTypeEnum.isMasterDataType(srcField.getDataType())) {
            defualtValue = srcField.getPropValue(FieldPropEnum.DEFVALUE, null);
        }
        return defualtValue;
    }

    protected static boolean updateFieldCfgMasterDataDefaultValue(DataModelFieldCfg srcField, Object oldValue, Object newValue) {
        if (null == newValue) {
            return false;
        }
        if (newValue.equals(oldValue)) {
            return true;
        }
        MasterDataGroupTypeEnum dataGroupType = MasterDataGroupTypeEnum.convert(srcField.getDataType());
        if (null != dataGroupType) {
            Object defaultValue = srcField.getPropValue(FieldPropEnum.DEFVALUEDESIGN, null);
            if (defaultValue == null) {
                return false;
            }
            DefValueDesign defValueDesign = (DefValueDesign)JSON.parseObject((String)defaultValue, DefValueDesign.class);
            JSONObject jsonObj = JSON.parseObject((String)defValueDesign.getFuncParameter());
            switch (dataGroupType) {
                case Base_Prop: 
                case Assist_Prop: {
                    jsonObj.put("id", newValue);
                    break;
                }
            }
        }
        return true;
    }

    public static boolean registerValiateMasterData(@NotNull DataModelCfg dataModelCfg, IMasterDataBatchValidateProcessor validateProcessor) {
        boolean result = true;
        for (DataModelFieldCollection dataModelFields : (BaseMutableArrayMapStorage)dataModelCfg.getCollections()) {
            BaseMutableArrayMapStorage fieldCfgs = (BaseMutableArrayMapStorage)dataModelFields.getCollections();
            if (null == fieldCfgs) continue;
            for (DataModelFieldCfg fieldCfg : fieldCfgs) {
                if (fieldCfg.getDataType() != DataValueTypeEnum.BaseProp && fieldCfg.getDataType() != DataValueTypeEnum.AssistProp || DataModelUtils.registerValiateMasterData(fieldCfg, validateProcessor)) continue;
                result = false;
            }
        }
        return result;
    }

    public static boolean registerValiateMasterData(@NotNull DataModelFieldCfg srcField, IMasterDataBatchValidateProcessor validateProcessor) {
        MasterDataGroupTypeEnum dataGroupType = MasterDataGroupTypeEnum.convert(srcField.getDataType());
        BasePropReferenceInfo<Object, DataModelFieldCfg> referenceInfo = null;
        if (dataGroupType != null) {
            Object defaultValue;
            String refBaseProp = srcField.getRefBaseProp();
            if (dataGroupType == MasterDataGroupTypeEnum.Assist_Prop) {
                if (null == refBaseProp) {
                    srcField.setRefAssistProp(-1L);
                    return false;
                }
                srcField.setRefBaseProp(null);
                QFilter gFilter = new QFilter("number", "=", (Object)refBaseProp);
                DynamicObject group = QueryServiceHelper.queryOne((String)"bos_assistantdatagroup", (String)"id", (QFilter[])new QFilter[]{gFilter});
                if (null != group) {
                    srcField.setRefAssistProp(group.getLong("id"));
                } else {
                    srcField.setRefAssistProp(-1L);
                    return false;
                }
            }
            if ((defaultValue = srcField.getPropValue(FieldPropEnum.DEFVALUEDESIGN, null)) == null) {
                return false;
            }
            DefValueDesign defValueDesign = (DefValueDesign)JSON.parseObject((String)defaultValue, DefValueDesign.class);
            JSONObject jsonObj = JSON.parseObject((String)defValueDesign.getFuncParameter());
            Object number = jsonObj.get((Object)"number");
            Object id = jsonObj.get((Object)"id");
            switch (dataGroupType) {
                case Base_Prop: {
                    referenceInfo = validateProcessor.registerBasePropData(refBaseProp, number, id, srcField);
                    break;
                }
                case Assist_Prop: {
                    referenceInfo = validateProcessor.registerAssistPropData(refBaseProp, number, id, srcField);
                    break;
                }
            }
        }
        return referenceInfo != null;
    }

    public static String getFieldFullName(String fieldName, DataModelCfg srcData, DataModelFieldCollection parent) {
        if (null != parent) {
            String number = DataModelUtils.getNumber(parent.getNumber());
            fieldName = parent.getName() + "(" + number + ")_" + fieldName;
            if (parent.getGroupLevel() > 1) {
                String parentLongNumber = DataModelUtils.getParentLongNumber(parent.getNumber());
                parent = (DataModelFieldCollection)srcData.get(parentLongNumber);
                return DataModelUtils.getFieldFullName(fieldName, srcData, parent);
            }
        }
        return fieldName;
    }

    public static boolean isEventBill(String billNumber) {
        if (StringUtils.isEmpty((String)billNumber)) {
            return false;
        }
        return billNumber.startsWith("fah_e_");
    }
}

