/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import kd.bos.context.RequestContext;
import kd.fi.v2.fah.constant.enums.TimePeriodTypeEnum;

public class DateValueUtils {
    public static final String yyyy = "yyyy";
    public static final String yyyy_MM = "yyyy.MM";
    public static final String MM_yyyy = "MM.yyyy";
    public static final String yyyy_MM_dd = "yyyy.MM.dd";
    public static final String MM_dd_yyyy = "MM.dd.yyyy";
    public static final String yyyy_MM_dd_HH_mm_ss = "yyyy.MM.dd HH:mm:ss";
    public static final String MM_dd_yyyy_HH_mm_ss = "MM.dd.yyyy HH:mm:ss";
    public static final String yyyyMMddHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static final String yyyyMMdd = "yyyyMMdd";

    private static final SimpleDateFormat getDateFormat() {
        return DateValueUtils.getDateFormat(yyyyMMdd);
    }

    private static final SimpleDateFormat getDateFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static Date getFirstDate() {
        try {
            return DateValueUtils.getDateFormat().parse("19990101");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date getLastDate() {
        try {
            return DateValueUtils.appendtTime(DateValueUtils.getDateFormat().parse("29991231"));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Integer dateToInteger(Date sourceDate) {
        if (sourceDate == null) {
            return null;
        }
        return Integer.valueOf(DateValueUtils.getDateFormat().format(sourceDate));
    }

    public static String dateToString(Date sourceDate, String pattern) {
        if (sourceDate == null) {
            return null;
        }
        return DateValueUtils.getDateFormat(pattern).format(sourceDate);
    }

    public static String dateToString(Date sourceDate) {
        return DateValueUtils.dateToString(sourceDate, yyyyMMdd);
    }

    public static Date stringToDate(String source, String pattern) {
        if (source == null) {
            return null;
        }
        try {
            return DateValueUtils.getDateFormat(pattern).parse(source);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date stringToDate(String source) {
        return DateValueUtils.stringToDate(source, yyyyMMdd);
    }

    public static Date truncateDateTime(Date source) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(source);
        calendar.clear(9);
        calendar.clear(11);
        calendar.clear(10);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        return calendar.getTime();
    }

    public static long getTimeInDay(Date sourceDt) {
        if (sourceDt == null) {
            return -1L;
        }
        return sourceDt.getTime() - DateValueUtils.truncateDateTime(sourceDt).getTime();
    }

    public static Date getDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day);
        return DateValueUtils.truncateDateTime(calendar.getTime());
    }

    public static Date getCurrentDate() {
        return DateValueUtils.truncateDateTime(new Date());
    }

    public static Calendar truncateCalendarTime(Calendar calendar) {
        calendar.clear(11);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        calendar.clear(15);
        calendar.clear(16);
        return calendar;
    }

    public static Date getDateTime(int year, int month, int day, int hour, int min, int sec) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, hour, min, sec);
        calendar.clear(14);
        return calendar.getTime();
    }

    public static Date getDateTime(int year, int month, int day, int hour, int min, int sec, int milliSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, hour, min, sec);
        calendar.set(14, milliSecond);
        return calendar.getTime();
    }

    public static int getDateValue(int field, Date sourceDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(sourceDate);
        return calendar.get(field);
    }

    public static Date appendTime(Date sourceDate, boolean maxTime) {
        return DateValueUtils.appendTime(Calendar.getInstance(), sourceDate, maxTime);
    }

    public static Date appendTime(Calendar calendar, Date sourceDate, boolean maxTime) {
        if (sourceDate != null) {
            calendar.setTime(sourceDate);
        }
        calendar.set(11, maxTime ? 23 : 0);
        calendar.set(12, maxTime ? 59 : 0);
        calendar.set(13, maxTime ? 59 : 0);
        calendar.set(14, maxTime ? 999 : 0);
        return calendar.getTime();
    }

    public static Date appendtTime(Date sourceDate) {
        return DateValueUtils.appendTime(sourceDate, false);
    }

    public static Date truncateDate(Date sourceDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        return DateValueUtils.truncateDate(calendar, sourceDate);
    }

    protected static Date truncateDate(Calendar calendar, Date sourceDate) {
        calendar.setTime(sourceDate);
        calendar.clear(11);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        return calendar.getTime();
    }

    protected static long truncateDateTime(Calendar calendar, Date sourceDate) {
        return DateValueUtils.truncateDate(calendar, sourceDate).getTime();
    }

    public static boolean isDateInRange(Date checkDate, Date startRange, Date endRange) {
        if (checkDate == null) {
            return false;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        long checkTime = DateValueUtils.truncateDateTime(calendar, checkDate);
        long startTime = DateValueUtils.truncateDateTime(calendar, startRange);
        long endTime = DateValueUtils.truncateDateTime(calendar, endRange);
        return checkTime >= startTime && checkTime <= endTime;
    }

    public static Date getFirstOrLastDayOfMonth(Date sourceDate, boolean firstDay, boolean resetTime) {
        return DateValueUtils.getPeriodDay(TimePeriodTypeEnum.Month, sourceDate, firstDay, resetTime);
    }

    public static int getMonthPeriodDayCnt(Date sourceDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(sourceDate);
        return calendar.getActualMaximum(5);
    }

    public static int getDayOfMonth(Date sourceDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(sourceDate);
        return calendar.get(5);
    }

    public static Date getPeriodDay(TimePeriodTypeEnum periodType, Date sourceDate, boolean firstDay, boolean resetTime) {
        int currentDay;
        int endYear;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        int startDay = 1;
        int startYear = endYear = calendar.get(1);
        int currentMonth = calendar.get(2);
        int endDay = currentDay = calendar.get(5);
        int startMonth = currentMonth;
        int endMonth = currentMonth;
        block0 : switch (periodType) {
            case Week: {
                calendar.add(6, -1 * (calendar.get(7) - 1));
                startDay = calendar.get(5);
                startMonth = calendar.get(2);
                startYear = calendar.get(1);
                calendar.add(6, 6);
                endMonth = calendar.get(2);
                endDay = calendar.get(5);
                endYear = calendar.get(1);
                break;
            }
            case Month: {
                startDay = calendar.getActualMinimum(5);
                endDay = calendar.getActualMaximum(5);
                break;
            }
            case Quarter: {
                int quarer = (currentMonth + 1) / 4;
                startMonth = quarer * 3;
                endMonth = quarer * 3 + 2;
                switch (quarer) {
                    case 0: 
                    case 3: {
                        endDay = 31;
                        break block0;
                    }
                }
                endDay = 30;
                break;
            }
            case HalfYear: {
                startMonth = currentMonth / 6;
                endMonth = startMonth * 6 + 5;
                switch (startMonth) {
                    case 1: {
                        endDay = 31;
                        break block0;
                    }
                }
                endDay = 30;
                break;
            }
            case Year: {
                startMonth = 0;
                endMonth = 11;
                endDay = 31;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("CalendarDatePeriod Not Support [%s] Period Type", new Object[]{periodType}));
            }
        }
        if (firstDay) {
            if (resetTime) {
                calendar.set(startYear, startMonth, startDay, 0, 0, 0);
                calendar.clear(14);
            } else {
                calendar.set(startYear, startMonth, startDay);
            }
        } else if (resetTime) {
            calendar.set(endYear, endMonth, endDay, 23, 59, 59);
            calendar.set(14, 999);
        } else {
            calendar.set(endYear, endMonth, endDay);
        }
        return calendar.getTime();
    }

    public static String getTimeDiff(Date nowDate, Date endDate) {
        return DateValueUtils.getTimeDiff(endDate.getTime() - nowDate.getTime());
    }

    public static String getTimeDiff(long diff) {
        long day = diff / 86400000L;
        long hour = diff / 3600000L - day * 24L;
        long min = diff / 60000L - day * 24L * 60L - hour * 60L;
        long s = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long ms = diff - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        StringBuilder executeTime = new StringBuilder();
        if (day > 0L) {
            executeTime.append(day).append(' ');
        }
        executeTime.append(hour <= 9L ? "0" + hour : Long.valueOf(hour)).append(':');
        executeTime.append(min <= 9L ? "0" + min : Long.valueOf(min)).append(':');
        executeTime.append(s <= 9L ? "0" + s : Long.valueOf(s)).append(':');
        executeTime.append(ms < 9L ? "00" + ms : (ms < 99L ? "0" + ms : Long.valueOf(ms)));
        return executeTime.toString();
    }

    public static long cost() {
        long cost;
        if (null == RequestContext.get().getRequestTimeoutContext()) {
            cost = 100L;
        } else {
            long startTime = RequestContext.get().getRequestTimeoutContext().getStartTime();
            cost = System.currentTimeMillis() - startTime;
        }
        return cost;
    }
}

