/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.util.DateUtil;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.models.event.eventrule.ConstantValue;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldCfg;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.utils.ExtractFieldUtils;

public class DynFieldValueSetUtil {
    public static void showConstantForm(IFormView view, IFormPlugin plugin, String actionId, DynamicExtractFieldCfg dynExtFieldCfg, DynamicExtractFieldValueSetData model) {
        DynamicExtractFieldValueSet valueSet;
        String constantValueStr;
        List<DynamicExtractFieldValueSet> valueSetList;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fah_constant_value");
        ConstantValue constantValue = null;
        if (null != model && null != (valueSetList = model.getFieldValueSetList()) && !valueSetList.isEmpty() && StringUtils.isNotBlank((CharSequence)(constantValueStr = (valueSet = valueSetList.get(0)).getConstantValue()))) {
            constantValue = (ConstantValue)SerializationUtils.fromJsonString((String)constantValueStr, ConstantValue.class);
        }
        if (null == constantValue) {
            constantValue = new ConstantValue();
            DataValueTypeEnum dataType = dynExtFieldCfg.getOutputDataType();
            if (null != dataType) {
                constantValue.setDataType(dataType);
                String baseProp = dynExtFieldCfg.getBaseProp();
                Long assistProp = dynExtFieldCfg.getAssistProp();
                switch (dataType) {
                    case BaseProp: {
                        if (!StringUtils.isNotBlank((CharSequence)baseProp)) break;
                        constantValue.setBaseProp(baseProp);
                        break;
                    }
                    case AssistProp: {
                        if (null == assistProp) break;
                        constantValue.setAssistProp(assistProp);
                        break;
                    }
                }
            }
        }
        showParameter.setCustomParam("value", (Object)SerializationUtils.toJsonString((Object)constantValue));
        showParameter.setCustomParam("detailselect", (Object)Boolean.TRUE.toString());
        StyleCss style = new StyleCss();
        style.setWidth("400");
        style.setHeight("140");
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void showMappingForm(IFormView view, IFormPlugin plugin, String mappingField, DynamicExtractFieldValueSetData model) {
        String sourceBill = (String)view.getFormShowParameter().getCustomParam("sourceBill");
        if (StringUtils.isBlank((CharSequence)sourceBill)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"DynFieldValueSetUtil_0", (String)"fi-ai-common", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fah_dyn_extfld_setmapping");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("sourcePage", view.getFormShowParameter().getCustomParam("sourcePage"));
        showParameter.setCustomParam("sourcePageId", view.getFormShowParameter().getCustomParam("sourcePageId"));
        showParameter.setCustomParam("sourcePageField", view.getFormShowParameter().getCustomParam("sourcePageField"));
        showParameter.setCustomParam("entryNumber", view.getFormShowParameter().getCustomParam("entryNumber"));
        showParameter.setCustomParam("sourceBill", (Object)sourceBill);
        if (null != model) {
            showParameter.setCustomParam("dynFldVal", (Object)SerializationUtils.serializeToBase64((Object)model.getFieldValueSetList().get(0)));
        }
        showParameter.setCloseCallBack(new CloseCallBack(plugin, mappingField));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void showExpressionForm(IFormView view, IFormPlugin plugin, String field, DynamicExtractFieldValueSetData model) {
        String expressionValueStr;
        List<DynamicExtractFieldValueSet> valueSetList;
        HashSet<String> entrySet = new HashSet<String>(2);
        String sourceBill = (String)view.getFormShowParameter().getCustomParam("sourceBill");
        String entryNumber = (String)view.getFormShowParameter().getCustomParam("entryNumber");
        if (null == sourceBill) {
            return;
        }
        entrySet.add(sourceBill);
        if (null != entryNumber) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)sourceBill);
            Map allEntities = mainEntityType.getAllEntities();
            EntityType filterEntityType = (EntityType)allEntities.get(entryNumber);
            if (filterEntityType instanceof SubEntryType) {
                entrySet.add(filterEntityType.getName());
                entrySet.add(filterEntityType.getParent().getName());
            } else if (filterEntityType instanceof EntryType) {
                entrySet.add(filterEntityType.getName());
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_expression");
        showParameter.setCustomParam("build", (Object)sourceBill);
        showParameter.setCustomParam("entitynumber", (Object)sourceBill);
        FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
        HashSet<String> functionIds = new HashSet<String>();
        functionIds.add("Math");
        functionIds.add("String");
        functionIds.add("DateTime");
        functionTypes.getFunctionGroups().removeIf(functionGroup -> !functionIds.contains(functionGroup.getId()));
        showParameter.setCustomParam("functiontypes", (Object)FunctionTypes.serializeToXML((FunctionTypes)functionTypes));
        showParameter.setCustomParam("entryFilterSet", (Object)SerializationUtils.serializeToBase64(entrySet));
        showParameter.setCustomParam("addSpecialNodes", (Object)false);
        if (null != model && null != (valueSetList = model.getFieldValueSetList()) && !valueSetList.isEmpty() && StringUtils.isNotBlank((CharSequence)(expressionValueStr = valueSetList.get(0).getExpressionValue()))) {
            VchTplExpression expression = (VchTplExpression)SerializationUtils.fromJsonString((String)expressionValueStr, VchTplExpression.class);
            String exprJson = SerializationUtils.toJsonString((Object)expression);
            showParameter.setCustomParam("expression", (Object)exprJson);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, field);
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    public static void showBillFieldTreeForm(IFormView view, IFormPlugin plugin, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fah_billfieldtree");
        String sourcePage = (String)view.getFormShowParameter().getCustomParam("sourcePage");
        String sourceBill = (String)view.getFormShowParameter().getCustomParam("sourceBill");
        String sourceField = (String)view.getFormShowParameter().getCustomParam("sourcePageField");
        String entryNumber = (String)view.getFormShowParameter().getCustomParam("entryNumber");
        Map<String, Object> param = ExtractFieldUtils.buildTreeParam(sourcePage, sourceField, sourceBill, entryNumber);
        showParameter.setCustomParam("param", (Object)JSON.toJSONString(param));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        view.showForm(showParameter);
    }

    public static PairTuple<DynamicExtractFieldValueSetData, String> convertToDataOfExpression(Object returnData, Long pageId, String sourcePage, String sourceField) {
        if (StringUtils.isNotBlank((Object)returnData)) {
            VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)((String)returnData), VchReturnData.class);
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
            String dynFldDesc = filterObj.getDescription().toString();
            if (StringUtils.isEmpty((CharSequence)dynFldDesc)) {
                dynFldDesc = filterObj.getExprTran();
            }
            DynamicExtractFieldValueSet fieldValue = new DynamicExtractFieldValueSet();
            long valId = DBServiceHelper.genLongIds((String)"fah_dyn_extfld_val", (int)1)[0];
            fieldValue.setId(valId);
            fieldValue.setExpressionValue(retData.getDataStr());
            fieldValue.setBranchSeq(0);
            fieldValue.setGetValueType(ExtractTypeEnum.EXPRESSION);
            fieldValue.setRuleId(pageId);
            DynamicExtractFieldCfg extractFieldCfg = ExtractFieldUtils.loadDynamicExtractFieldCfg(sourcePage, sourceField);
            fieldValue.setDynExtFieldCfg(extractFieldCfg);
            DynamicExtractFieldValueSetData fieldValueData = new DynamicExtractFieldValueSetData();
            fieldValueData.setBranchId((Long)fieldValue.getId());
            fieldValueData.setMultiBranch(false);
            fieldValueData.setFieldValueSetList(Collections.singletonList(fieldValue));
            return new PairTuple((Object)fieldValueData, (Object)dynFldDesc);
        }
        return null;
    }

    public static PairTuple<DynamicExtractFieldValueSetData, String> convertToDataOfConstant(Object returnData, Long pageId, String sourcePage, String sourceField) {
        if (null != returnData) {
            DynamicExtractFieldValueSet fieldValue = new DynamicExtractFieldValueSet();
            long valId = DBServiceHelper.genLongIds((String)"fah_dyn_extfld_val", (int)1)[0];
            fieldValue.setId(valId);
            fieldValue.setConstantValue((String)returnData);
            ConstantValue fieldData = (ConstantValue)SerializationUtils.fromJsonString((String)((String)returnData), ConstantValue.class);
            DataValueTypeEnum typeEnum = fieldData.getDataType();
            String dynFldDesc = DataValueTypeEnum.BaseProp == typeEnum || DataValueTypeEnum.AssistProp == typeEnum ? fieldData.getName() : (String)fieldData.getValue();
            Object dataValue = fieldData.getValue();
            if (null != dataValue) {
                switch (typeEnum) {
                    case Date: {
                        Date date;
                        try {
                            date = DateUtil.getLongFormat().parse(dataValue.toString());
                        }
                        catch (ParseException e) {
                            throw new KDBizException("date parse error");
                        }
                        fieldValue.setDateValue(date);
                        break;
                    }
                    case BaseProp: {
                        fieldValue.setTextValue(fieldData.getBaseProp());
                        fieldValue.setRefPropValue(Long.parseLong(dataValue.toString()));
                        break;
                    }
                    case AssistProp: {
                        if (fieldData.getAssistProp() != null) {
                            fieldValue.setTextValue(String.valueOf(fieldData.getAssistProp()));
                        }
                        fieldValue.setRefPropValue(Long.parseLong(dataValue.toString()));
                        break;
                    }
                    case Int: {
                        fieldValue.setRefPropValue(Long.parseLong(dataValue.toString()));
                        break;
                    }
                    case Bool: 
                    case String: 
                    case Decimal: {
                        fieldValue.setTextValue(dataValue.toString());
                        break;
                    }
                }
                DynamicExtractFieldValueSetData fieldValueData = new DynamicExtractFieldValueSetData();
                fieldValue.setGetValueType(ExtractTypeEnum.CONSTANT_VALUE);
                fieldValue.setBranchSeq(0);
                fieldValueData.setBranchId((Long)fieldValue.getId());
                fieldValue.setRuleId(pageId);
                DynamicExtractFieldCfg extractFieldCfg = ExtractFieldUtils.loadDynamicExtractFieldCfg(sourcePage, sourceField);
                fieldValue.setDynExtFieldCfg(extractFieldCfg);
                fieldValueData.setMultiBranch(false);
                fieldValueData.setFieldValueSetList(Collections.singletonList(fieldValue));
                return new PairTuple((Object)fieldValueData, (Object)dynFldDesc);
            }
        }
        return null;
    }

    public static PairTuple<DynamicExtractFieldValueSetData, String> convertToDataOfBillField(Object returnData, Long pageId, String sourcePage, String sourceField) {
        if (null != returnData) {
            String[] returnDataField = (String[])returnData;
            DynamicExtractFieldValueSet fieldValue = new DynamicExtractFieldValueSet();
            long valId = DBServiceHelper.genLongIds((String)"fah_dyn_extfld_val", (int)1)[0];
            fieldValue.setId(valId);
            fieldValue.setTextValue(returnDataField[0]);
            fieldValue.setBranchSeq(0);
            fieldValue.setGetValueType(ExtractTypeEnum.SOURCE_FIELD);
            fieldValue.setRuleId(pageId);
            DynamicExtractFieldCfg extractFieldCfg = ExtractFieldUtils.loadDynamicExtractFieldCfg(sourcePage, sourceField);
            fieldValue.setDynExtFieldCfg(extractFieldCfg);
            DynamicExtractFieldValueSetData fieldValueData = new DynamicExtractFieldValueSetData();
            fieldValueData.setBranchId((Long)fieldValue.getId());
            fieldValueData.setMultiBranch(false);
            fieldValueData.setFieldValueSetList(Collections.singletonList(fieldValue));
            return new PairTuple((Object)fieldValueData, (Object)returnDataField[1]);
        }
        return null;
    }
}

