/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ExchangeRateProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.util.EntityTreeUtil;
import kd.fi.bd.util.QFBuilder;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.ExtractModeEnum;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.constant.enums.event.DataFieldEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.event.FahEventRuleCfgDAO;
import kd.fi.v2.fah.models.event.eventrule.ConstantValue;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldCfg;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldParameter;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetEntry;
import kd.fi.v2.fah.utils.DataModelUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class ExtractFieldUtils {
    public static final String ENTITY_TYPE = "entityType";
    public static final String BASE_PROP_TYPE = "basePropType";
    public static final String DATA_TYPE = "dataType";

    public static String getFormIdBySourcePageAndField(String sourcePage, String sourceField) {
        QFBuilder qb = new QFBuilder("sourcepage", "=", (Object)sourcePage);
        qb.add("number", "=", (Object)sourceField);
        DynamicObject config = QueryServiceHelper.queryOne((String)"fah_dyn_extfld", (String)"enablefunction", (QFilter[])qb.toArray());
        if (config == null) {
            return null;
        }
        String enablefunction = config.getString("enablefunction");
        if (StringUtils.isNotEmpty((String)enablefunction)) {
            String[] enablefunctions;
            for (String s : enablefunctions = enablefunction.split("\\|")) {
                if (!s.equals(ObjectConverterFactory.getString(ExtractModeEnum.FILTER_CONDITION.getCode()))) continue;
                return "fah_dyn_extfld_set";
            }
        }
        return "fah_dyn_extfld_setdetail";
    }

    public static HashMap<String, String> getFieldTypeBySourcePageAndField(String sourcePage, String sourceField) {
        HashMap<String, String> fieldTypeMap = new HashMap<String, String>(3);
        QFBuilder qb = new QFBuilder("sourcepage", "=", (Object)sourcePage);
        qb.add("number", "=", (Object)sourceField);
        DynamicObject config = QueryServiceHelper.queryOne((String)"fah_dyn_extfld", (String)"datatype,baseprop,assistprop", (QFilter[])qb.toArray());
        if (config == null) {
            return fieldTypeMap;
        }
        fieldTypeMap.put("fieldType", config.getString("datatype"));
        fieldTypeMap.put("baseprop", config.getString("baseprop"));
        fieldTypeMap.put("assistprop", String.valueOf(config.getLong("assistprop")));
        return fieldTypeMap;
    }

    public static Map<String, Object> buildTreeParam(String sourcePage, String sourceField, String targetPage, String entryNumber) {
        return ExtractFieldUtils.buildTreeParam(null, null, sourcePage, sourceField, targetPage, entryNumber);
    }

    public static List<ComboItem> getEntityFieldFromSourcePageAndField(String sourcePage, String sourceField, String targetPage, String entryNumber) {
        return ExtractFieldUtils.getEntityFieldFromSourcePageAndField(null, null, sourcePage, sourceField, targetPage, entryNumber);
    }

    public static Map<String, Object> buildTreeParam(String basePropNumber, String dataType, String sourcePage, String sourceField, String targetPage, String entryNumber) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        HashMap<String, String> fieldTypeMap = ExtractFieldUtils.getFieldTypeBySourcePageAndField(sourcePage, sourceField);
        if (fieldTypeMap.isEmpty()) {
            return param;
        }
        param.put(ENTITY_TYPE, targetPage);
        param.put("entryNumber", entryNumber);
        DataFieldEnum dataField = DataFieldEnum.getEnum(Byte.valueOf((String)fieldTypeMap.get("fieldType")));
        if (basePropNumber == null) {
            basePropNumber = dataField == DataFieldEnum.AssistProp ? (String)fieldTypeMap.get("assistprop") : (String)fieldTypeMap.get("baseprop");
        }
        param.put(BASE_PROP_TYPE, basePropNumber);
        if ("fah_evt_gen_rule".equals(sourcePage) && "sub_customvalue".equals(sourceField) && !StringUtils.isEmpty((String)dataType)) {
            param.put(DATA_TYPE, DataFieldEnum.getAsstActTypeDataType(Byte.valueOf(dataType)).getName());
        } else {
            param.put(DATA_TYPE, DataFieldEnum.getDataType(Byte.valueOf((String)fieldTypeMap.get("fieldType"))).getName());
        }
        ExtractFieldUtils.addFilterFields(param, sourcePage, sourceField, targetPage);
        if ("entry_currency".equals(sourceField) || "currency".equals(sourceField)) {
            param.put("maxLevel", 0);
        }
        return param;
    }

    private static void addFilterFields(Map<String, Object> param, String sourcePage, String sourceField, String targetPage) {
        HashSet<String> filterField;
        if ("fah_evt_gen_rule".equals(sourcePage) && "entry_amount".equals(sourceField) || "fah_amountset".equals(sourcePage) && "amount".equals(sourceField)) {
            if (!DataModelUtils.isEventBill(targetPage)) {
                filterField = new HashSet<String>(1);
                filterField.add(AmountProp.class.getName());
                param.put("filterField", filterField);
            }
            param.put("maxLevel", 0);
        }
        if ("fah_amountset".equals(sourcePage) && "exchangerate".equals(sourceField)) {
            if (!DataModelUtils.isEventBill(targetPage)) {
                filterField = new HashSet(2);
                filterField.add(ExchangeRateProp.class.getName());
                filterField.add(DecimalProp.class.getName());
                param.put("filterField", filterField);
            }
            param.put("maxLevel", 0);
        }
        if ("fah_otherfieldset".equals(sourcePage) && "quantity".equals(sourceField)) {
            if (!DataModelUtils.isEventBill(targetPage)) {
                filterField = new HashSet(1);
                filterField.add(QtyProp.class.getName());
                param.put("filterField", filterField);
            }
            param.put("maxLevel", 0);
        }
        if ("fah_otherfieldset".equals(sourcePage) && "measurement".equals(sourceField)) {
            if (!DataModelUtils.isEventBill(targetPage)) {
                filterField = new HashSet(1);
                filterField.add(UnitProp.class.getName());
                param.put("filterField", filterField);
            }
            param.put("maxLevel", 0);
        }
        if ("fah_otherfieldset".equals(sourcePage) && "unitprice".equals(sourceField)) {
            if (!DataModelUtils.isEventBill(targetPage)) {
                filterField = new HashSet(1);
                filterField.add(PriceProp.class.getName());
                param.put("filterField", filterField);
            }
            param.put("maxLevel", 0);
        }
    }

    public static Map<String, Object> buildTreeParamOfAsst(DynamicObject asstact, String sourceBill, String entryNumber) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put(ENTITY_TYPE, sourceBill);
        param.put("entryNumber", entryNumber);
        String valueType = asstact.getString("valuetype");
        Class fieldClassType = null;
        if ("1".equals(valueType)) {
            fieldClassType = BasedataProp.class;
            param.put(BASE_PROP_TYPE, asstact.getString("valuesource.id"));
        } else if ("2".equals(valueType)) {
            param.put(BASE_PROP_TYPE, asstact.getString("assistanttype.id"));
            fieldClassType = AssistantProp.class;
        } else if ("3".equals(valueType)) {
            fieldClassType = String.class;
        }
        param.put(DATA_TYPE, null != fieldClassType ? fieldClassType.getName() : null);
        return param;
    }

    public static List<ComboItem> getEntityFieldFromSourcePageAndField(String basePropNumber, String dataType, String sourcePage, String sourceField, String targetPage, String entryNumber) {
        HashMap<String, String> fieldTypeMap = ExtractFieldUtils.getFieldTypeBySourcePageAndField(sourcePage, sourceField);
        if (fieldTypeMap.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put(ENTITY_TYPE, MetadataServiceHelper.getDataEntityType((String)targetPage));
        param.put("entryNumber", entryNumber);
        DataFieldEnum dataField = DataFieldEnum.getEnum(Byte.valueOf((String)fieldTypeMap.get("fieldType")));
        if (basePropNumber == null) {
            basePropNumber = dataField == DataFieldEnum.AssistProp ? (String)fieldTypeMap.get("assistprop") : (String)fieldTypeMap.get("baseprop");
        }
        param.put(BASE_PROP_TYPE, basePropNumber);
        if ("fah_evt_gen_rule".equals(sourcePage) && "sub_customvalue".equals(sourceField) && !StringUtils.isEmpty((String)dataType)) {
            param.put(DATA_TYPE, DataFieldEnum.getAsstActTypeDataType(Byte.valueOf(dataType)));
        } else {
            param.put(DATA_TYPE, DataFieldEnum.getDataType(Byte.valueOf((String)fieldTypeMap.get("fieldType"))));
        }
        return EntityTreeUtil.getEntityFieldComboItems(param);
    }

    public static DynamicExtractFieldCfg loadDynamicExtractFieldCfg(String sourcePage, String number) {
        String enablefunction;
        DynamicExtractFieldCfg result = new DynamicExtractFieldCfg();
        DynamicObject cfg = FahEventRuleCfgDAO.queryDynExtFieldCfg(sourcePage, number);
        if (cfg == null) {
            return null;
        }
        result.setId(cfg.getLong("id"));
        result.setNumber(cfg.getString("number"));
        result.setSourceField(cfg.getString("sourcefield"));
        result.setName(cfg.getString("name"));
        result.setSourcePage(cfg.getString("sourcepage"));
        result.setOutputDataType(DataValueTypeEnum.getEnum(cfg.getString("datatype")));
        result.setBaseProp(cfg.getString("baseprop.id"));
        result.setAssistProp(cfg.getLong("assistprop.id"));
        DynamicObjectCollection argentry = cfg.getDynamicObjectCollection("argentry");
        if (argentry != null && argentry.size() > 0) {
            ArrayList<DynamicExtractFieldParameter> list = new ArrayList<DynamicExtractFieldParameter>(argentry.size());
            for (DynamicObject entry : argentry) {
                DynamicExtractFieldParameter entryCfg = new DynamicExtractFieldParameter();
                entryCfg.setEntryId(entry.getLong("id"));
                entryCfg.setSeq(entry.getInt("seq"));
                entryCfg.setSourceType(ExtractTypeEnum.getEnumByCode(entry.getString("arg_source")));
                entryCfg.setDataType(DataValueTypeEnum.getEnum(entry.getString("arg_datatype")));
                entryCfg.setSourceField(entry.getString("arg_field"));
                if (ExtractTypeEnum.CONSTANT_VALUE == entryCfg.getSourceType()) {
                    entryCfg.setConstantValue((ConstantValue)SerializationUtils.fromJsonString((String)entry.getString("arg_constant"), ConstantValue.class));
                }
                list.add(entryCfg);
            }
            result.setInputParameters(list);
        }
        if (StringUtils.isNotEmpty((String)(enablefunction = cfg.getString("enablefunction")))) {
            String[] split = enablefunction.split("\\|");
            ArrayList<ExtractModeEnum> list2 = new ArrayList<ExtractModeEnum>(split.length);
            for (String str : split) {
                list2.add(ExtractModeEnum.getEnumByCode(str));
            }
            result.setEnableFunctions(list2);
        }
        return result;
    }

    public static void saveExtractFieldValueSet(List<DynamicExtractFieldValueSetData> fieldValueDataList) {
        if (null == fieldValueDataList || fieldValueDataList.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> fieldValueDynObjList = new ArrayList<DynamicObject>();
        for (DynamicExtractFieldValueSetData fieldValueData : fieldValueDataList) {
            List<DynamicExtractFieldValueSet> fieldValueSetList = fieldValueData.getFieldValueSetList();
            if (null == fieldValueSetList || fieldValueSetList.isEmpty()) continue;
            for (DynamicExtractFieldValueSet fieldValue : fieldValueSetList) {
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"fah_dyn_extfld_val");
                obj.set("id", fieldValue.getId());
                DynamicExtractFieldCfg extFieldCfg = fieldValue.getDynExtFieldCfg();
                if (null != extFieldCfg) {
                    obj.set("dynextfldid", extFieldCfg.getId());
                    DataValueTypeEnum outputDataType = extFieldCfg.getOutputDataType();
                    if (null != outputDataType) {
                        obj.set("outputdatatype", (Object)String.valueOf(outputDataType.getCode()));
                    }
                }
                obj.set("ruleid", (Object)fieldValue.getRuleId());
                obj.set("branchid", (Object)fieldValueData.getBranchId());
                obj.set("branchseq", (Object)fieldValue.getBranchSeq());
                obj.set("groupseq", (Object)fieldValue.getGroupSeq());
                obj.set("mappinggroupid", (Object)fieldValue.getMappingGroupId());
                obj.set("asstactid", (Object)fieldValue.getAsstActId());
                obj.set("filterruledata", (Object)fieldValue.getFilterRule());
                ExtractTypeEnum getValueType = fieldValue.getGetValueType();
                if (null != getValueType) {
                    obj.set("getvaluetype", (Object)String.valueOf(getValueType.getCode()));
                }
                if (ExtractTypeEnum.CONSTANT_VALUE == fieldValue.getGetValueType()) {
                    DataValueTypeEnum dataValueTypeEnum;
                    String constantValue = fieldValue.getConstantValue();
                    obj.set("expressionvalue", (Object)constantValue);
                    if (extFieldCfg != null && (dataValueTypeEnum = extFieldCfg.getOutputDataType()) != null) {
                        switch (dataValueTypeEnum) {
                            case Date: {
                                fieldValue.setDateValue(ObjectConverterFactory.getDate(constantValue));
                                break;
                            }
                            case BaseProp: {
                                ConstantValue fieldData = (ConstantValue)SerializationUtils.fromJsonString((String)constantValue, ConstantValue.class);
                                Object dataValue = fieldData.getValue();
                                fieldValue.setTextValue(fieldData.getBaseProp());
                                fieldValue.setBaseProp(fieldData.getBaseProp());
                                fieldValue.setRefPropValue(Long.parseLong(dataValue.toString()));
                                break;
                            }
                            case AssistProp: {
                                ConstantValue fieldData = (ConstantValue)SerializationUtils.fromJsonString((String)constantValue, ConstantValue.class);
                                Object dataValue = fieldData.getValue();
                                if (fieldData.getAssistProp() != null) {
                                    fieldValue.setTextValue(String.valueOf(fieldData.getAssistProp()));
                                    fieldValue.setAssistProp(fieldData.getAssistProp());
                                }
                                fieldValue.setRefPropValue(Long.parseLong(dataValue.toString()));
                                break;
                            }
                            case Decimal: 
                            case Int: 
                            case String: 
                            case Bool: {
                                fieldValue.setTextValue(constantValue);
                            }
                        }
                    }
                } else {
                    obj.set("expressionvalue", (Object)fieldValue.getExpressionValue());
                }
                obj.set("textvalue", (Object)fieldValue.getTextValue());
                obj.set("baseprop", (Object)fieldValue.getBaseProp());
                obj.set("assistprop", (Object)fieldValue.getAssistProp());
                obj.set("refpropvalue", (Object)fieldValue.getRefPropValue());
                obj.set("datevalue", (Object)fieldValue.getDateValue());
                List<DynamicExtractFieldValueSetEntry> fieldValueSetEntry = fieldValue.getFieldValueSetEntry();
                if (null != fieldValueSetEntry && !fieldValueSetEntry.isEmpty()) {
                    DynamicObjectCollection entryCollection = obj.getDynamicObjectCollection("entryentity");
                    for (DynamicExtractFieldValueSetEntry entry : fieldValueSetEntry) {
                        ExtractTypeEnum mGetValueType;
                        DynamicObject row = entryCollection.addNew();
                        row.set("id", (Object)entry.getEntryId());
                        row.set("seq", (Object)entry.getSeq());
                        DataValueTypeEnum dataType = entry.getParamDataType();
                        if (null != dataType) {
                            row.set("paramdatatype", (Object)dataType.getCode());
                        }
                        if (null != (mGetValueType = entry.getGetValueType())) {
                            row.set("mgetvaluetype", (Object)mGetValueType.getCode());
                        }
                        row.set("mtextvalue", (Object)entry.getTextValue());
                        row.set("mrefpropvalue", (Object)entry.getRefPropValue());
                        row.set("mdatevalue", (Object)entry.getDateValue());
                        row.set("mexpressionvalue", (Object)entry.getExpressionValue());
                        row.set("billtype", (Object)entry.getBillType());
                        row.set("param", (Object)entry.getParam());
                        row.set("mappingrule", (Object)entry.getMappingId());
                    }
                }
                fieldValueDynObjList.add(obj);
            }
        }
        SaveServiceHelper.save((DynamicObject[])fieldValueDynObjList.toArray(new DynamicObject[0]));
    }

    public static DynamicExtractFieldValueSetData loadDynamicExtractFieldValueSetData(Long branchId) {
        if (null == branchId || 0L == branchId) {
            return null;
        }
        Map<Object, DynamicObject> map = FahEventRuleCfgDAO.queryDynExtFieldValueSet(branchId);
        if (null == map || map.isEmpty()) {
            return null;
        }
        DynamicExtractFieldValueSetData valueSetData = new DynamicExtractFieldValueSetData();
        ArrayList<DynamicExtractFieldValueSet> fieldValueList = new ArrayList<DynamicExtractFieldValueSet>(map.size());
        Collection<DynamicObject> objects = map.values();
        for (DynamicObject fieldValueObj : objects) {
            DynamicExtractFieldValueSet fieldValue = new DynamicExtractFieldValueSet();
            DynamicExtractFieldCfg extractFieldCfg = ExtractFieldUtils.loadDynamicExtractFieldCfg(fieldValueObj.getString("dynextfldid.sourcepage"), fieldValueObj.getString("dynextfldid.number"));
            fieldValue.setDynExtFieldCfg(extractFieldCfg);
            fieldValue.setId(fieldValueObj.getLong("id"));
            fieldValue.setRuleId(fieldValueObj.getLong("ruleid"));
            fieldValue.setBranchSeq(fieldValueObj.getInt("branchseq"));
            fieldValue.setGroupSeq(fieldValueObj.getInt("groupseq"));
            fieldValue.setMappingGroupId(fieldValueObj.getLong("mappinggroupid.id"));
            long asstactId = fieldValueObj.getLong("asstactid.id");
            if (0L != asstactId) {
                fieldValue.setAsstActId(asstactId);
                fieldValue.setAsstActName(fieldValueObj.getString("asstactid.flexfield"));
                valueSetData.setAsstAct(true);
            }
            String getValueType = fieldValueObj.getString("getvaluetype");
            ExtractTypeEnum getValueTypeEnum = ExtractTypeEnum.getEnumByCode(getValueType);
            fieldValue.setGetValueType(getValueTypeEnum);
            if (ExtractTypeEnum.CONSTANT_VALUE == getValueTypeEnum) {
                fieldValue.setConstantValue(fieldValueObj.getString("expressionvalue"));
            } else {
                fieldValue.setExpressionValue(fieldValueObj.getString("expressionvalue"));
            }
            fieldValue.setFilterRule(fieldValueObj.getString("filterruledata"));
            fieldValue.setTextValue(fieldValueObj.getString("textvalue"));
            fieldValue.setBaseProp(fieldValueObj.getString("baseprop"));
            fieldValue.setAssistProp(fieldValueObj.getLong("assistprop"));
            fieldValue.setRefPropValue(fieldValueObj.getLong("refpropvalue"));
            fieldValue.setDateValue(fieldValueObj.getDate("datevalue"));
            DynamicObjectCollection entryEntity = fieldValueObj.getDynamicObjectCollection("entryentity");
            if (null != entryEntity && !entryEntity.isEmpty()) {
                ArrayList<DynamicExtractFieldValueSetEntry> entryList = new ArrayList<DynamicExtractFieldValueSetEntry>(entryEntity.size());
                for (DynamicObject entry : entryEntity) {
                    String mGetValueType;
                    DynamicExtractFieldValueSetEntry entryCfg = new DynamicExtractFieldValueSetEntry();
                    entryCfg.setId((Long)fieldValue.getId());
                    entryCfg.setEntryId(entry.getLong("id"));
                    entryCfg.setSeq(entry.getInt("seq"));
                    entryCfg.setMappingId(entry.getLong("mappingrule.id"));
                    String paramDataType = entry.getString("paramdatatype");
                    if (!StringUtils.isBlank((String)paramDataType)) {
                        entryCfg.setParamDataType(DataValueTypeEnum.getEnum(paramDataType));
                    }
                    if (!StringUtils.isBlank((String)(mGetValueType = entry.getString("mgetvaluetype")))) {
                        entryCfg.setGetValueType(ExtractTypeEnum.getEnumByCode(mGetValueType));
                    }
                    entryCfg.setTextValue(entry.getString("mtextvalue"));
                    entryCfg.setRefPropValue(entry.getLong("mrefpropvalue"));
                    entryCfg.setDateValue(entry.getDate("mdatevalue"));
                    entryCfg.setExpressionValue(entry.getString("mexpressionvalue"));
                    entryCfg.setBillType(entry.getString("billtype"));
                    entryCfg.setParam(entry.getString("param"));
                    entryList.add(entryCfg);
                }
                fieldValue.setFieldValueSetEntry(entryList);
            }
            fieldValueList.add(fieldValue);
        }
        valueSetData.setBranchId(branchId);
        valueSetData.setMultiBranch(objects.size() > 1);
        valueSetData.setFieldValueSetList(fieldValueList);
        return valueSetData;
    }
}

