/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.Collections;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldCfg;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.utils.ExtractFieldUtils;

public class FahAcctRuleUtils {
    public static String getFieldLongName(String number, MainEntityType mainEntityType) {
        if (mainEntityType == null) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        if (!number.contains(".")) {
            IDataEntityProperty prop = mainEntityType.findProperty(number);
            if (prop != null) {
                IDataEntityType entry = prop.getParent();
                if (entry instanceof SubEntryType) {
                    name.append(entry.getParent().getDisplayName().getLocaleValue()).append(".").append(entry.getDisplayName().getLocaleValue()).append(".").append(prop.getDisplayName().getLocaleValue());
                } else if (entry instanceof EntryType) {
                    name.append(entry.getDisplayName().getLocaleValue()).append(".").append(prop.getDisplayName().getLocaleValue());
                } else {
                    name.append(prop.getDisplayName().getLocaleValue());
                }
            }
        } else {
            String[] split = number.split("\\.");
            IDataEntityProperty firstProp = mainEntityType.findProperty(split[0]);
            if (firstProp == null) {
                return null;
            }
            IDataEntityType entry = firstProp.getParent();
            if (entry instanceof SubEntryType) {
                name.append(entry.getParent().getDisplayName().getLocaleValue()).append(".").append(entry.getDisplayName().getLocaleValue()).append(".");
            } else if (entry instanceof EntryType) {
                name.append(entry.getDisplayName().getLocaleValue()).append(".");
            }
            for (String s : split) {
                IDataEntityProperty property = mainEntityType.findProperty(s);
                if (property == null) continue;
                if (property instanceof BasedataProp) {
                    mainEntityType = EntityMetadataCache.getDataEntityType((String)((BasedataProp)property).getBaseEntityId());
                }
                name.append(property.getDisplayName().getLocaleValue()).append(".");
            }
            name.deleteCharAt(name.lastIndexOf("."));
        }
        return name.toString();
    }

    public static Object[] getFieldProp(String number, MainEntityType mainEntityType) {
        Object[] returnData = new Object[2];
        if (mainEntityType == null) {
            return null;
        }
        if (!number.contains(".")) {
            IDataEntityProperty prop = mainEntityType.findProperty(number);
            if (prop != null) {
                returnData[0] = Boolean.TRUE;
                returnData[1] = prop;
                return returnData;
            }
            return null;
        }
        IDataEntityProperty property = null;
        returnData[0] = Boolean.TRUE;
        for (String s : number.split("\\.")) {
            property = mainEntityType.findProperty(s);
            if (property == null) {
                return null;
            }
            if (!(property instanceof BasedataProp)) continue;
            returnData[0] = Boolean.FALSE;
            mainEntityType = EntityMetadataCache.getDataEntityType((String)((BasedataProp)property).getBaseEntityId());
        }
        returnData[1] = property;
        return returnData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicExtractFieldValueSetData getFieldValueCfg(MainEntityType mainEntityType, String propNumber, Long ruleId, ExtractTypeEnum extractTypeEnum, Object constantValue, String sourcePage, String sourceField) {
        DynamicExtractFieldValueSet fieldValue = new DynamicExtractFieldValueSet();
        fieldValue.setBranchSeq(0);
        long valueId = DBServiceHelper.genLongIds((String)"t_fah_dynextfld_valset", (int)1)[0];
        fieldValue.setId(valueId);
        fieldValue.setRuleId(ruleId);
        fieldValue.setGetValueType(extractTypeEnum);
        DynamicExtractFieldCfg extractFieldCfg = ExtractFieldUtils.loadDynamicExtractFieldCfg(sourcePage, sourceField);
        fieldValue.setDynExtFieldCfg(extractFieldCfg);
        if (extractTypeEnum == ExtractTypeEnum.SOURCE_FIELD) {
            IDataEntityProperty prop = mainEntityType.findProperty(propNumber);
            if (prop == null) return null;
            StringBuilder longName = new StringBuilder();
            if (prop.getParent() instanceof EntryType) {
                longName.append(prop.getParent().getDisplayName().getLocaleValue()).append(".");
            }
            fieldValue.setTextValue(prop.getName());
            longName.append(prop.getDisplayName().getLocaleValue());
            fieldValue.setShowName(longName.toString());
        } else if (extractTypeEnum == ExtractTypeEnum.CONSTANT_VALUE) {
            fieldValue.setConstantValue(String.valueOf(constantValue));
        }
        DynamicExtractFieldValueSetData fieldValueData = new DynamicExtractFieldValueSetData();
        fieldValueData.setBranchId((Long)fieldValue.getId());
        fieldValueData.setMultiBranch(false);
        fieldValueData.setFieldValueSetList(Collections.singletonList(fieldValue));
        return fieldValueData;
    }
}

