/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.FahEntityPageConstant;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.meta.enums.FieldPathTypeEnum;
import kd.fi.v2.fah.utils.StringUtils;

public class FahEntityMetaHelper {
    public static String getEntityPK(String mainEntityNum) {
        if (StringUtils.isEmpty((String)mainEntityNum)) {
            return null;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)mainEntityNum);
        ISimpleProperty pkProperty = dataEntityType.getPrimaryKey();
        return pkProperty != null ? pkProperty.getName() : null;
    }

    public static String getOperationName(String formId, String opKey) {
        try {
            Map opMap = EntityMetadataCache.getDataEntityOperate((String)formId, (String)opKey);
            Map map = (Map)opMap.get("name");
            return (String)map.get(Lang.get().getLocale().toString());
        }
        catch (Exception var5) {
            return opKey;
        }
    }

    public static String getParentPageNumber(String formNumber) {
        if (StringUtils.isEmpty((String)formNumber)) {
            return "";
        }
        HashMap ppgCache = (HashMap)ThreadCache.get((Object)"FahEntityMetaHelper.getParentPageNumber", HashMap::new);
        String parentNumber = (String)ppgCache.get(formNumber);
        if (parentNumber == null) {
            DynamicObject form = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"parentid.number", (QFilter[])new QFilter("number", "=", (Object)formNumber).toArray());
            parentNumber = form != null ? form.getString("parentid.number") : "";
            ppgCache.put(formNumber, parentNumber);
        }
        return parentNumber;
    }

    public static boolean isOrgTplBaseData(String formNumber) {
        if (StringUtils.isEmpty((String)formNumber)) {
            return false;
        }
        Map cache = (Map)ThreadCache.get((Object)"FahEntityMetaHelper.isOrgTplBaseData", HashMap::new);
        Boolean isOrg = (Boolean)cache.get(formNumber);
        if (isOrg == null) {
            String parentPageNumber;
            String[] extOrgTpl;
            String extTpls = SysParamConfig.get("fahBasedataWithOrgTpls");
            if (StringUtils.isNotEmpty((String)extTpls) && (extOrgTpl = extTpls.split(",")).length != 0) {
                FahEntityPageConstant.ORG_TPLS.addAll(Arrays.asList(extOrgTpl));
            }
            if (!(isOrg = Boolean.valueOf(FahEntityPageConstant.ORG_TPLS.contains(parentPageNumber = FahEntityMetaHelper.getParentPageNumber(formNumber)))).booleanValue()) {
                isOrg = FahEntityMetaHelper.isOrgTplBaseData(parentPageNumber);
            }
            cache.put(formNumber, isOrg);
        }
        return isOrg;
    }

    public static QFilter buildPKFilter(String mainEntityNum, Collection<?> pkIds) {
        String pkPropName = FahEntityMetaHelper.getEntityPK(mainEntityNum);
        if (pkIds.isEmpty() || StringUtils.isEmpty((String)pkPropName)) {
            return null;
        }
        return new QFilter(pkPropName, "in", pkIds);
    }

    public static List<QFilter> buildEntryPKQueryFilter(String mainEntityNum, Collection<?> pkIds, String entryTypeNum, Collection<?> entryPkIds) {
        if (StringUtils.isEmpty((String)mainEntityNum)) {
            throw new IllegalArgumentException("Main Entity Type cannot be null!");
        }
        if (StringUtils.isNotEmpty((String)entryTypeNum) && entryPkIds.isEmpty() || StringUtils.isEmpty((String)entryTypeNum) && !entryPkIds.isEmpty()) {
            throw new IllegalArgumentException(String.format("Entry Entity Type Filter value is not valid! [mainEntityNum=%s, pkIds=%s, entryTypeNum=%s, entryPkIds=%s]", mainEntityNum, pkIds, entryTypeNum, entryPkIds));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        QFilter mainPkFilter = FahEntityMetaHelper.buildPKFilter(mainEntityNum, pkIds);
        if (mainPkFilter != null) {
            qFilters.add(mainPkFilter);
        }
        if (!entryPkIds.isEmpty()) {
            LinkedList<IDataEntityType> entryParents = FahEntityMetaHelper.getAllParentEntity(mainEntityNum, entryTypeNum, false);
            if (entryParents.isEmpty()) {
                throw new IllegalArgumentException(String.format("Cannot found Entry Entity Type! [mainEntityNum=%s, entryTypeNum=%s]", mainEntityNum, entryTypeNum));
            }
            StringBuilder prefix = new StringBuilder();
            boolean first = true;
            for (IDataEntityType p : entryParents) {
                if (first) {
                    first = false;
                } else {
                    prefix.append('.');
                }
                prefix.append(p.getName());
            }
            prefix.append(entryParents.getLast().getPrimaryKey().getName());
            qFilters.add(new QFilter(prefix.toString(), "in", entryPkIds));
        }
        return qFilters;
    }

    public static void travelAllEntryEntity(String mainEntityNum, BiFunction<List<IDataEntityType>, IDataEntityType, Boolean> consumer) {
        FahEntityMetaHelper.travelAllEntryEntity(EntityMetadataCache.getDataEntityType((String)mainEntityNum).getProperties(), new LinkedList<IDataEntityType>(), consumer);
    }

    public static void travelAllEntryEntity(DataEntityPropertyCollection srcProps, List<IDataEntityType> parentList, BiFunction<List<IDataEntityType>, IDataEntityType, Boolean> consumer) {
        if (srcProps != null && !srcProps.isEmpty()) {
            LinkedList<IDataEntityType> currentLayerParent = new LinkedList<IDataEntityType>(parentList);
            for (IDataEntityProperty prop : srcProps) {
                if (!(prop instanceof EntryProp)) continue;
                DynamicObjectType entityTypeBuf = ((EntryProp)prop).getDynamicCollectionItemPropertyType();
                if (!consumer.apply(parentList, (IDataEntityType)entityTypeBuf).booleanValue()) break;
                currentLayerParent.add((IDataEntityType)entityTypeBuf);
                FahEntityMetaHelper.travelAllEntryEntity(entityTypeBuf.getProperties(), currentLayerParent, consumer);
                currentLayerParent.removeLast();
            }
        }
    }

    public static LinkedList<IDataEntityType> getAllParentEntity(MainEntityType mainEntity, String leafEntryTypeNum, boolean includeMainEntity) {
        LinkedList<IDataEntityType> result = new LinkedList<IDataEntityType>();
        FahEntityMetaHelper.travelAllParentEntity(mainEntity, leafEntryTypeNum, result::add);
        if (includeMainEntity) {
            result.addFirst((IDataEntityType)mainEntity);
        }
        return result;
    }

    public static void travelAllParentEntity(MainEntityType mainEntity, String leafEntryTypeNum, Consumer<IDataEntityType> consumer) {
        FahEntityMetaHelper.travelAllEntryEntity(mainEntity.getProperties(), new LinkedList<IDataEntityType>(), (parents, entry) -> {
            if (leafEntryTypeNum.equalsIgnoreCase(entry.getName())) {
                if (parents != null && !parents.isEmpty()) {
                    parents.forEach(consumer);
                }
                consumer.accept((IDataEntityType)entry);
                return false;
            }
            return true;
        });
    }

    public static LinkedList<IDataEntityType> getAllParentEntity(String mainEntityNum, String leafEntryTypeNum, boolean includeMainEntity) {
        EntityType entryEntity = (EntityType)EntityMetadataCache.getDataEntityType((String)mainEntityNum).getAllEntities().get(leafEntryTypeNum);
        LinkedList<IDataEntityType> result = new LinkedList<IDataEntityType>();
        if (entryEntity != null) {
            IDataEntityType parent;
            result.add((IDataEntityType)entryEntity);
            while ((parent = entryEntity.getParent()) != null) {
                if (mainEntityNum.equals(parent.getName()) && !includeMainEntity) continue;
                result.addFirst(parent);
            }
        }
        return result;
    }

    public static IDataEntityType findEntryEntity(MainEntityType mainEntity, String lookupEntryNum) {
        IDataEntityType[] result = new IDataEntityType[1];
        FahEntityMetaHelper.travelAllEntryEntity(mainEntity.getProperties(), new LinkedList<IDataEntityType>(), (parents, entry) -> {
            if (lookupEntryNum.equalsIgnoreCase(entry.getName())) {
                result[0] = entry;
                return false;
            }
            return true;
        });
        return result[0];
    }

    public static Long loadTableDefineId(String entityTypeNum) {
        TableDefine tableDefine = EntityMetadataCache.loadMainTableDefine((String)entityTypeNum);
        return tableDefine == null ? null : tableDefine.getTableId();
    }

    public static String getMainEntityNumByTableId(Long tableId) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)tableId);
        return tableDefine == null ? null : tableDefine.getEntityNumber();
    }

    public static String getEntityKeyByTableId(Long tableId) {
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)tableId);
        return tableDefine == null ? null : tableDefine.getEntityKey();
    }

    public static String[] getEntitySelectFields(String mainEntityType, String entryType, String ... fields) {
        MainEntityType fieldOwnerParent;
        if (StringUtils.isEmpty((String)mainEntityType)) {
            return new String[0];
        }
        LinkedHashSet<String> entryResult = new LinkedHashSet<String>(8);
        LinkedHashSet<String> fieldResult = new LinkedHashSet<String>(8);
        MainEntityType parentMainEntity = EntityMetadataCache.getDataEntityType((String)mainEntityType);
        if (parentMainEntity == null) {
            throw new IllegalArgumentException("Invalid Main Entity:" + mainEntityType);
        }
        String mainEntityName = parentMainEntity.getName();
        entryResult.add(mainEntityName + "." + parentMainEntity.getPrimaryKey().getName());
        String prefix = mainEntityName;
        if (StringUtils.isNotEmpty((String)entryType)) {
            LinkedList<IDataEntityType> parents = FahEntityMetaHelper.getAllParentEntity(mainEntityType, entryType, false);
            if (parents.isEmpty()) {
                throw new IllegalArgumentException(String.format("Cannot found Entry:%s on MainEntity:%s", entryType, mainEntityName));
            }
            for (IDataEntityType parent : parents) {
                prefix = prefix + "_en";
                entryResult.add(prefix + "." + parent.getPrimaryKey().getName());
            }
            fieldOwnerParent = parents.getLast();
        } else {
            fieldOwnerParent = parentMainEntity;
        }
        if (fields != null && fields.length > 0) {
            DataEntityPropertyCollection props = fieldOwnerParent.getProperties();
            for (String field : fields) {
                IDataEntityProperty propBuf = (IDataEntityProperty)props.get((Object)field);
                if (propBuf == null) {
                    throw new IllegalArgumentException(String.format("Cannot found Field:%s on MainEntity:%s, ParentEntry:%s", field, mainEntityName, fieldOwnerParent.getName()));
                }
                fieldResult.add(prefix + "." + propBuf.getName());
            }
        }
        entryResult.addAll(fieldResult);
        return entryResult.toArray(new String[0]);
    }

    public static Map<Long, String> buildLookupTargetTableIndex(String rootEntityNum, List<String> lookupTargetTables) {
        if (lookupTargetTables == null || lookupTargetTables.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> result = new HashMap<Long, String>(lookupTargetTables.size());
        for (String tab : lookupTargetTables) {
            TableDefine tableDefine;
            if (StringUtils.isEmpty((String)tab) || (tableDefine = EntityMetadataCache.loadTableDefine((String)rootEntityNum, (String)tab)) == null) continue;
            result.put(tableDefine.getTableId(), tab);
        }
        return result;
    }

    public static Map<Long, String> getAllParentEntityTableIndex(String mainEntityNum, String leafEntryTypeNum) {
        if (StringUtils.isEmpty((String)mainEntityNum) || StringUtils.isEmpty((String)leafEntryTypeNum)) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> resultMap = new HashMap<Long, String>(3);
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)mainEntityNum, (String)leafEntryTypeNum);
        if (tableDefine != null) {
            resultMap.put(tableDefine.getTableId(), leafEntryTypeNum);
        }
        FahEntityMetaHelper.findEntityFieldParents((IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)mainEntityNum).getProperty(leafEntryTypeNum), (idx, parent) -> {
            TableDefine t = EntityMetadataCache.loadTableDefine((String)mainEntityNum, (String)parent.getName());
            if (t != null) {
                resultMap.put(t.getTableId(), parent.getName());
            }
            return true;
        });
        return resultMap;
    }

    public static boolean findEntityFieldParents(IDataEntityProperty fieldProp, BiFunction<Integer, IDataEntityType, Boolean> parentProcessFunc) {
        if (fieldProp == null) {
            return false;
        }
        int parentCnt = 1;
        for (IDataEntityType parent = fieldProp.getParent(); parent != null; parent = parent.getParent()) {
            if (parentProcessFunc.apply(parentCnt++, parent).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static List<IDataEntityType> getEntityFieldParents(IDataEntityProperty fieldProp) {
        LinkedList<IDataEntityType> parentList = new LinkedList<IDataEntityType>();
        FahEntityMetaHelper.findEntityFieldParents(fieldProp, (i, p) -> {
            parentList.addFirst((IDataEntityType)p);
            return true;
        });
        return parentList;
    }

    public static int __findMatchFieldsByType(EntityType rootEntityType, EntityFieldFilter fieldPropFilter, int currentLevel, boolean skipEntryProp, BiConsumer<Integer, IDataEntityProperty> fieldProcessFunc) {
        boolean skipLookupChild = currentLevel > fieldPropFilter.getMaxLevel() || skipEntryProp;
        boolean skipFilterClassType = fieldPropFilter == null || fieldPropFilter.isSkipFilter();
        int totalMatchCnt = 0;
        for (IDataEntityProperty fieldProp : rootEntityType.getProperties()) {
            EntityType childRootEntityType;
            if (skipFilterClassType) {
                fieldProcessFunc.accept(currentLevel, fieldProp);
                ++totalMatchCnt;
            } else if (fieldPropFilter.apply(fieldProp).booleanValue()) {
                fieldProcessFunc.accept(currentLevel, fieldProp);
                if (++totalMatchCnt < fieldPropFilter.getMaxMatchCnt()) continue;
                break;
            }
            if (skipLookupChild) continue;
            if (fieldProp instanceof BasedataProp) {
                String propNameBuf = ((BasedataProp)fieldProp).getBaseEntityId();
                if (propNameBuf == null) continue;
                childRootEntityType = EntityMetadataCache.getDataEntityType((String)propNameBuf);
            } else {
                if (!(fieldProp instanceof EntryProp)) continue;
                childRootEntityType = rootEntityType;
            }
            totalMatchCnt += FahEntityMetaHelper.__findMatchFieldsByType(childRootEntityType, fieldPropFilter, currentLevel + 1, fieldPropFilter.isNeedRecursiveEntry(fieldProp), fieldProcessFunc);
        }
        return totalMatchCnt;
    }

    public static EntityFieldFilter createEntityFieldTypeFilter(int maxLevel, Collection<Class> requiredClassTypes) {
        return new EntityFieldFilter(maxLevel, requiredClassTypes, p -> p.getClass());
    }

    public static EntityFieldFilter createEntityFieldTypeFilter(int maxLevel, Class requiredClassType) {
        return new EntityFieldFilter(maxLevel, Collections.singleton(requiredClassType), p -> p.getClass());
    }

    public static EntityFieldFilter createEntityFieldPropertyTypeFilter(int maxLevel, Collection<Class> requiredClassTypes) {
        return new EntityFieldFilter(maxLevel, requiredClassTypes, p -> p.getPropertyType());
    }

    public static EntityFieldFilter createEntityFieldPropertyTypeFilter(int maxLevel, Class requiredClassType) {
        return new EntityFieldFilter(maxLevel, Collections.singleton(requiredClassType), p -> p.getPropertyType());
    }

    public static EntityFieldFilter createEntityLevelFilter(int maxLevel) {
        return new EntityFieldFilter(maxLevel, null, p -> p.getClass());
    }

    public static int findMatchFieldsByType(EntityType rootEntityType, EntityFieldFilter fieldFilter, BiConsumer<Integer, IDataEntityProperty> fieldProcessFunc) {
        return FahEntityMetaHelper.__findMatchFieldsByType(rootEntityType, fieldFilter, 0, false, fieldProcessFunc);
    }

    public static int findMatchFieldsByType(String mainEntityType, EntityFieldFilter fieldFilter, BiConsumer<Integer, IDataEntityProperty> fieldProcessFunc) {
        return FahEntityMetaHelper.__findMatchFieldsByType((EntityType)EntityMetadataCache.getDataEntityType((String)mainEntityType), fieldFilter, 0, false, fieldProcessFunc);
    }

    public static int findMatchFieldsByType(EntityType rootEntityType, Class requiredClassType, BiConsumer<Integer, IDataEntityProperty> fieldProcessFunc) {
        return FahEntityMetaHelper.__findMatchFieldsByType(rootEntityType, FahEntityMetaHelper.createEntityFieldTypeFilter(Integer.MAX_VALUE, Collections.singleton(requiredClassType)), 0, false, fieldProcessFunc);
    }

    public static int findMatchFieldsByType(String rootEntityType, Class requiredClassType, BiConsumer<Integer, IDataEntityProperty> fieldProcessFunc) {
        return FahEntityMetaHelper.__findMatchFieldsByType((EntityType)EntityMetadataCache.getDataEntityType((String)rootEntityType), FahEntityMetaHelper.createEntityFieldTypeFilter(Integer.MAX_VALUE, Collections.singleton(requiredClassType)), 0, false, fieldProcessFunc);
    }

    public static List<String> __getMatchFieldFullPathByDataType(EntityType rootEntityType, EntityFieldFilter fieldFilter, BiFunction<Boolean, IMetadata, String> parentFieldProcessFunc) {
        LinkedList matchFields = new LinkedList();
        int totalMatchCnt = FahEntityMetaHelper.findMatchFieldsByType(rootEntityType, fieldFilter, (Integer level, IDataEntityProperty field) -> matchFields.add(field));
        if (totalMatchCnt <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> fieldNameList = new ArrayList<String>(totalMatchCnt);
        for (IDataEntityProperty field2 : matchFields) {
            String nameBuf = parentFieldProcessFunc.apply(false, (IMetadata)field2);
            if (nameBuf == null) continue;
            StringBuilder buf = new StringBuilder(nameBuf);
            FahEntityMetaHelper.findEntityFieldParents(field2, (idx, parent) -> {
                buf.insert(0, '.').insert(0, (String)parentFieldProcessFunc.apply(true, (IMetadata)parent));
                return true;
            });
            fieldNameList.add(buf.toString());
        }
        return fieldNameList;
    }

    public static List<String> getMatchFieldFullPathByDataType(EntityType rootEntityType, EntityFieldFilter fieldFilter) {
        return FahEntityMetaHelper.__getMatchFieldFullPathByDataType(rootEntityType, fieldFilter, (isEntity, parent) -> parent == null || parent.getDisplayName() == null ? null : parent.getDisplayName().getLocaleValue());
    }

    public static IDataEntityProperty __findFieldByFullPath(EntityType mainEntityType, int startIndex, String[] fieldPath) {
        IDataEntityProperty fieldProp = mainEntityType.findProperty(fieldPath[startIndex]);
        if (startIndex == fieldPath.length - 1) {
            return fieldProp;
        }
        if (fieldProp instanceof BasedataProp) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)((BasedataProp)fieldProp).getBaseEntityId());
            return FahEntityMetaHelper.__findFieldByFullPath(mainEntityType, startIndex + 1, fieldPath);
        }
        if (fieldProp instanceof EntryProp) {
            return FahEntityMetaHelper.__findFieldByFullPath(mainEntityType, startIndex + 1, fieldPath);
        }
        return null;
    }

    public static IDataEntityProperty findFieldByFullPath(EntityType mainEntityType, String lookupFieldNumber) {
        return FahEntityMetaHelper.__findFieldByFullPath(mainEntityType, 0, StringUtils.fastSplitEX(lookupFieldNumber, '.'));
    }

    public static void findField(EntityType mainEntityType, String lookupFieldNumber, Consumer<IMetadata> fieldProcessFunc) {
        FahEntityMetaHelper.__findFieldByFullPath(mainEntityType, 0, StringUtils.fastSplitEX(lookupFieldNumber, '.'), fieldProcessFunc);
    }

    public static void __findFieldByFullPath(EntityType mainEntityType, int startIndex, String[] fieldPath, Consumer<IMetadata> fieldProcessFunc) {
        IDataEntityProperty fieldProp = mainEntityType.findProperty(fieldPath[startIndex]);
        fieldProcessFunc.accept((IMetadata)fieldProp);
        if (startIndex == fieldPath.length - 1) {
            return;
        }
        if (fieldProp instanceof BasedataProp) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)((BasedataProp)fieldProp).getBaseEntityId());
            FahEntityMetaHelper.__findFieldByFullPath(mainEntityType, startIndex + 1, fieldPath, fieldProcessFunc);
        } else if (fieldProp instanceof EntryProp) {
            FahEntityMetaHelper.__findFieldByFullPath(mainEntityType, startIndex + 1, fieldPath, fieldProcessFunc);
        }
    }

    public static int findFieldByFullPath(MainEntityType mainEntityType, Collection<String> fieldNames, BiFunction<Integer, IDataEntityProperty, Boolean> fieldProcessFunc) {
        String fieldName;
        IDataEntityProperty field;
        if (fieldNames == null || fieldNames.isEmpty()) {
            return 0;
        }
        int totalMatchCnt = 0;
        Iterator<String> iterator = fieldNames.iterator();
        while (iterator.hasNext() && ((field = FahEntityMetaHelper.findFieldByFullPath((EntityType)mainEntityType, fieldName = iterator.next())) == null || fieldProcessFunc.apply(++totalMatchCnt, field).booleanValue())) {
        }
        return totalMatchCnt;
    }

    public static List<String> getFieldByFullPath(MainEntityType mainEntityType, Collection<String> fieldNames, BiFunction<Boolean, IMetadata, String> parentFieldProcessFunc) {
        if (mainEntityType == null || fieldNames == null || fieldNames.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList matchFields = new LinkedList();
        int totalMatchCnt = FahEntityMetaHelper.findFieldByFullPath(mainEntityType, fieldNames, (idx, field) -> {
            matchFields.add(field);
            return true;
        });
        if (totalMatchCnt <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> fieldNameList = new ArrayList<String>(totalMatchCnt);
        for (IDataEntityProperty field2 : matchFields) {
            StringBuilder buf = new StringBuilder(parentFieldProcessFunc.apply(false, (IMetadata)field2));
            FahEntityMetaHelper.findEntityFieldParents(field2, (idx, parent) -> {
                buf.insert(0, '.').insert(0, (String)parentFieldProcessFunc.apply(true, (IMetadata)parent));
                return true;
            });
            fieldNameList.add(buf.toString());
        }
        return fieldNameList;
    }

    public static int processMatchFields(MainEntityType mainEntityType, Collection<String> fieldNames, boolean useShortFieldNumber, BiFunction<Integer, IMetadata, Boolean> fieldProcessFunc) {
        if (fieldNames == null || fieldNames.isEmpty()) {
            return 0;
        }
        int totalMatchCnt = 0;
        for (String fieldName : fieldNames) {
            if (!FahEntityMetaHelper.processMatchFieldEx((EntityType)mainEntityType, fieldName, useShortFieldNumber, fieldProcessFunc)) continue;
            ++totalMatchCnt;
        }
        return totalMatchCnt;
    }

    public static boolean processMatchFieldEx(EntityType mainEntityType, String lookupFieldNumber, BiFunction<Integer, IMetadata, Boolean> fieldProcessFunc) {
        return FahEntityMetaHelper.processMatchFieldEx(mainEntityType, lookupFieldNumber, true, fieldProcessFunc);
    }

    public static boolean processMatchFieldEx(EntityType mainEntityType, String lookupFieldNumber, boolean useShortFieldNumber, BiFunction<Integer, IMetadata, Boolean> fieldProcessFunc) {
        LinkedList<String> fieldPath = StringUtils.fastSplit(lookupFieldNumber, '.');
        int fieldIndex = 0;
        IDataEntityProperty fieldProp = mainEntityType.findProperty(fieldPath.getFirst());
        if (useShortFieldNumber) {
            fieldIndex = FahEntityMetaHelper.processFieldPropParents(fieldProp, fieldProcessFunc);
        }
        if (fieldPath.size() == 1) {
            fieldProcessFunc.apply(fieldIndex, (IMetadata)fieldProp);
            return true;
        }
        return FahEntityMetaHelper.__processMatchFieldEx(mainEntityType, fieldIndex, fieldPath.toArray(new String[0]), fieldProcessFunc);
    }

    public static int processFieldPropParents(IDataEntityProperty lookupFieldProp, BiFunction<Integer, IMetadata, Boolean> fieldProcessFunc) {
        LinkedList<IDataEntityType> parents = new LinkedList<IDataEntityType>();
        int fieldIndex = 0;
        for (IDataEntityType lookupField = lookupFieldProp.getParent(); lookupField != null; lookupField = lookupField.getParent()) {
            parents.addFirst(lookupField);
        }
        if (!parents.isEmpty()) {
            for (IDataEntityType en : parents) {
                if (fieldProcessFunc.apply(fieldIndex++, (IMetadata)en).booleanValue()) continue;
                return -1;
            }
        }
        return fieldIndex;
    }

    protected static boolean __processMatchFieldEx(EntityType mainEntityType, int startIndex, String[] fieldPath, BiFunction<Integer, IMetadata, Boolean> fieldProcessFunc) {
        IDataEntityProperty fieldProp = mainEntityType.findProperty(fieldPath[startIndex]);
        if (!fieldProcessFunc.apply(startIndex, (IMetadata)fieldProp).booleanValue()) {
            return false;
        }
        if (startIndex == fieldPath.length - 1) {
            return true;
        }
        if (fieldProp instanceof BasedataProp) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)((BasedataProp)fieldProp).getBaseEntityId());
            return FahEntityMetaHelper.__processMatchFieldEx(mainEntityType, startIndex + 1, fieldPath, fieldProcessFunc);
        }
        if (fieldProp instanceof EntryProp) {
            return FahEntityMetaHelper.__processMatchFieldEx((EntityType)fieldProp.getParent(), startIndex + 1, fieldPath, fieldProcessFunc);
        }
        throw new IllegalArgumentException(String.format("Invalid FieldProp Type:%s, FieldIndex:%d, Field Path:%s", fieldProp.getPropertyType(), startIndex, Arrays.toString(fieldPath)));
    }

    public static String getFieldPathPosInfos(EntityType mainEntityType, String lookupFieldNumber, List<PairTuple<FieldPathTypeEnum, int[]>> outputList) {
        if (StringUtils.isEmpty((String)lookupFieldNumber)) {
            return null;
        }
        String[] fieldPath = StringUtils.fastSplitEX(lookupFieldNumber, '.');
        int[] startPos = new int[]{0};
        int pathSegmentIdx = 0;
        StringBuilder fieldFullPath = new StringBuilder();
        String pathSegmentBuf = fieldPath[pathSegmentIdx];
        if (mainEntityType.getName().equals(pathSegmentBuf)) {
            startPos[0] = pathSegmentBuf.length();
            outputList.add((PairTuple<FieldPathTypeEnum, int[]>)new PairTuple((Object)FieldPathTypeEnum.Root_Entity_Type, (Object)new int[]{0, startPos[0]}));
            ++pathSegmentIdx;
            if (fieldPath.length == 1) {
                return pathSegmentBuf;
            }
        } else {
            IDataEntityProperty fieldProp = mainEntityType.findProperty(pathSegmentBuf);
            if (fieldProp instanceof EntityType) {
                FahEntityMetaHelper.processFieldPropParents(fieldProp, (idx, parent) -> {
                    if (startPos[0] > 0) {
                        fieldFullPath.append('.');
                    }
                    fieldFullPath.append(parent.getName());
                    startPos[0] = FahEntityMetaHelper.appendFieldSegmentIntoList(parent, startPos[0], outputList);
                    return true;
                });
            }
        }
        LinkedList bufferList = new LinkedList();
        FahEntityMetaHelper.__processMatchFieldEx(mainEntityType, pathSegmentIdx, fieldPath, (idx, srcMeta) -> {
            if (startPos[0] > 0) {
                fieldFullPath.append('.');
            }
            fieldFullPath.append(srcMeta.getName());
            startPos[0] = FahEntityMetaHelper.appendFieldSegmentIntoList(srcMeta, startPos[0], bufferList);
            return true;
        });
        if (!bufferList.isEmpty()) {
            if (FieldPathTypeEnum.ValueField_Type != ((PairTuple)bufferList.getLast()).getKey()) {
                ((PairTuple)bufferList.getLast()).setKey((Object)FieldPathTypeEnum.ValueField_Type);
            }
            outputList.addAll(bufferList);
        }
        return fieldFullPath.toString();
    }

    protected static int appendFieldSegmentIntoList(IMetadata srcMeta, int startPos, List<PairTuple<FieldPathTypeEnum, int[]>> outputList) {
        FieldPathTypeEnum pathType = srcMeta instanceof EntityType || srcMeta instanceof EntryProp ? FieldPathTypeEnum.Entry_Type : (srcMeta instanceof MainEntityType ? FieldPathTypeEnum.Root_Entity_Type : (srcMeta instanceof BasedataProp ? FieldPathTypeEnum.BaseProp_Type : FieldPathTypeEnum.ValueField_Type));
        int endPos = (startPos += startPos > 0 ? 1 : 0) + srcMeta.getName().length();
        outputList.add((PairTuple<FieldPathTypeEnum, int[]>)new PairTuple((Object)pathType, (Object)new int[]{startPos, endPos}));
        return endPos;
    }

    public static String getEntityName(Object entityNumber) {
        String entityName = "";
        if (entityNumber instanceof String) {
            try {
                entityName = EntityMetadataCache.getDataEntityType((String)((String)entityNumber)).getDisplayName().getLocaleValue();
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"FahEntityMetaHelper_0", (String)"fi-ai-common", (Object[])new Object[0]), entityNumber));
            }
        } else if (entityNumber instanceof Long) {
            DynamicObject assistType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_assistantdatagroup", (String)"name", (QFilter[])new QFilter("id", "=", entityNumber).toArray());
            entityName = assistType != null ? assistType.getString("name") : entityNumber.toString();
        }
        return entityName;
    }

    public static String[] batchGetFactorName(String[] entityNumbers) {
        if (entityNumbers.length == 0) {
            return new String[0];
        }
        ArrayList<String> entityNames = new ArrayList<String>(entityNumbers.length);
        for (String entityNumber : entityNumbers) {
            String entityName = "";
            if (StringUtils.isNotEmpty((String)entityNumber)) {
                Long longValue = ObjectConverterFactory.getLong(entityNumber, -1L);
                entityName = -1L != longValue ? FahEntityMetaHelper.getEntityName(longValue) : FahEntityMetaHelper.getEntityName(entityNumber);
            }
            entityNames.add(entityName);
        }
        return entityNames.toArray(new String[0]);
    }

    public static Map<String, String> batchGetFactorNameMap(Collection<String> entityNumbers) {
        if (entityNumbers.size() == 0) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> result = new HashMap<String, String>(entityNumbers.size());
        for (String entityNumber : entityNumbers) {
            String entityName = "";
            if (!StringUtils.isNotEmpty((String)entityNumber)) continue;
            Long longValue = ObjectConverterFactory.getLong(entityNumber, -1L);
            entityName = -1L != longValue ? FahEntityMetaHelper.getEntityName(longValue) : FahEntityMetaHelper.getEntityName(entityNumber);
            result.put(entityNumber, entityName);
        }
        return result;
    }

    public static class EntityFieldFilter
    implements Function<IDataEntityProperty, Boolean>,
    Serializable {
        protected int maxLevel;
        protected final Collection<Class> requiredClassTypes;
        protected final boolean skipFilter;
        protected final Function<IDataEntityProperty, Class> getPropertyTypeFunc;
        protected Function<IDataEntityProperty, Boolean> needRecursiveEntryCheckFunc;
        protected int maxMatchCnt;

        public EntityFieldFilter(int maxLevel, Collection<Class> requiredClassTypes, Function<IDataEntityProperty, Class> getPropertyTypeFunc) {
            this.requiredClassTypes = requiredClassTypes;
            this.skipFilter = this.requiredClassTypes == null || requiredClassTypes.isEmpty();
            this.getPropertyTypeFunc = getPropertyTypeFunc;
            this.needRecursiveEntryCheckFunc = p -> !(p instanceof BasedataProp);
            this.maxMatchCnt = Integer.MAX_VALUE;
            this.maxLevel = maxLevel;
        }

        public EntityFieldFilter(int maxLevel, int maxMatchCnt, Collection<Class> requiredClassTypes, Function<IDataEntityProperty, Class> getPropertyTypeFunc, Function<IDataEntityProperty, Boolean> needRecursiveEntryCheckFunc) {
            this(maxLevel, requiredClassTypes, getPropertyTypeFunc);
            this.needRecursiveEntryCheckFunc = needRecursiveEntryCheckFunc;
            this.maxMatchCnt = maxMatchCnt;
        }

        public EntityFieldFilter(int maxLevel, int maxMatchCnt, Function<IDataEntityProperty, Boolean> needRecursiveEntryCheckFunc) {
            this(maxLevel, null, null);
            this.needRecursiveEntryCheckFunc = needRecursiveEntryCheckFunc;
            this.maxMatchCnt = maxMatchCnt;
        }

        public EntityFieldFilter(int maxLevel, Collection<Class> requiredClassTypes, Function<IDataEntityProperty, Class> getPropertyTypeFunc, Function<IDataEntityProperty, Boolean> needRecursiveEntryCheckFunc) {
            this(maxLevel, requiredClassTypes, getPropertyTypeFunc);
            this.needRecursiveEntryCheckFunc = needRecursiveEntryCheckFunc;
        }

        @Override
        public Boolean apply(IDataEntityProperty srcProp) {
            if (this.skipFilter || srcProp == null) {
                return false;
            }
            Class propClazzType = this.getPropertyTypeFunc.apply(srcProp);
            if (propClazzType != null) {
                for (Class requiredClazz : this.requiredClassTypes) {
                    if (requiredClazz == null || !requiredClazz.isAssignableFrom(propClazzType)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isNeedRecursiveEntry(IDataEntityProperty srcProp) {
            return srcProp == null ? false : this.needRecursiveEntryCheckFunc.apply(srcProp);
        }

        public Collection<Class> getRequiredClassTypes() {
            return this.requiredClassTypes;
        }

        public boolean isSkipFilter() {
            return this.skipFilter;
        }

        public Function<IDataEntityProperty, Class> getGetPropertyTypeFunc() {
            return this.getPropertyTypeFunc;
        }

        public Function<IDataEntityProperty, Boolean> getNeedRecursiveEntryCheckFunc() {
            return this.needRecursiveEntryCheckFunc;
        }

        public EntityFieldFilter setNeedRecursiveEntryCheckFunc(Function<IDataEntityProperty, Boolean> needRecursiveEntryCheckFunc) {
            this.needRecursiveEntryCheckFunc = needRecursiveEntryCheckFunc;
            return this;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public EntityFieldFilter setMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        public int getMaxMatchCnt() {
            return this.maxMatchCnt;
        }

        public EntityFieldFilter setMaxMatchCnt(int maxMatchCnt) {
            this.maxMatchCnt = maxMatchCnt;
            return this;
        }
    }
}

