/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.function.BiConsumer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;

public class FastHashHelper {
    private static final long Hash_Mod = 909090909090909091L;
    private static final long JAVA_Hash_Mod = 31L;
    private static final Log logger = LogFactory.getLog(FastHashHelper.class);

    public static long getHashCode(Object[] src) {
        long hashCode = FastHashHelper.javaHashCode(src);
        if (DebugTrace.enable()) {
            logger.info("FastHashHelper_getHashCode, hashCode: {}, src: {}", (Object)hashCode, Arrays.asList(src));
        }
        return hashCode;
    }

    public static void closeCloseable(Closeable target) {
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static long javaHashCode(Object[] src) {
        return FastHashHelper.javaHashCode(src, null);
    }

    @Deprecated
    public static long javaHashCode(Object[] src, int[] useColumnPos) {
        if (src == null) {
            return 0L;
        }
        long result = 0L;
        if (useColumnPos != null) {
            for (int pos : useColumnPos) {
                Object element = src[pos];
                result = 31L * result + (element == null ? 0L : (long)element.hashCode());
            }
        } else {
            for (Object element : src) {
                result = 31L * result + (element == null ? 0L : (long)element.hashCode());
            }
        }
        return result;
    }

    public static long buildLongTypeHashCode(Object[] src) {
        return FastHashHelper.buildLongTypeHashCode(src, null);
    }

    public static long buildLongTypeHashCode(Object[] src, int[] useColumnPos) {
        if (src == null) {
            return 0L;
        }
        long result = 1L;
        if (useColumnPos != null) {
            for (int pos : useColumnPos) {
                result = FastHashHelper.__calc_long_hash_code(result, 909090909090909091L, src[pos]);
            }
        } else {
            for (Object element : src) {
                result = FastHashHelper.__calc_long_hash_code(result, 909090909090909091L, element);
            }
        }
        return result;
    }

    private static long __calc_long_hash_code(long pre_hash, long hash_mod, Object element) {
        long codeBuf = element == null ? 0L : (element instanceof String ? FastHashHelper.getStringLongHashCode((String)element) : (element instanceof Date ? ((Date)element).getTime() : (element instanceof Number ? ((Number)element).longValue() : (long)element.hashCode())));
        return hash_mod * pre_hash + codeBuf;
    }

    public static long buildLongTypeArrayHashCode(Long[] src, int[] useColumnPos) {
        if (src == null) {
            return 0L;
        }
        long result = 1L;
        if (useColumnPos != null) {
            for (int pos : useColumnPos) {
                result = result * 909090909090909091L + src[pos];
            }
        } else {
            for (Long element : src) {
                result = result * 909090909090909091L + element;
            }
        }
        return result;
    }

    public static long buildLongTypeArrayHashCode(long[] src, int[] useColumnPos) {
        if (src == null) {
            return 0L;
        }
        long result = 1L;
        if (useColumnPos != null) {
            for (int pos : useColumnPos) {
                result = result * 909090909090909091L + src[pos];
            }
        } else {
            for (long element : src) {
                result = result * 909090909090909091L + element;
            }
        }
        return result;
    }

    public static long getStringLongHashCode(String src) {
        return src == null ? 0L : FastHashHelper.__getStringLongHashCode(src);
    }

    private static long __getStringLongHashCode(String src) {
        long result = 0L;
        char[] value = src.toCharArray();
        for (int i = 0; i < value.length; ++i) {
            result = 909090909090909091L * result + (long)value[i];
        }
        return result;
    }

    public static long getDateLongHashCode(Date src) {
        return src == null ? 0L : src.getTime();
    }

    public static long getNumberLongHashCode(Number src) {
        return src == null ? 0L : src.longValue();
    }

    public static byte[] toByteArray(Object[] objects, int numElements) {
        if (objects == null) {
            return null;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            for (int i = 0; i < numElements; ++i) {
                objectStream.writeObject(objects[i]);
            }
            objectStream.flush();
            objectStream.close();
            return byteStream.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] toByteArray(Object[] objects) {
        if (objects == null) {
            return null;
        }
        return FastHashHelper.toByteArray(objects, objects.length);
    }

    public static byte[] toByteArrayFast(Integer[] objects) {
        return FastHashHelper.toByteArrayFast(objects, (byteBuffer, val) -> byteBuffer.putInt((int)val));
    }

    protected static byte[] toByteArrayFast(Long[] objects) {
        return FastHashHelper.toByteArrayFast(objects, (byteBuffer, val) -> byteBuffer.putLong((long)val));
    }

    public static byte[] toByteArrayFast(Double[] objects) {
        return FastHashHelper.toByteArrayFast(objects, (byteBuffer, val) -> byteBuffer.putDouble((double)val));
    }

    public static byte[] toByteArrayFast(Short[] objects) {
        return FastHashHelper.toByteArrayFast(objects, (byteBuffer, val) -> byteBuffer.putShort((short)val));
    }

    public static byte[] toByteArrayFast(Float[] objects) {
        return FastHashHelper.toByteArrayFast(objects, (byteBuffer, val) -> byteBuffer.putFloat(val.floatValue()));
    }

    public static byte[] toByteArrayFast(Character[] objects) {
        return FastHashHelper.toByteArrayFast(objects, (byteBuffer, val) -> byteBuffer.putChar(val.charValue()));
    }

    public static byte[] toByteArrayFast(Boolean[] objects) {
        return FastHashHelper.toByteArrayFast(objects, (byteBuffer, val) -> byteBuffer.put((byte)(val != false ? 1 : 0)));
    }

    public static byte[] toByteArrayFast(Date[] objects) {
        return FastHashHelper.toByteArrayFast(objects, (byteBuffer, val) -> byteBuffer.putLong(val.getTime()));
    }

    public static <T> byte[] toByteArrayFast(T[] objects, BiConsumer<ByteBuffer, T> convert) {
        if (objects == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(objects.length * 8);
        for (T object : objects) {
            convert.accept(buffer, (ByteBuffer)object);
        }
        return buffer.array();
    }
}

