/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.db.SqlBuilder;
import kd.fi.v2.fah.constant.enums.MappingValueType;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.sqlbuilder.filter.SimpleQFilter;
import kd.fi.v2.fah.sqlbuilder.filter.SimpleQFilterGroup;
import kd.fi.v2.fah.sqlbuilder.filter.SimpleQFilterGroupCollection;
import kd.fi.v2.fah.sqlbuilder.filter.SimpleQFilterInfo;
import kd.fi.v2.fah.sqlbuilder.filter.SimpleQFilterInfo1;
import kd.fi.v2.fah.storage.impl.MutableArrayStorage;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class FilterUtils {
    public static List<SimpleQFilter> parseSimpleFilterCondition(Object source, char delimiter, ObjectConverterFactory.CommonDataTypeEnums dataValueType) {
        SimpleQFilter filterBuf = null;
        LinkedList<SimpleQFilter> resultList = new LinkedList<SimpleQFilter>();
        switch (ICommonDataValueUtil.getObjectEnumerateType(source)) {
            case -1: {
                return Collections.emptyList();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                filterBuf = new SimpleQFilter(source, dataValueType);
                break;
            }
            case 0: {
                String srcText = (source instanceof String ? (String)source : String.valueOf(source)).trim();
                if ("".equals(srcText)) {
                    return Collections.emptyList();
                }
                LinkedList<String> splitList = StringUtils.fastSplit(srcText, delimiter);
                for (String segment : splitList) {
                    if (segment == null || "".equals(segment = segment.trim().toLowerCase(Locale.ENGLISH))) continue;
                    if (segment.startsWith(">=") || segment.startsWith("<=")) {
                        filterBuf = new SimpleQFilter(segment.substring(0, 2), segment.substring(2).trim(), dataValueType);
                        continue;
                    }
                    if (segment.startsWith(">") || segment.startsWith("<")) {
                        filterBuf = new SimpleQFilter(segment.substring(0, 1), segment.substring(1).trim(), dataValueType);
                        continue;
                    }
                    if (segment.startsWith("not in")) {
                        filterBuf = FilterUtils.parseInFilterValueSegment(segment, 6, dataValueType);
                        continue;
                    }
                    if (segment.startsWith("in")) {
                        filterBuf = FilterUtils.parseInFilterValueSegment(segment, 2, dataValueType);
                        continue;
                    }
                    if (segment.startsWith("not like")) {
                        filterBuf = FilterUtils.parseInFilterValueSegment(segment, 8, dataValueType);
                        continue;
                    }
                    if (segment.startsWith("like")) {
                        filterBuf = FilterUtils.parseInFilterValueSegment(segment, 4, dataValueType);
                        continue;
                    }
                    if (segment.contains(",")) {
                        filterBuf = FilterUtils.parseInFilterValueSegment(segment, 0, dataValueType);
                        continue;
                    }
                    filterBuf = new SimpleQFilter("=", segment.trim(), dataValueType);
                }
                break;
            }
        }
        if (filterBuf != null) {
            resultList.add(filterBuf);
        }
        return resultList;
    }

    private static SimpleQFilter parseInFilterValueSegment(String segment, int keyWordLength, ObjectConverterFactory.CommonDataTypeEnums dataValueType) {
        String valueStringBuf;
        if (segment == null) {
            return null;
        }
        String string = valueStringBuf = keyWordLength > 0 ? segment.substring(keyWordLength).trim() : segment.trim();
        if (valueStringBuf.startsWith("(")) {
            valueStringBuf = valueStringBuf.substring(1);
        }
        if (valueStringBuf.endsWith(")")) {
            valueStringBuf = valueStringBuf.substring(0, valueStringBuf.length() - 1);
        }
        if ("".equals(valueStringBuf.trim())) {
            return null;
        }
        LinkedList<String> valueSegmentList = StringUtils.fastSplit(valueStringBuf, ',');
        LinkedList valueBufList = new LinkedList();
        LinkedList<?> dataBuf = null;
        for (String v : valueSegmentList) {
            if ("".equals(v = v.trim())) continue;
            dataBuf = dataValueType.getConverter().convert(v);
            valueBufList.add(dataBuf);
        }
        if (valueBufList.isEmpty()) {
            return null;
        }
        return new SimpleQFilter(segment.substring(0, keyWordLength), valueBufList.size() == 1 ? dataBuf : valueBufList, dataValueType);
    }

    public static List<SimpleQFilter> parseSimpleFilterCondition(String source, ObjectConverterFactory.CommonDataTypeEnums dataValueType) {
        return FilterUtils.parseSimpleFilterCondition(source, ';', dataValueType);
    }

    public static SqlBuilder toSqlBuilder3(List<List<SimpleQFilterInfo1>> filterGroupCollection) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        if (filterGroupCollection != null && filterGroupCollection.size() > 0) {
            sqlBuilder.append("and ( ", new Object[0]);
            boolean first = true;
            for (List<SimpleQFilterInfo1> simpleQFilterInfos : filterGroupCollection) {
                if (first) {
                    first = false;
                } else {
                    sqlBuilder.append(" or ", new Object[0]);
                }
                sqlBuilder.appendSqlBuilder(FilterUtils.toSqlBuilder4(simpleQFilterInfos));
            }
            sqlBuilder.append(" )", new Object[0]);
        }
        return sqlBuilder;
    }

    private static SqlBuilder toSqlBuilder4(List<SimpleQFilterInfo1> simpleQFilterInfos) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        if (simpleQFilterInfos != null && simpleQFilterInfos.size() > 0) {
            sqlBuilder.append("( ", new Object[0]);
            boolean first = true;
            for (SimpleQFilterInfo1 simpleQFilterInfo : simpleQFilterInfos) {
                if (first) {
                    first = false;
                } else {
                    sqlBuilder.append(" and ", new Object[0]);
                }
                sqlBuilder.appendSqlBuilder(FilterUtils.toSqlBuilder5(simpleQFilterInfo));
            }
            sqlBuilder.append(" )", new Object[0]);
        }
        return sqlBuilder;
    }

    private static SqlBuilder toSqlBuilder5(SimpleQFilterInfo1 simpleQFilterInfo) {
        if (simpleQFilterInfo == null) {
            return null;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        String fieldNum = simpleQFilterInfo.getMapValueType().intValue() == MappingValueType.INPUT.getCode() ? "mapvalin." + simpleQFilterInfo.getFlexFieldNum() : "mapvalout." + simpleQFilterInfo.getFlexFieldNum();
        if (simpleQFilterInfo.getCp().equals("in")) {
            List<Object> list = simpleQFilterInfo.getMapColumnType().equals(SimpleQFilterInfo.mapColumnType_String) || simpleQFilterInfo.getMapColumnType().equals(SimpleQFilterInfo.mapColumnType_Downlist) ? ("serialnumber".equals(simpleQFilterInfo.getControlNumber()) ? Arrays.stream(simpleQFilterInfo.getValue().split(",")).filter(kd.bos.util.StringUtils::isNotEmpty).map(Integer::parseInt).collect(Collectors.toList()) : Arrays.asList((Object[])simpleQFilterInfo.getValue().split(","))) : (simpleQFilterInfo.getMapColumnType().equals(SimpleQFilterInfo.mapColumnType_Id) ? Arrays.stream(simpleQFilterInfo.getIds().split(",")).map(Long::parseLong).collect(Collectors.toList()) : (simpleQFilterInfo.getMapColumnType().equals(SimpleQFilterInfo.mapColumnType_Number) ? Arrays.asList((Object[])simpleQFilterInfo.getNumbers().split(",")) : new LinkedList<Object>()));
            sqlBuilder.appendIn(fieldNum, list);
        } else {
            Object value = simpleQFilterInfo.getMapColumnType().equals(SimpleQFilterInfo.mapColumnType_String) || simpleQFilterInfo.getMapColumnType().equals(SimpleQFilterInfo.mapColumnType_Downlist) ? simpleQFilterInfo.getValue() : (simpleQFilterInfo.getMapColumnType().equals(SimpleQFilterInfo.mapColumnType_Date) ? simpleQFilterInfo.getDate() : (simpleQFilterInfo.getMapColumnType().equals(SimpleQFilterInfo.mapColumnType_Id) ? Long.valueOf(Long.parseLong(simpleQFilterInfo.getIds())) : (simpleQFilterInfo.getMapColumnType().equals(SimpleQFilterInfo.mapColumnType_Number) ? simpleQFilterInfo.getNumbers() : null)));
            sqlBuilder.append(fieldNum, new Object[0]).append(simpleQFilterInfo.getCp(), new Object[0]).append("?", new Object[]{value});
        }
        return sqlBuilder;
    }

    public static SqlBuilder getSqlBuilder(SimpleQFilterGroupCollection simpleQFilterGroups) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        if (simpleQFilterGroups == null) {
            return sqlBuilder;
        }
        for (SimpleQFilterGroup group : simpleQFilterGroups) {
            SqlBuilder groupSql = new SqlBuilder();
            groupSql.append("and (", new Object[0]);
            int size = ((MutableArrayStorage)group.getCollections()).size();
            int index = 0;
            for (SimpleQFilter simpleQFilter : group.getCollections()) {
                if ("in".equals(simpleQFilter.getCp())) {
                    groupSql.appendIn(simpleQFilter.getProperty(), (List)simpleQFilter.getFilterValue());
                } else {
                    groupSql.append(simpleQFilter.getProperty(), new Object[0]).append(simpleQFilter.getCp(), new Object[0]);
                    if (simpleQFilter.getFilterValue() instanceof String) {
                        groupSql.append("'", new Object[0]).append((String)simpleQFilter.getFilterValue(), new Object[0]).append("'", new Object[0]);
                    } else {
                        groupSql.append((String)simpleQFilter.getFilterValue(), new Object[0]);
                    }
                }
                if (size > 1 && index < size - 1) {
                    groupSql.append(group.isUseOrJoin() ? " or " : " and ", new Object[0]);
                }
                ++index;
            }
            groupSql.append(")", new Object[0]);
            sqlBuilder.appendSqlBuilder(groupSql);
        }
        return sqlBuilder;
    }
}

