/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.HashSet;
import java.util.LinkedList;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.Visitor;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.FormulaModel;

public class FormulaUtils {
    public static Object CompileFormula(DynamicExtractFieldValueSet cfg) {
        String[] varStrings;
        FormulaModel model = new FormulaModel();
        try {
            varStrings = FormulaEngine.extractVariables((String)cfg.getExpressionValue());
            Expr expr = FormulaEngine.parseFormula((String)cfg.getExpressionValue());
            UDFunctionVisitor mainEntityType = new UDFunctionVisitor();
            expr.accept((Visitor)mainEntityType);
            HashSet<String> funcs = new HashSet<String>();
            funcs.addAll(mainEntityType.getFuncNames());
            model.setExpr(expr);
            model.setFuncs(funcs);
        }
        catch (Throwable exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(cfg.getExpressionValue());
            sb.append("  \r\n");
            sb.append(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519\uff1a\u201c%s\u201d\u3002", (String)"FormulaUtils_0", (String)"fi-ai-common", (Object[])new Object[0]), exp.getMessage()));
            throw new KDBizException(exp, BosErrorCode.expressionParseFailed, new Object[]{sb.toString()});
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)cfg.getDynExtFieldCfg().getSourcePage());
        LinkedList<IVariableMode> vars = new LinkedList<IVariableMode>();
        for (String varString : varStrings) {
            String[] keyItems = StringUtils.split((String)varString, (String)".");
            IVariableMode var = FormulaUtils.buildVarMode(mainEntityType, varString, keyItems);
            vars.add(var);
        }
        model.setVars(vars);
        return model;
    }

    public static IVariableMode buildVarMode(MainEntityType mainEntityType, String varString, String[] keyItems) {
        IVariableMode var = null;
        IDataEntityProperty property = mainEntityType.findProperty(keyItems[0].trim());
        if (property == null && keyItems.length > 0 && mainEntityType.getProperties().containsKey((Object)keyItems[0])) {
            property = (IDataEntityProperty)mainEntityType.getProperties().get((Object)keyItems[0]);
        }
        return var;
    }
}

