/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.ai.enums.BosOrgBizTypeEnum;
import kd.fi.ai.enums.ZeroAmountSysParamEnum;
import kd.fi.ai.util.AiCommonFieldUtils;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.dao.biz.SDOSaveHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class ParamUtils {
    public static final String markKey = "fah.extData.client.type.mark";
    public static final String markTimeKey = "fah.extData.client.type.mark.time";
    public static final String markCodeKey = "fah.extData.client.type.mark.code";
    public static final String bizVoucherMarkKey = "fah.bizVoucher.client.type.mark";
    public static final String bizVoucherMarkTimeKey = "fah.bizVoucher.client.type.mark.time";
    public static final String bizVoucherMarkCodeKey = "fah.bizVoucher.client.type.mark.code";
    public static final String extDataParamInitFlagKey = "fah.extData.client.type.init.flag";
    public static final String oldClient = "0";
    public static final String newClient = "1";
    public static final String appId = "2FMS=8GUFGGN";
    public static final String viewType = "15";
    public static final String useNewExtDataModelKey = "usenewextdatamodel";
    public static final String INITED = "true";
    public static final String splitter = ",";
    public static final String newThread = "fi.ai.buildVoucher.newthreadPool";
    private static String deleteSql = "delete t_ai_sysparam where fkey in (?)";
    private static Object[] deleteParam = new Object[]{"fah.extData.client.type.init.flag"};
    public static String saveSql = "insert into t_ai_sysparam (fid, fkey, fvalue, fdesc) values (?,?,?,?)";
    public static final String DecimalMustInput = "fah.extData.Decimal.mustinput";
    public static final String ViewMoreMaxCount = "fah.gen.result.view.more.maxcount";
    public static final String GenVoucherNoClear = "fah.dap.genvoucher.noclear";
    public static final String ALLOW_ZERO_AMOUNT_GEN_ENTRY = "allowzeroamountgenentry";

    public static String isNewThred() {
        String code = SysParamConfig.getFromDB(newThread);
        if (StringUtils.isEmpty((String)code) || INITED.equals(code)) {
            return INITED;
        }
        return "false";
    }

    public static boolean useNewExtDataModel() {
        ParamUtils.checkUpgradeInit();
        Long rootOrgId = AiCommonFieldUtils.getRootOrgId();
        AppParam appParam = new AppParam();
        appParam.setAppId(appId);
        appParam.setViewType(viewType);
        appParam.setOrgId(rootOrgId);
        Object flag = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)useNewExtDataModelKey);
        return flag instanceof Boolean ? (Boolean)flag : true;
    }

    public static boolean isNewClient() {
        String code = SysParamConfig.getFromDB(markCodeKey);
        if (StringUtils.isEmpty((String)code)) {
            return true;
        }
        try {
            String markInfo = (String)SerializationUtils.deSerializeFromBase64((String)code);
            String[] split = markInfo.split(splitter);
            String mark = split[0];
            return newClient.equals(mark);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isNewClientOfBizVoucher() {
        String code = SysParamConfig.getFromDB(bizVoucherMarkCodeKey);
        if (StringUtils.isEmpty((String)code)) {
            return true;
        }
        try {
            String markInfo = (String)SerializationUtils.deSerializeFromBase64((String)code);
            String[] split = markInfo.split(splitter);
            String mark = split[0];
            return newClient.equals(mark);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static Set<String> getOldMenuIds() {
        HashSet<String> ids = new HashSet<String>(3);
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn("SELECT fid FROM t_meta_menuruntime where fformid", (Object[])new String[]{"ai_standardevent"});
        try (DataSet dataSet = DB.queryDataSet((String)"ParamUtils.getOldMenuIds", (DBRoute)DBRoute.meta, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getString("fid"));
            }
        }
        return ids;
    }

    private static boolean extDataParamInited() {
        String initFlag = SysParamConfig.getFromDB(extDataParamInitFlagKey);
        return INITED.equals(initFlag);
    }

    private static synchronized void initExtDataParam() {
        if (ParamUtils.extDataParamInited()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                Long[] ids = SDOSaveHelper.getIds("t_ai_sysparam", "ai", 1);
                DB.execute((DBRoute)FAHCommonConstant.AI, (String)deleteSql, (Object[])deleteParam);
                DB.execute((DBRoute)FAHCommonConstant.AI, (String)saveSql, (Object[])new Object[]{ids[0], extDataParamInitFlagKey, INITED, DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")});
                ParamUtils.setUseNewExtDataModel(ParamUtils.isNewClient());
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void setUseNewExtDataModel(boolean newClient) {
        Long rootOrgId = AiCommonFieldUtils.getRootOrgId();
        AppParam appParam = new AppParam();
        appParam.setAppId(appId);
        appParam.setViewType(viewType);
        appParam.setOrgId(rootOrgId);
        Map params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        params.put(useNewExtDataModelKey, newClient);
        SystemParamServiceHelper.saveAppParameter((String)appId, (String)viewType, (Long)rootOrgId, (Long)0L, (Map)params);
    }

    public static void checkUpgradeInit() {
        if (ParamUtils.extDataParamInited()) {
            return;
        }
        ParamUtils.initExtDataParam();
    }

    public static String encode(String mark, Long timeStamp) {
        String markInfo = mark + splitter + timeStamp.toString();
        String base64 = SerializationUtils.serializeToBase64((Object)markInfo);
        return base64;
    }

    public static boolean isMustInput() {
        String code = SysParamConfig.getFromDB(DecimalMustInput);
        if (StringUtils.isEmpty((String)code)) {
            return true;
        }
        return Boolean.parseBoolean(code);
    }

    public static int getViewMoreMaxCount() {
        int viewMoreMaxCount;
        String count = SysParamConfig.getFromDB(ViewMoreMaxCount);
        if (StringUtils.isEmpty((String)count)) {
            return 1000;
        }
        try {
            viewMoreMaxCount = Integer.parseInt(count);
        }
        catch (Exception e) {
            return 1000;
        }
        return viewMoreMaxCount;
    }

    public static boolean isGenVoucherNoClear() {
        String code = SysParamConfig.getFromDB(GenVoucherNoClear);
        if (StringUtils.isEmpty((String)code)) {
            return false;
        }
        return Boolean.parseBoolean(code);
    }

    public static Object getSingleFahSystemParam(String paramKey, Long orgId) {
        Object paramValue;
        String cacheKey = paramKey + orgId;
        if (ThreadCache.exists((Object)cacheKey)) {
            paramValue = ThreadCache.get((Object)cacheKey);
        } else {
            AppParam appParam = new AppParam(appId, BosOrgBizTypeEnum.ACCOUNTING.getNumber(), orgId, Long.valueOf(0L));
            paramValue = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)paramKey);
        }
        return paramValue;
    }

    public static String getZeroAmountParam(Long orgId) {
        Object zeroAmount = ParamUtils.getSingleFahSystemParam(ALLOW_ZERO_AMOUNT_GEN_ENTRY, orgId);
        return (String)Optional.ofNullable(zeroAmount).orElseGet(() -> ParamUtils.getGLZeroAmountParam(orgId));
    }

    public static String getGLZeroAmountParam(Long orgId) {
        boolean systemParamsForZeroAmount = DapBuildVoucherCommonUtil.getSystemParamsForZeroAmount(orgId);
        return systemParamsForZeroAmount ? ZeroAmountSysParamEnum.ALWAYS_GENERATE.getValue() : ZeroAmountSysParamEnum.ALWAYS_NOT_GENERATE.getValue();
    }
}

