/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public class StringUtils
extends kd.bos.util.StringUtils {
    public static final String Default_TabSpace_String = "  ";
    public static final String Single_Whitespace_String = "";
    private static final String[] Empty_String_Array = new String[0];
    private static final String[] Single_Whitespace_String_Array = new String[]{""};
    public static final char CSV_Splitter_Char = ',';
    public static final char DefaultEscapeChar = '\\';

    public static Object[] splitTextAndNumber(String source) {
        String txtBuf;
        char[] chars = source.toCharArray();
        LinkedList<Object> result = new LinkedList<Object>();
        int startPos = 0;
        int length = 0;
        Boolean lastMode = null;
        for (int i = 0; i < chars.length; ++i) {
            boolean isNum;
            char buf = chars[i];
            boolean bl = isNum = buf >= '0' && buf <= '9';
            if (lastMode == null || lastMode == isNum) {
                if (lastMode == null) {
                    lastMode = isNum;
                }
                ++length;
                continue;
            }
            if (length > 0) {
                txtBuf = new String(chars, startPos, length);
                result.add(lastMode != false ? Integer.valueOf(txtBuf) : txtBuf);
            }
            length = 1;
            startPos = i;
            lastMode = isNum;
        }
        if (length > 0) {
            txtBuf = new String(chars, startPos, length);
            result.add(lastMode != false ? Integer.valueOf(txtBuf) : txtBuf);
        }
        return result.toArray();
    }

    public static String collectionToString(Collection source, String splitter) {
        if (source == null || source.isEmpty()) {
            return Single_Whitespace_String;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object obj : source) {
            if (first) {
                first = false;
            } else {
                builder.append(splitter);
            }
            builder.append(obj);
        }
        return builder.toString();
    }

    public static <T> String arrayToString(T[] source, String splitter) {
        if (source == null || source.length == 0) {
            return Single_Whitespace_String;
        }
        int length = source.length;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < length; ++i) {
            if (first) {
                first = false;
            } else {
                builder.append(splitter);
            }
            builder.append(source[i]);
        }
        return builder.toString();
    }

    public static String collectionToString(Collection source, char splitter) {
        return StringUtils.collectionToString(source, String.valueOf(splitter));
    }

    public static String collectionToString(Collection source) {
        return StringUtils.collectionToString(source, String.valueOf(','));
    }

    public static boolean isEmpty(Object value) {
        return value == null || Single_Whitespace_String.equals(String.valueOf(value).trim());
    }

    public static String join(Object[] array, String d) {
        StringBuilder a = new StringBuilder();
        int i = 0;
        int length = array.length;
        for (Object o : array) {
            a.append(o);
            if (++i >= length) continue;
            a.append(d);
        }
        return a.toString();
    }

    public static LinkedList<String> fastSplit(String source, char delimiter, boolean withoutEmpty) {
        LinkedList<String> bufList = new LinkedList<String>();
        if (source == null || source.length() == 0) {
            if (!withoutEmpty) {
                bufList.add(Single_Whitespace_String);
            }
            return bufList;
        }
        char[] chs = source.toCharArray();
        int startPos = 0;
        int delimiterOffset = 0;
        int segmentCnt = 0;
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] != delimiter) {
                ++segmentCnt;
                continue;
            }
            delimiterOffset = 1;
            if (segmentCnt == 0) {
                if (!withoutEmpty) {
                    bufList.add(Single_Whitespace_String);
                }
            } else {
                StringUtils._split_add_buffer_list(chs, startPos, segmentCnt, bufList, withoutEmpty);
            }
            startPos = i + delimiterOffset;
            segmentCnt = 0;
        }
        if (segmentCnt > 0) {
            StringUtils._split_add_buffer_list(chs, startPos, segmentCnt, bufList, withoutEmpty);
        }
        return bufList;
    }

    public static String[] fastSplitEX(String source, char delimiter, boolean withoutEmpty) {
        return StringUtils.fastSplit(source, delimiter, withoutEmpty).toArray(Empty_String_Array);
    }

    public static <T> T[] fastSplitToArray(String srcString, char delimiter, boolean withoutEmpty, boolean trimTokenValue, Function<? super Integer, T[]> arrayCreatorFunc, Function<? super String, ? extends T> tokeConvertFunc) {
        String[] tokens;
        if (srcString == null) {
            return arrayCreatorFunc.apply((Integer)0);
        }
        String buf = srcString.trim();
        char checkChar = buf.charAt(0);
        if (checkChar == '(' || checkChar == '[' || checkChar == '{') {
            buf = buf.substring(1);
        }
        if ((checkChar = buf.charAt(buf.length() - 1)) == ')' || checkChar == ']' || checkChar == '}') {
            buf = buf.substring(0, buf.length() - 2);
        }
        if ((tokens = StringUtils.fastSplitEX(buf, delimiter, withoutEmpty)).length == 0) {
            return arrayCreatorFunc.apply((Integer)0);
        }
        int length = tokens.length;
        T[] result = arrayCreatorFunc.apply((Integer)length);
        for (int i = 0; i < length; ++i) {
            String v = tokens[i];
            result[i] = v == null ? null : tokeConvertFunc.apply(trimTokenValue ? v.trim() : v);
        }
        return result;
    }

    public static <T> T[] fastSplitToArray(String srcString, char delimiter, Function<? super Integer, T[]> arrayCreatorFunc, Function<? super String, ? extends T> tokeConvertFunc) {
        return StringUtils.fastSplitToArray(srcString, delimiter, true, true, arrayCreatorFunc, tokeConvertFunc);
    }

    public static <T> T[] fastSplitToArray(String srcString, Function<? super Integer, T[]> arrayCreatorFunc, Function<? super String, ? extends T> tokeConvertFunc) {
        return StringUtils.fastSplitToArray(srcString, ',', true, true, arrayCreatorFunc, tokeConvertFunc);
    }

    public static int getWordSegmentPos(char[] sourceChars, char delimiter, boolean forwardDirection, int startPos, int includeSegmentCnt) {
        int idx;
        int remainCnt;
        if (sourceChars == null) {
            return -1;
        }
        int len = sourceChars.length;
        if (len <= 0) {
            return 0;
        }
        boolean found = false;
        int wordLen = 0;
        int n = remainCnt = includeSegmentCnt >= 0 ? includeSegmentCnt : Integer.MAX_VALUE;
        if (forwardDirection) {
            if (startPos >= len) {
                return len;
            }
            for (idx = Math.max(startPos, 0); idx < len; ++idx) {
                if (sourceChars[idx] == delimiter) {
                    if (--remainCnt <= 0) {
                        if (wordLen > 0) {
                            --idx;
                        }
                        found = true;
                        break;
                    }
                    wordLen = 0;
                    continue;
                }
                ++wordLen;
            }
        } else {
            if (startPos <= 0) {
                return 0;
            }
            for (idx = Math.min(startPos, len - 1); idx >= 0; --idx) {
                if (sourceChars[idx] == delimiter) {
                    if (--remainCnt <= 0) {
                        if (wordLen > 0) {
                            ++idx;
                        }
                        found = true;
                        break;
                    }
                    wordLen = 0;
                    continue;
                }
                ++wordLen;
            }
        }
        return found ? idx : -1;
    }

    public static int getWordSegmentPos(String source, char delimiter, boolean forwardDirection, int startPos, int includeSegmentCnt) {
        return StringUtils.getWordSegmentPos(source.toCharArray(), delimiter, forwardDirection, startPos, includeSegmentCnt);
    }

    public static int getWordSegmentPos(String source, char delimiter, boolean forwardDirection, int includeSegmentCnt) {
        if (source == null) {
            return -1;
        }
        return StringUtils.getWordSegmentPos(source.toCharArray(), delimiter, forwardDirection, forwardDirection ? 0 : source.length() - 1, includeSegmentCnt);
    }

    public static int getWordSegmentFirstPos(String source, char delimiter, boolean forwardDirection) {
        return StringUtils.getWordSegmentPos(source, delimiter, forwardDirection, 1);
    }

    public static String getSegmentWords(String source, char delimiter, boolean forwardDirection, int startSegmentPos, int includeSegmentCnt) {
        int endPos;
        int startPos;
        if (source == null) {
            return null;
        }
        if (includeSegmentCnt == 0) {
            return Single_Whitespace_String;
        }
        int len = source.length();
        char[] srcChars = source.toCharArray();
        if (forwardDirection) {
            if (startSegmentPos > 0) {
                startPos = StringUtils.getWordSegmentPos(srcChars, delimiter, forwardDirection, 0, startSegmentPos);
                if (startPos < 0) {
                    startPos = 0;
                }
            } else {
                startPos = 0;
            }
            if (includeSegmentCnt > 0) {
                endPos = StringUtils.getWordSegmentPos(srcChars, delimiter, forwardDirection, startPos, startSegmentPos + includeSegmentCnt);
                if (endPos < 0) {
                    endPos = len;
                } else if (endPos < len) {
                    ++endPos;
                }
            } else {
                endPos = len;
            }
        } else {
            endPos = StringUtils.getWordSegmentPos(srcChars, delimiter, forwardDirection, source.length() - 1, startSegmentPos);
            if (endPos < 0) {
                endPos = len;
            } else if (endPos < len) {
                ++endPos;
            }
            if (includeSegmentCnt > 0) {
                startPos = StringUtils.getWordSegmentPos(srcChars, delimiter, forwardDirection, endPos, startSegmentPos + includeSegmentCnt);
                if (startPos < 0) {
                    startPos = 0;
                }
            } else {
                startPos = 0;
            }
        }
        return source.substring(startPos, endPos);
    }

    public static String getHeaderOrTailWord(String source, char delimiter, boolean firstOrLast) {
        if (source == null) {
            return null;
        }
        int len = source.length();
        if (len <= 0) {
            return source;
        }
        int idx = StringUtils.getWordSegmentFirstPos(source, delimiter, firstOrLast);
        if (idx == -1) {
            return Single_Whitespace_String;
        }
        if (idx == len) {
            return String.valueOf(source.charAt(idx));
        }
        if (firstOrLast) {
            return idx == 0 ? Single_Whitespace_String : source.substring(0, idx + 1);
        }
        if (idx == len - 1) {
            if (source.charAt(idx) != delimiter) {
                return String.valueOf(source.charAt(idx));
            }
            return Single_Whitespace_String;
        }
        return source.substring(idx, len);
    }

    public static String getHeaderOrTailSegment(String source, char delimiter, boolean excludeFirstOrLastSegment, int excludeSegmentCnt) {
        int len;
        if (source == null) {
            return null;
        }
        if (excludeSegmentCnt <= 0 || (len = source.length()) <= 0) {
            return source;
        }
        int idx = excludeSegmentCnt == 1 ? StringUtils.getWordSegmentFirstPos(source, delimiter, excludeFirstOrLastSegment) : StringUtils.getWordSegmentPos(source, delimiter, excludeFirstOrLastSegment, excludeSegmentCnt);
        if (idx < 0) {
            return Single_Whitespace_String;
        }
        char[] sourceChars = source.toCharArray();
        if (excludeFirstOrLastSegment) {
            if (idx < len - 1) {
                ++idx;
            }
            while (idx < len && sourceChars[idx] == delimiter) {
                ++idx;
            }
            if (idx >= len) {
                return Single_Whitespace_String;
            }
        } else {
            if (idx > 0) {
                --idx;
            }
            while (idx >= 0 && sourceChars[idx] == delimiter) {
                --idx;
            }
            if (idx < 0) {
                return Single_Whitespace_String;
            }
            if (idx >= 0) {
                ++idx;
            }
        }
        return excludeFirstOrLastSegment ? (idx < 0 ? Single_Whitespace_String : source.substring(idx, len)) : (idx > len ? Single_Whitespace_String : source.substring(0, idx));
    }

    public static String getHeaderOrTailSegment(String source, char delimiter, boolean excludeFirstOrLastSegment) {
        return StringUtils.getHeaderOrTailSegment(source, delimiter, excludeFirstOrLastSegment, 1);
    }

    private static void _split_add_buffer_list(char[] chs, int offset, int segmentCnt, Collection<String> outputBuffer, boolean withoutEmpty) {
        int startPos = offset;
        String segmentBuf = new String(Arrays.copyOfRange(chs, startPos, startPos + segmentCnt));
        if (Single_Whitespace_String.equals(segmentBuf)) {
            if (!withoutEmpty) {
                outputBuffer.add(Single_Whitespace_String);
            }
        } else {
            outputBuffer.add(segmentBuf);
        }
    }

    public static LinkedList<String> fastSplit(String source, char delimiter) {
        return StringUtils.fastSplit(source, delimiter, true);
    }

    public static String[] fastSplitEX(String source, char delimiter) {
        return StringUtils.fastSplit(source, delimiter, true).toArray(Empty_String_Array);
    }

    public static LinkedList<String> fastSplitNonCp(String source, char delimiter, boolean withoutEmpty) {
        LinkedList<String> bufList = new LinkedList<String>();
        if (source == null || source.length() == 0) {
            if (withoutEmpty) {
                bufList.add(Single_Whitespace_String);
            }
            return bufList;
        }
        int length = source.length();
        int offset = 0;
        int segmentCnt = 0;
        for (int i = 0; i < length; ++i) {
            if (source.charAt(i) != delimiter) {
                ++segmentCnt;
                continue;
            }
            if (segmentCnt == 0) {
                if (!withoutEmpty) {
                    bufList.add(Single_Whitespace_String);
                }
            } else {
                StringUtils._split_large_add_buffer_list(source, offset, segmentCnt, bufList, withoutEmpty);
            }
            offset = i;
            segmentCnt = 0;
        }
        if (segmentCnt > 0 || source.charAt(length - 1) != delimiter) {
            StringUtils._split_large_add_buffer_list(source, offset, segmentCnt, bufList, withoutEmpty);
        }
        return bufList;
    }

    public static String[] fastSplitNonCpEx(String source, char delimiter, boolean withoutEmpty) {
        return StringUtils.fastSplitNonCp(source, delimiter, withoutEmpty).toArray(Empty_String_Array);
    }

    private static void _split_large_add_buffer_list(String source, int offset, int segmentCnt, Collection<String> outputBuffer, boolean withoutEmpty) {
        int startPos;
        String segmentBuf = source.substring(offset == 0 ? offset : offset + 1, (startPos = offset == 0 ? offset : offset + 1) + segmentCnt);
        if (Single_Whitespace_String.equals(segmentBuf)) {
            if (!withoutEmpty) {
                outputBuffer.add(Single_Whitespace_String);
            }
        } else {
            outputBuffer.add(segmentBuf);
        }
    }

    public static boolean isEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 != null) {
            return s1.equals(s2);
        }
        return s2.equals(s1);
    }

    public static int findWordLeftPos(char[] source, int startPos, char matchCharacter, char escapeChar) {
        int findPos;
        char currentChar = ' ';
        boolean findMatchChar = false;
        boolean hasEscape = false;
        for (findPos = startPos; findPos >= 0; --findPos) {
            currentChar = source[findPos];
            if (matchCharacter == currentChar) {
                if (findMatchChar) break;
                findMatchChar = true;
            } else {
                if (escapeChar == currentChar) {
                    hasEscape = !hasEscape;
                    continue;
                }
                if (findMatchChar && !hasEscape) break;
            }
            if (hasEscape && findMatchChar) {
                findMatchChar = false;
            }
            hasEscape = false;
        }
        return findPos + 1;
    }

    public static int findWordLeftPos(char[] source, int startPos, char matchCharacter) {
        return StringUtils.findWordLeftPos(source, startPos, matchCharacter, '\\');
    }

    public static int findWordRightPos(char[] source, int startPos, char matchCharacter, char escapeChar) {
        char currentChar = ' ';
        int endPos = source.length;
        boolean hasEscape = false;
        for (int findPos = startPos; findPos < endPos; ++findPos) {
            currentChar = source[findPos];
            if (matchCharacter == currentChar) {
                if (!hasEscape) {
                    return findPos + 1 >= endPos ? endPos : findPos + 1;
                }
            } else if (escapeChar == currentChar) {
                hasEscape = !hasEscape;
                continue;
            }
            hasEscape = false;
        }
        return endPos;
    }

    public static int findWordRightPos(char[] source, int startPos, char matchCharacter) {
        return StringUtils.findWordRightPos(source, startPos, matchCharacter, '\\');
    }

    public static int findWordPos(char[] source, int startPos, char matchCharacter, char escapeChar, boolean forward) {
        return forward ? StringUtils.findWordRightPos(source, startPos, matchCharacter, escapeChar) : StringUtils.findWordLeftPos(source, startPos, matchCharacter, escapeChar);
    }

    public static int findWordPos(char[] source, int startPos, char matchCharacter, boolean forward) {
        return StringUtils.findWordPos(source, startPos, matchCharacter, '\\', forward);
    }

    public static int findBlockLeftPos(char[] source, int startPos, char[] leftBlockChar, char[] rightBlockChar, int requiredBlockLevel) {
        int findPos;
        char currentChar = ' ';
        int needSkipBlockCnt = requiredBlockLevel;
        for (findPos = startPos; findPos >= 0; --findPos) {
            currentChar = source[findPos];
            if (StringUtils.contains(leftBlockChar, currentChar)) {
                if (needSkipBlockCnt <= 0) break;
                --needSkipBlockCnt;
                continue;
            }
            if (!StringUtils.contains(rightBlockChar, currentChar)) continue;
            ++needSkipBlockCnt;
        }
        return findPos >= 0 ? findPos : 0;
    }

    public static int findBlockLeftPos(char[] source, int startPos, char leftBlockChar, char rightBlockChar, int requiredBlockLevel) {
        return StringUtils.findBlockLeftPos(source, startPos, new char[]{leftBlockChar}, new char[]{rightBlockChar}, requiredBlockLevel);
    }

    public static final boolean contains(char[] sourceChars, char matchChar) {
        for (char c : sourceChars) {
            if (matchChar != c) continue;
            return true;
        }
        return false;
    }

    public static int findBlockLeftPos(char[] source, int startPos, char[] leftBlockChar, char[] rightBlockChar) {
        return StringUtils.findBlockLeftPos(source, startPos, leftBlockChar, rightBlockChar, 0);
    }

    public static int findBlockRightPos(char[] source, int startPos, char[] leftBlockChar, char[] rightBlockChar, int requiredBlockLevel) {
        int findPos;
        char currentChar = ' ';
        int needSkipBlockCnt = requiredBlockLevel;
        int length = source.length;
        for (findPos = startPos; findPos < length; ++findPos) {
            currentChar = source[findPos];
            if (StringUtils.contains(rightBlockChar, currentChar)) {
                if (needSkipBlockCnt <= 0) break;
                --needSkipBlockCnt;
                continue;
            }
            if (!StringUtils.contains(leftBlockChar, currentChar)) continue;
            ++needSkipBlockCnt;
        }
        return ++findPos >= length ? length : findPos;
    }

    public static int findBlockRightPos(char[] source, int startPos, char[] leftBlockChar, char[] rightBlockChar) {
        return StringUtils.findBlockRightPos(source, startPos, leftBlockChar, rightBlockChar, 0);
    }

    public static int findBlockRightPos(char[] source, int startPos, char leftBlockChar, char rightBlockChar, int requiredBlockLevel) {
        return StringUtils.findBlockRightPos(source, startPos, new char[]{leftBlockChar}, new char[]{rightBlockChar}, requiredBlockLevel);
    }

    public static int[] findWordPos(char[] source, int startPos, char matchCharacter, char escapeChar) {
        return new int[]{StringUtils.findWordLeftPos(source, startPos, matchCharacter, escapeChar), StringUtils.findWordRightPos(source, startPos, matchCharacter, escapeChar)};
    }

    public static int[] findBlockPos(char[] source, int startPos, char[] leftBlockChar, char[] rightBlockChar, int requiredBlockLevel) {
        return new int[]{StringUtils.findBlockLeftPos(source, startPos, leftBlockChar, rightBlockChar, requiredBlockLevel), StringUtils.findBlockRightPos(source, startPos, leftBlockChar, rightBlockChar, requiredBlockLevel)};
    }

    public static int[] findBlockPos(char[] source, int startPos, char leftBlockChar, char rightBlockChar, int requiredBlockLevel) {
        char[] left = new char[]{leftBlockChar};
        char[] right = new char[]{rightBlockChar};
        return new int[]{StringUtils.findBlockLeftPos(source, startPos, left, right, requiredBlockLevel), StringUtils.findBlockRightPos(source, startPos, left, right, requiredBlockLevel)};
    }

    public static String parseWord(char[] source, int startPos, char matchCharacter, char escapeChar) {
        if (source == null || source.length == 0) {
            return null;
        }
        int leftPos = StringUtils.findWordLeftPos(source, startPos, matchCharacter, escapeChar);
        return String.valueOf(source, leftPos, StringUtils.findWordRightPos(source, startPos, matchCharacter, escapeChar) - leftPos);
    }

    public static String parseBlock(char[] source, int startPos, char[] leftBlockChar, char[] rightBlockChar, int requiredBlockLevel) {
        if (source == null || source.length == 0) {
            return null;
        }
        int[] pos = StringUtils.findBlockPos(source, startPos, leftBlockChar, rightBlockChar, requiredBlockLevel);
        return String.valueOf(source, pos[0], pos[1] - pos[0]);
    }

    public static String parseBlock(char[] source, int startPos, char leftBlockChar, char rightBlockChar, int requiredBlockLevel) {
        if (source == null || source.length == 0) {
            return null;
        }
        int[] pos = StringUtils.findBlockPos(source, startPos, leftBlockChar, rightBlockChar, requiredBlockLevel);
        return String.valueOf(source, pos[0], pos[1] - pos[0]);
    }

    public static InputStream getInputStream(String source, Charset charset) {
        return new ByteArrayInputStream(source.getBytes(charset));
    }

    public static InputStream getInputStream(String source) {
        return new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] encode(String str) {
        if (str == null) {
            throw new RuntimeException("encode value cannot be null");
        }
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static String decode(byte[] value) {
        if (value == null) {
            throw new RuntimeException("decode value cannot be null");
        }
        return new String(value, StandardCharsets.UTF_8);
    }

    public static String buildPrefix(String linePrefix, String valuePrefix, String levelTabPrefix, int level) {
        if (level <= 0) {
            return Single_Whitespace_String;
        }
        StringBuilder buf = new StringBuilder();
        if (linePrefix != null) {
            buf.append(linePrefix);
        }
        for (int i = 0; i < level; ++i) {
            buf.append(levelTabPrefix);
        }
        if (valuePrefix != null) {
            buf.append(valuePrefix);
        }
        return buf.toString();
    }

    public static String buildPrefix(String valuePrefix, String levelTabPrefix, int level) {
        return StringUtils.buildPrefix(null, valuePrefix, levelTabPrefix, level);
    }

    public static String buildPrefix(String levelTabPrefix, int level) {
        return StringUtils.buildPrefix(null, null, levelTabPrefix, level);
    }
}

