/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;
import kd.fi.v2.fah.utils.StringUtils;

public class TreeSearchUtils {
    public static LinkedHashMap<String, List<String>> loadNodes(TreeNode root) {
        LinkedHashMap<String, List<String>> nodes = new LinkedHashMap<String, List<String>>();
        TreeSearchUtils.dfs(root, nodes);
        return nodes;
    }

    private static void dfs(TreeNode node, Map<String, List<String>> nodes) {
        if (node == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>(2);
        text.add(node.getText());
        text.add(node.getLongText());
        nodes.put(node.getId(), text);
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                TreeSearchUtils.dfs(child, nodes);
            }
        }
    }

    public static List<String> getSearchResult(String name, String selectNodeId, LinkedHashMap<String, List<String>> nodes) {
        LinkedList<String> result = new LinkedList<String>();
        boolean startSearch = false;
        for (Map.Entry<String, List<String>> entry : nodes.entrySet()) {
            String nodeId = entry.getKey();
            List<String> nodeText = entry.getValue();
            if (StringUtils.isEquals(selectNodeId, nodeId)) {
                startSearch = true;
                continue;
            }
            if (!startSearch || !nodeText.get(0).contains(name)) continue;
            result.add(nodeId);
        }
        return result;
    }
}

