/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils;

import java.util.Collection;
import java.util.Iterator;
import kd.fi.bd.util.iterators.impl.IntArraySequenceIterator;
import kd.fi.bd.util.iterators.impl.IntArraySequenceIteratorBuilder;
import kd.fi.v2.fah.models.valueset.IBaseSimpleValueSet;
import kd.fi.v2.fah.models.valueset.IBaseSimpleValueSetCollection;

public class ValueSetUtilHelper {
    public static int calculateTotalRowCnt(IBaseSimpleValueSetCollection<? extends IBaseSimpleValueSet> srcValueSetCollection) {
        if (srcValueSetCollection == null || srcValueSetCollection.isEmpty()) {
            return 0;
        }
        int totalRowCnt = 0;
        for (IBaseSimpleValueSet iBaseSimpleValueSet : srcValueSetCollection) {
            if (iBaseSimpleValueSet == null) continue;
            totalRowCnt += ValueSetUtilHelper.calculateTotalRowCnt(iBaseSimpleValueSet);
        }
        return totalRowCnt;
    }

    public static int calculateTotalRowCnt(IBaseSimpleValueSet srcValueSet) {
        if (srcValueSet == null || !srcValueSet.isHasMulValue()) {
            return 0;
        }
        int totalRowCnt = 1;
        Iterator it = srcValueSet.getValueIterator();
        while (it.hasNext()) {
            Object valBuf = it.next();
            if (!(valBuf instanceof Collection) || ((Collection)valBuf).isEmpty()) continue;
            totalRowCnt *= ((Collection)valBuf).size();
        }
        return totalRowCnt;
    }

    public static IntArraySequenceIterator buildComboItemIterator(IBaseSimpleValueSet srcValueSet) {
        if (srcValueSet == null) {
            return null;
        }
        IntArraySequenceIteratorBuilder builder = new IntArraySequenceIteratorBuilder();
        if (!srcValueSet.isHasMulValue()) {
            srcValueSet.forEach((colIdx, v) -> {
                builder.addFixedValue(((Integer)colIdx).intValue(), v);
                return true;
            });
        } else {
            srcValueSet.forEach((colIdx, v) -> {
                if (v instanceof Collection) {
                    builder.addArrayValue(((Collection)v).toArray());
                } else {
                    builder.addFixedValue(((Integer)colIdx).intValue(), v);
                }
                return true;
            });
        }
        return builder.build();
    }
}

