/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils.mutex;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;

public class FahMutexRequireUtil {
    private static final Log logger = LogFactory.getLog(FahMutexRequireUtil.class);
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat timesdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String MUTEX_DATAOBJID = "dataObjId";
    private static final String MUTEX_GROUPID = "groupId";
    private static final String MUTEX_ENTITYKEY = "entityKey";
    private static final String MUTEX_OPERATIONKEY = "operationKey";
    private static final String MUTEX_ISSTRICT = "isStrict";
    protected static final String AIEVENT = "ai_event";
    private static final String NET_GROUP = "buildvoucherservice";
    private static final String OPERATION_KEY = "generatevoucher";
    private static final int Success_ID = 0;
    private static final int Failed_ID = 1;
    private static final int TryLock_Failed_LockKey = 0;
    private static final int TryLock_Failed_OriginalId = 1;
    private static final boolean Mutex_Strict = true;

    private static <T> void __eventRequireMutex(Set outputTarget, String entityKey, Set objectLockKeys, Function<String, Object> lockKeyToObjectIdConvertor, BiFunction<String, Collection, T> failedInfoCollector, BiConsumer<T, PairTuple<Object, String>> failedReportFunc) {
        if (objectLockKeys == null || objectLockKeys.isEmpty()) {
            return;
        }
        if (failedInfoCollector == null && failedReportFunc != null || failedInfoCollector != null && failedReportFunc == null) {
            throw new IllegalArgumentException("failed Information Collector and Fail Report Function should either both be null or all have value!");
        }
        boolean needConvertId = lockKeyToObjectIdConvertor != null;
        HashMap<Long, String> userName = new HashMap<Long, String>(2);
        LinkedList<Object> reqObjIds = new LinkedList<Object>(objectLockKeys);
        List[] lockResultKeys = new List[2];
        for (int i = 0; i < lockResultKeys.length; ++i) {
            lockResultKeys[i] = new LinkedList();
        }
        List[] lockKeyBuffer = new List[2];
        for (int i = 0; i < lockKeyBuffer.length; ++i) {
            lockKeyBuffer[i] = new LinkedList();
        }
        List[] originalIds = new List[3];
        if (needConvertId) {
            for (int i = 0; i < originalIds.length; ++i) {
                originalIds[i] = new LinkedList();
            }
        }
        boolean retryMode = false;
        long now = System.currentTimeMillis();
        Object _originalId = null;
        try (DataMutex dataMutex = DataMutex.create();){
            while (!reqObjIds.isEmpty()) {
                for (Map.Entry mutexItem : dataMutex.batchrequire(FahMutexRequireUtil.batchBuildMutexRequiredParamMap(reqObjIds, entityKey, true)).entrySet()) {
                    String _lockKey = (String)mutexItem.getKey();
                    if (needConvertId) {
                        _originalId = lockKeyToObjectIdConvertor.apply(_lockKey);
                    }
                    if (((Boolean)mutexItem.getValue()).booleanValue()) {
                        lockResultKeys[0].add(_lockKey);
                        if (!needConvertId) continue;
                        originalIds[0].add(_originalId);
                        continue;
                    }
                    if (retryMode) {
                        lockResultKeys[1].add(_lockKey);
                        if (!needConvertId) continue;
                        originalIds[1].add(_originalId);
                        continue;
                    }
                    lockKeyBuffer[0].add(_lockKey);
                    if (!needConvertId) continue;
                    lockKeyBuffer[1].add(_originalId);
                }
                if (lockKeyBuffer[0].isEmpty()) {
                    break;
                }
                reqObjIds.clear();
                Object failedInfos = failedInfoCollector != null ? failedInfoCollector.apply(entityKey, lockKeyBuffer[needConvertId ? 1 : 0]) : null;
                Iterator originalIdIter = needConvertId ? lockKeyBuffer[1].iterator() : Collections.EMPTY_LIST.iterator();
                for (Object lockKey : lockKeyBuffer[0]) {
                    Object _curOriginalId;
                    Object e = _curOriginalId = needConvertId ? originalIdIter.next() : lockKey;
                    if (FahMutexRequireUtil.checkCanAutoReleaseLockId(dataMutex.getLockInfo(lockKey.toString(), NET_GROUP, entityKey), _curOriginalId, entityKey, now, 60, userName, msg -> {
                        if (failedReportFunc != null) {
                            failedReportFunc.accept(failedInfos, new PairTuple(_curOriginalId, msg));
                        } else {
                            logger.info(msg);
                        }
                    })) {
                        reqObjIds.add(lockKey);
                        continue;
                    }
                    lockResultKeys[1].add(lockKey);
                    if (!needConvertId) continue;
                    originalIds[1].add(_curOriginalId);
                }
                if (reqObjIds.isEmpty()) {
                    break;
                }
                FahMutexRequireUtil.batchReleaseForScheme(dataMutex, reqObjIds, entityKey);
                retryMode = true;
                lockKeyBuffer[0].clear();
                if (!needConvertId) continue;
                lockKeyBuffer[1].clear();
            }
        }
        catch (Exception e) {
            FahMutexRequireUtil.batchReleaseForScheme(lockResultKeys[0], entityKey);
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"MutexRequireUtil_4", (String)"fi-ai-mservice", (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        outputTarget.addAll(needConvertId ? originalIds[0] : lockResultKeys[0]);
    }

    private static boolean checkCanAutoReleaseLockId(Map<String, String> lockInfo, Object failID, String entityKey, long now, int minute, Map<Long, String> userNameCahceMap, Consumer<String> errorMsgConsumer) {
        String lockMsg;
        boolean canRelease = false;
        if (lockInfo != null) {
            Long userid = Long.valueOf(lockInfo.get("userid"));
            String timeStr = lockInfo.get("lockedTime");
            long timeL = 0L;
            if (timeStr != null && now - (timeL = Long.parseLong(timeStr)) > (long)(minute * 60 * 1000)) {
                logger.info("{} billId:{} locked more than 1 hour,automatically unlocked.", (Object)entityKey, failID);
                canRelease = true;
                if (errorMsgConsumer == null) {
                    return canRelease;
                }
            }
            String userName = FahMutexRequireUtil.getName(userNameCahceMap, userid);
            String opKeyName = FahEntityMetaHelper.getOperationName(entityKey, lockInfo.get("opkey"));
            lockMsg = String.format(ResManager.loadKDString((String)"\u7528\u6237\u201c%1$s\u201d\u901a\u8fc7\u64cd\u4f5c\u201c%2$s\u201d\u5df2\u9501\u5b9a\u5f53\u524d\u5bf9\u8c61\u3002", (String)"MutexRequireUtil_0", (String)"fi-ai-mservice", (Object[])new Object[0]), userName, opKeyName);
            if (timeL != 0L) {
                lockMsg = String.format(ResManager.loadKDString((String)"\u7528\u6237\u201c%1$s\u201d\u901a\u8fc7\u64cd\u4f5c\u201c%2$s\u201d\u5728%3$s\u5df2\u9501\u5b9a\u5f53\u524d\u5bf9\u8c61\u3002", (String)"MutexRequireUtil_1", (String)"fi-ai-mservice", (Object[])new Object[0]), userName, opKeyName, timesdf.format(new Date(timeL)));
            }
        } else {
            lockMsg = ResManager.loadKDString((String)"\u7528\u6237\u5df2\u9501\u5b9a\u5f53\u524d\u5bf9\u8c61\u3002", (String)"MutexRequireUtil_2", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        errorMsgConsumer.accept(lockMsg);
        return canRelease;
    }

    public static Set<Object> eventRequireMutex(String entityKey, Set<String> targetObjectIds) {
        if (!FahMutexRequireUtil.isMutexLock_Enabled()) {
            if (targetObjectIds == null || targetObjectIds.isEmpty()) {
                return Collections.emptySet();
            }
            return targetObjectIds.stream().collect(Collectors.toSet());
        }
        HashSet<Object> result = new HashSet<Object>(targetObjectIds.size());
        FahMutexRequireUtil.__eventRequireMutex(result, entityKey, targetObjectIds, null, null, null);
        return result;
    }

    private static boolean isAiEventData(String entityKey) {
        return AIEVENT.equals(entityKey) || entityKey.startsWith("fah_e_");
    }

    protected static <T> Set<Long> __requireMutex(String entityKey, Set<Long> billIds, BiFunction<String, Collection, T> failedInfoCollector, BiConsumer<T, PairTuple<Object, String>> failedReportFunc) {
        if (!FahMutexRequireUtil.isMutexLock_Enabled()) {
            return billIds;
        }
        boolean aiEventData = FahMutexRequireUtil.isAiEventData(entityKey);
        HashSet<Long> result = new HashSet<Long>(billIds.size());
        if (aiEventData) {
            Map<String, Long> lockIdToBillIdLookupMap = FahMutexRequireUtil.buildEventIdLockIdMap(billIds);
            FahMutexRequireUtil.__eventRequireMutex(result, AIEVENT, lockIdToBillIdLookupMap.keySet(), k -> (Long)lockIdToBillIdLookupMap.get(k), failedInfoCollector, failedReportFunc);
        } else {
            FahMutexRequireUtil.__eventRequireMutex(result, entityKey, billIds, k -> Long.valueOf(k), failedInfoCollector, failedReportFunc);
        }
        return result;
    }

    public static PairTuple<Set<Long>, Set<Long>> requireMutex_For_V2(String entityKey, Set<Long> billIds) {
        LinkedList failedIds = new LinkedList();
        Set<Long> successIds = FahMutexRequireUtil.__requireMutex(entityKey, billIds, (srcEn, ids) -> failedIds.addAll(ids), (map, en) -> {});
        return new PairTuple(successIds, new HashSet(failedIds));
    }

    private static void batchReleaseForScheme(DataMutex dataMutex, Collection<Object> lockIDs, String entityNumber) {
        if (CollectionUtils.isEmpty(lockIDs) || !FahMutexRequireUtil.isMutexLock_Enabled()) {
            return;
        }
        boolean aiEventData = FahMutexRequireUtil.isAiEventData(entityNumber);
        Map releaseResult = dataMutex.batchRelease(FahMutexRequireUtil.batchBuildMutexRequiredParamMap(lockIDs, entityNumber = aiEventData ? AIEVENT : entityNumber, true));
        if (!releaseResult.isEmpty() && logger.isInfoEnabled()) {
            for (Map.Entry releaseItem : releaseResult.entrySet()) {
                if (((Boolean)releaseItem.getValue()).booleanValue()) continue;
                logger.info("Failed to release the mutex of [{}]", releaseItem.getKey());
            }
        }
    }

    public static void batchReleaseForScheme(Collection lockIDs, String entityNumber) {
        try (DataMutex dataMutex = DataMutex.create();){
            FahMutexRequireUtil.batchReleaseForScheme(dataMutex, lockIDs, entityNumber);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519\uff0c\u62a5\u9519\u4fe1\u606f\uff1a%s\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MutexRequireUtil_5", (String)"fi-ai-mservice", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
    }

    public static void batchRelease(String entityNumber, Set<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return;
        }
        if (FahMutexRequireUtil.isAiEventData(entityNumber)) {
            FahMutexRequireUtil.batchReleaseForScheme(FahMutexRequireUtil.buildEventIdLockIdMap(billIds).keySet(), AIEVENT);
        } else {
            FahMutexRequireUtil.batchReleaseForScheme(billIds, entityNumber);
        }
    }

    private static Map<String, Long> buildEventIdLockIdMap(Set<Long> billIds) {
        LinkedHashMap<String, Long> resultMap = new LinkedHashMap<String, Long>(billIds.size());
        try (DataSet set = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.dap.MutexRequireUtil", (String)AIEVENT, (String)"id,number,eventclass.masterid eventclass", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds), new QFilter("status", "=", (Object)Character.valueOf('1'))}, null);){
            for (Row row : set) {
                resultMap.put(row.getString("eventclass") + row.getString("number"), row.getLong("id"));
            }
        }
        return resultMap;
    }

    private static String getName(Map<Long, String> userName, Long userid) {
        return userName.computeIfAbsent(userid, uid -> {
            DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)uid, (String)"bos_user");
            if (userObj != null) {
                return userObj.getString("name");
            }
            return "";
        });
    }

    private static Map<String, Object> buildMutexRequiredParamMap(Object dataObjectId, String entityKey, boolean isStrict) {
        HashMap<String, Object> requireParam = new HashMap<String, Object>(5);
        requireParam.put(MUTEX_DATAOBJID, dataObjectId.toString());
        requireParam.put(MUTEX_GROUPID, NET_GROUP);
        requireParam.put(MUTEX_ENTITYKEY, entityKey);
        requireParam.put(MUTEX_OPERATIONKEY, OPERATION_KEY);
        requireParam.put(MUTEX_ISSTRICT, isStrict);
        return requireParam;
    }

    private static List<Map<String, Object>> batchBuildMutexRequiredParamMap(Collection dataObjectIds, String entityKey, boolean isStrict) {
        if (dataObjectIds == null || dataObjectIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Map<String, Object>> resultList = new LinkedList<Map<String, Object>>();
        dataObjectIds.forEach(id -> resultList.add(FahMutexRequireUtil.buildMutexRequiredParamMap(id, entityKey, isStrict)));
        return resultList;
    }

    private static boolean isMutexLock_Enabled() {
        return FahOptimizeControlPanel.isMutexLock_Enabled();
    }
}

