/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils.pipe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.util.exception.IExceptionListener;
import kd.fi.v2.fah.log.ILogHandler;
import kd.fi.v2.fah.storage.IDataItemKey;
import kd.fi.v2.fah.utils.pipe.FahPipeCfgInfo;
import kd.fi.v2.fah.utils.pipe.FahSimpleAsyncStreamDataBlock;
import kd.fi.v2.fah.utils.pipe.IFahIAsyncStreamDataBlock;
import kd.fi.v2.fah.utils.pipe.PipeException;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class FahAsyncStreamPipe<E>
implements IDataItemKey<Object> {
    public static final int PIPE_NOT_RUNNING = 0;
    public static final int PIPE_STARTING = 1;
    public static final int PIPE_RUNNING = 2;
    public static final int PIPE_STOPPING = 3;
    private FahPipeCfgInfo pipeCfgInfo;
    protected ILogHandler logger;
    protected Object pipeItemKey;
    protected final ConcurrentLinkedQueue<IFahIAsyncStreamDataBlock<E>> dataQueue;
    protected Function<Object, BiConsumer<Integer, IFahIAsyncStreamDataBlock>> consumerSupplier;
    protected ReentrantLock __pipeLock;
    protected AtomicInteger pipeStatus;
    protected AtomicInteger activeConsumerCnt;
    protected AtomicInteger waitingDataBlockCnt;
    protected IExceptionListener exceptionListener;
    protected List<Future> consumerThreadRefs;
    protected Function<SimplePipeConsumerThread, Future> threadPoolFunc;

    public FahAsyncStreamPipe(int maxConsumerCnt, Function<SimplePipeConsumerThread, Future> threadPoolFunc) {
        this.pipeCfgInfo = new FahPipeCfgInfo(maxConsumerCnt);
        this.dataQueue = new ConcurrentLinkedQueue();
        this.__pipeLock = new ReentrantLock();
        this.pipeStatus = new AtomicInteger(0);
        this.consumerThreadRefs = new LinkedList<Future>();
        this.threadPoolFunc = threadPoolFunc;
        if (this.threadPoolFunc == null) {
            throw new IllegalArgumentException("Pipe required Thread Pool cannot be null!");
        }
        this.activeConsumerCnt = new AtomicInteger(0);
        this.waitingDataBlockCnt = new AtomicInteger(0);
    }

    public FahAsyncStreamPipe(int maxConsumerCnt, Function<SimplePipeConsumerThread, Future> threadPoolFunc, BiConsumer<Integer, IFahIAsyncStreamDataBlock<E>> dataConsumer) {
        this(maxConsumerCnt, threadPoolFunc);
        this.setDataConsumer(dataConsumer);
    }

    public boolean isQueueFull(int queueSizePreConsumer) {
        return this.getWaitingDataBlockCnt() >= this.pipeCfgInfo.getMaxQueueSize(queueSizePreConsumer);
    }

    public synchronized boolean startPipe() {
        for (int loopCnt = 100; loopCnt > 0; --loopCnt) {
            switch (this.pipeStatus.get()) {
                case 1: 
                case 2: {
                    return true;
                }
                case 0: {
                    return this.__lockAndAccess(false, () -> {
                        if (this.pipeStatus.get() != 0 || this.consumerSupplier == null) {
                            return false;
                        }
                        this.updatePipeStatus(1);
                        this.dataQueue.clear();
                        this.consumerThreadRefs.clear();
                        this.activeConsumerCnt.set(0);
                        this.waitingDataBlockCnt.set(0);
                        this.updatePipeStatus(2);
                        return true;
                    });
                }
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException ex) {
                this.logger.error(ex.getMessage(), ex);
                throw new PipeException(ex, this);
            }
        }
        return false;
    }

    protected BiConsumer<Integer, IFahIAsyncStreamDataBlock<E>> getConsumer() {
        BiConsumer<Integer, IFahIAsyncStreamDataBlock> consumer = this.consumerSupplier.apply(this.pipeItemKey);
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("(Pipe:%s) Consumer from Supplier cannot be null!", this.pipeItemKey));
        }
        return consumer::accept;
    }

    protected synchronized boolean checkAndStartConsumerTask() {
        if (this.needStartNewConsumer(this.activeConsumerCnt.get(), this.waitingDataBlockCnt.get(), this.pipeCfgInfo.queuePreConsumerThreshold)) {
            this.consumerThreadRefs.add(this.threadPoolFunc.apply(new SimplePipeConsumerThread(this.activeConsumerCnt.getAndIncrement(), this.getConsumer())));
            return true;
        }
        return false;
    }

    protected boolean needStartNewConsumer(int activeConsumerCnt, int waitingDataCnt, int threshold) {
        if (waitingDataCnt <= 0 || activeConsumerCnt >= this.pipeCfgInfo.maxConsumerCnt) {
            return false;
        }
        if (activeConsumerCnt <= 0) {
            return true;
        }
        return activeConsumerCnt * threshold < waitingDataCnt;
    }

    protected IFahIAsyncStreamDataBlock<E> putToQueue(IFahIAsyncStreamDataBlock<E> srcData, boolean wait) {
        while (!this.isRunning() || this.__pipeLock.isLocked()) {
            if (!wait) {
                return null;
            }
            try {
                this.__waitDataQueueChange(this.pipeCfgInfo.pipeLock_WaitInterval);
            }
            catch (InterruptedException ex) {
                this.logger.error(ex.getMessage(), ex);
            }
        }
        this.dataQueue.offer(srcData);
        this.waitingDataBlockCnt.incrementAndGet();
        this.checkAndStartConsumerTask();
        this.notifyPipeQueueChanged();
        return srcData;
    }

    protected IFahIAsyncStreamDataBlock<E> putToQueue(IFahIAsyncStreamDataBlock<E> srcData) {
        return this.putToQueue((E)srcData, true);
    }

    public List<IFahIAsyncStreamDataBlock<E>> putToQueue(Object groupKey, Collection<E> srcDatas, boolean wait) {
        LinkedList<IFahIAsyncStreamDataBlock<IFahIAsyncStreamDataBlock<E>>> result = new LinkedList<IFahIAsyncStreamDataBlock<IFahIAsyncStreamDataBlock<E>>>();
        for (E src : srcDatas) {
            IFahIAsyncStreamDataBlock<E> dataBlock = this.putToQueue(groupKey, src, wait);
            if (dataBlock == null) continue;
            result.add(dataBlock);
        }
        return result;
    }

    public List<IFahIAsyncStreamDataBlock<E>> putToQueue(Collection<E> srcDatas, boolean wait) {
        return this.putToQueue((Object)null, srcDatas, wait);
    }

    public IFahIAsyncStreamDataBlock<E> putToQueue(Object groupKey, E srcData, boolean wait) {
        return this.putToQueue((E)new FahSimpleAsyncStreamDataBlock<E>(groupKey, srcData), wait);
    }

    public IFahIAsyncStreamDataBlock<E> putToQueue(E srcData, boolean wait) {
        return this.putToQueue(null, srcData, wait);
    }

    public IFahIAsyncStreamDataBlock<E> putToQueue(Object groupKey, E srcData, int requiredNewPage, int requiredFlush, boolean last, boolean wait) {
        return this.putToQueue((E)new FahSimpleAsyncStreamDataBlock<E>(groupKey, srcData, requiredNewPage, requiredFlush, last), wait);
    }

    protected synchronized void clearDataQueue() {
        try {
            this.__lockAndAccess(false, () -> {
                while (!this.dataQueue.isEmpty()) {
                    IFahIAsyncStreamDataBlock<E> dataBlock = this.dataQueue.poll();
                    if (dataBlock == null) continue;
                    dataBlock.onStageCompleted(CDCStageEnum.Canceled, false);
                }
                this.dataQueue.clear();
                this.waitingDataBlockCnt.set(0);
                return true;
            });
        }
        finally {
            this.notifyPipeQueueChanged();
        }
    }

    public void close(boolean force) {
        try {
            this.__lockAndAccess(false, () -> {
                if (this.isRunning()) {
                    if (force) {
                        this.clearDataQueue();
                    } else {
                        this.notifyPipeQueueChanged();
                        while (!this.isEmpty()) {
                            try {
                                this.__waitDataQueueChange(this.pipeCfgInfo.ConsumerOnEmptyQueue_SleepTime);
                            }
                            catch (Exception ex) {
                                this.logger.error(ex.getMessage(), ex);
                            }
                        }
                    }
                    this.updatePipeStatus(3);
                    for (Future future : this.consumerThreadRefs) {
                        try {
                            future.get();
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            this.logger.error(ex.getMessage(), ex);
                        }
                    }
                    this.updatePipeStatus(0);
                    return true;
                }
                return false;
            });
        }
        finally {
            this.notifyPipeQueueChanged();
        }
    }

    public void close() {
        this.close(false);
    }

    protected void updatePipeStatus(int statusCode) {
        this.pipeStatus.set(statusCode);
    }

    public boolean isStopped() {
        int status = this.pipeStatus.get();
        return status != 2;
    }

    public boolean isRunning() {
        int status = this.pipeStatus.get();
        return status == 2;
    }

    protected static void closeClosable(Closeable src) {
        if (src != null) {
            try {
                src.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IFahIAsyncStreamDataBlock<E> peekFromQueue() {
        return this.dataQueue.peek();
    }

    protected int getWaitingDataBlockCnt() {
        return this.waitingDataBlockCnt.get();
    }

    public int getActiveConsumerCnt() {
        return this.activeConsumerCnt.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPipeQueueChanged() {
        ConcurrentLinkedQueue<IFahIAsyncStreamDataBlock<E>> concurrentLinkedQueue = this.dataQueue;
        synchronized (concurrentLinkedQueue) {
            this.dataQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void __waitDataQueueChange(long waitTime) throws InterruptedException {
        if (waitTime < 0L) {
            throw new IllegalArgumentException("Wait time cannot be negative!");
        }
        ConcurrentLinkedQueue<IFahIAsyncStreamDataBlock<E>> concurrentLinkedQueue = this.dataQueue;
        synchronized (concurrentLinkedQueue) {
            this.dataQueue.wait(waitTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T __lockAndAccess(boolean useTryLock, Supplier<T> lockedAccessFunction) {
        if (lockedAccessFunction == null) {
            return null;
        }
        boolean locked = false;
        try {
            if (useTryLock && !(locked = this.__pipeLock.tryLock())) {
                T t = null;
                return t;
            }
            this.__pipeLock.lock();
            locked = true;
            T t = lockedAccessFunction.get();
            return t;
        }
        finally {
            if (locked) {
                this.__pipeLock.unlock();
            }
        }
    }

    public int queueSize() {
        return this.dataQueue.size();
    }

    public boolean isEmpty() {
        return this.dataQueue.isEmpty() && this.waitingDataBlockCnt.get() <= 0;
    }

    public IExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(IExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public Object getPipeItemKey() {
        return this.pipeItemKey;
    }

    public void setPipeItemKey(Object pipeItemKey) {
        this.pipeItemKey = pipeItemKey;
    }

    public Function<SimplePipeConsumerThread, Future> getThreadPoolFunc() {
        return this.threadPoolFunc;
    }

    public void setThreadPoolFunc(Function<SimplePipeConsumerThread, Future> threadPoolFunc) {
        this.threadPoolFunc = threadPoolFunc;
    }

    public int getPipeStatus() {
        return this.pipeStatus.get();
    }

    public Function<Object, BiConsumer<Integer, IFahIAsyncStreamDataBlock>> getConsumerSupplier() {
        return this.consumerSupplier;
    }

    public void setConsumerSupplier(Function<Object, BiConsumer<Integer, IFahIAsyncStreamDataBlock>> consumerSupplier) {
        this.__lockAndAccess(false, () -> {
            this.consumerSupplier = consumerSupplier;
            return this.consumerSupplier != null;
        });
    }

    public void setDataConsumer(BiConsumer<Integer, IFahIAsyncStreamDataBlock<E>> dataConsumer) {
        this.setConsumerSupplier(key -> dataConsumer::accept);
    }

    protected void waitForDataBlockCntNotify(int waitValue) throws InterruptedException {
        while (this.getWaitingDataBlockCnt() > waitValue) {
            this.__waitDataQueueChange(this.pipeCfgInfo.waitingDataBlock_WaitInterval);
        }
    }

    public void waitForDataBlockCnt(int waitForMaxValue) throws InterruptedException {
        this.waitForDataBlockCntNotify(waitForMaxValue);
    }

    public boolean waitQueueDataCompleted() {
        while (!this.isEmpty()) {
            try {
                this.__waitDataQueueChange(this.pipeCfgInfo.ConsumerOnEmptyQueue_SleepTime);
            }
            catch (InterruptedException ex) {
                this.logger.error(ex.getLocalizedMessage(), ex);
            }
        }
        return true;
    }

    @Override
    public Object getItemKey() {
        return this.pipeItemKey;
    }

    public int getMaxConsumerCnt() {
        return this.pipeCfgInfo.maxConsumerCnt;
    }

    public void setMaxConsumerCnt(int maxConsumerCnt) {
        this.pipeCfgInfo.maxConsumerCnt = maxConsumerCnt;
    }

    public int getQueuePreConsumerThreshold() {
        return this.pipeCfgInfo.queuePreConsumerThreshold;
    }

    public void setQueuePreConsumerThreshold(int queuePreConsumerThreshold) {
        this.pipeCfgInfo.queuePreConsumerThreshold = queuePreConsumerThreshold;
    }

    public long getConsumerOnEmptyQueue_SleepTime() {
        return this.pipeCfgInfo.ConsumerOnEmptyQueue_SleepTime;
    }

    public void setConsumerOnEmptyQueue_SleepTime(long consumerOnEmptyQueue_SleepTime) {
        this.pipeCfgInfo.ConsumerOnEmptyQueue_SleepTime = consumerOnEmptyQueue_SleepTime;
    }

    public int getEmptyQueue_ReCheckTimes() {
        return this.pipeCfgInfo.EmptyQueue_ReCheckTimes;
    }

    public void setEmptyQueue_ReCheckTimes(int emptyQueue_ReCheckTimes) {
        this.pipeCfgInfo.EmptyQueue_ReCheckTimes = emptyQueue_ReCheckTimes;
    }

    public ILogHandler getLogger() {
        return this.logger;
    }

    public void setLogger(ILogHandler logger) {
        this.logger = logger;
    }

    public FahPipeCfgInfo getPipeCfgInfo() {
        return this.pipeCfgInfo;
    }

    public void setPipeCfgInfo(FahPipeCfgInfo pipeCfgInfo) {
        this.pipeCfgInfo.copy(pipeCfgInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T accessPipeCfgInfo(Function<FahPipeCfgInfo, T> accessWrapper) {
        FahAsyncStreamPipe fahAsyncStreamPipe = this;
        synchronized (fahAsyncStreamPipe) {
            return accessWrapper.apply(this.pipeCfgInfo);
        }
    }

    public class BatchProcessPipeConsumerThread
    extends AbstractPipeConsumerThread<List<IFahIAsyncStreamDataBlock<E>>> {
        protected int batchSize;
        protected List<IFahIAsyncStreamDataBlock<E>> __currentBatchCache;
        protected int __currentBatchCnt;

        protected BatchProcessPipeConsumerThread(int consumerIndex, BiConsumer<Integer, List<IFahIAsyncStreamDataBlock<E>>> consumer, int batchSize) {
            super(consumerIndex, consumer);
            this.__currentBatchCnt = 0;
            this.batchSize = batchSize;
            this.__currentBatchCache = new ArrayList(this.batchSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int processQueueData(ConcurrentLinkedQueue<? extends IFahIAsyncStreamDataBlock<E>> dataQueue) {
            int processCnt;
            block8: {
                boolean sucessFlag = true;
                processCnt = 0;
                this.__currentBatchCnt = 0;
                this.__currentBatchCache.clear();
                try {
                    IFahIAsyncStreamDataBlock dataBlock;
                    while (this.__currentBatchCnt < this.batchSize && (dataBlock = dataQueue.poll()) != null) {
                        FahAsyncStreamPipe.this.waitingDataBlockCnt.decrementAndGet();
                        if (!dataBlock.lock()) continue;
                        this.__currentBatchCache.add(dataBlock);
                        ++this.__currentBatchCnt;
                    }
                    if (this.__currentBatchCache.isEmpty()) break block8;
                    FahAsyncStreamPipe.this.notifyPipeQueueChanged();
                    this.consumer.accept(this.consumerIndex, this.__currentBatchCache);
                    this.__currentBatchCache.forEach(d -> d.onStageCompleted(CDCStageEnum.Completed, true));
                    processCnt += this.__currentBatchCache.size();
                }
                catch (Exception ex) {
                    FahAsyncStreamPipe.this.logger.error(ex.getMessage(), ex);
                    if (FahAsyncStreamPipe.this.exceptionListener != null) {
                        FahAsyncStreamPipe.this.exceptionListener.onError((Throwable)ex);
                    }
                    sucessFlag = false;
                    return sucessFlag ? 1 : 0;
                }
                finally {
                    for (IFahIAsyncStreamDataBlock data : this.__currentBatchCache) {
                        data.onStageCompleted(CDCStageEnum.Completed, sucessFlag);
                    }
                }
            }
            return processCnt;
        }
    }

    public class SimplePipeConsumerThread
    extends AbstractPipeConsumerThread<IFahIAsyncStreamDataBlock<E>> {
        protected SimplePipeConsumerThread(int consumerIndex, BiConsumer<Integer, IFahIAsyncStreamDataBlock<E>> consumer) {
            super(consumerIndex, consumer);
        }

        @Override
        protected int processQueueData(ConcurrentLinkedQueue<? extends IFahIAsyncStreamDataBlock<E>> dataQueue) {
            int processCnt;
            block5: {
                processCnt = 0;
                IFahIAsyncStreamDataBlock dataBlock = null;
                try {
                    dataBlock = dataQueue.poll();
                    if (dataBlock != null) {
                        FahAsyncStreamPipe.this.waitingDataBlockCnt.decrementAndGet();
                        FahAsyncStreamPipe.this.notifyPipeQueueChanged();
                        if (dataBlock.lock()) {
                            dataBlock.onStageCompleted(CDCStageEnum.Started, true);
                            this.consumer.accept(this.consumerIndex, dataBlock);
                            dataBlock.onStageCompleted(CDCStageEnum.Completed, true);
                            dataBlock.unlock();
                        }
                        ++processCnt;
                    }
                }
                catch (Exception ex) {
                    FahAsyncStreamPipe.this.logger.error(ex.getMessage(), ex);
                    if (FahAsyncStreamPipe.this.exceptionListener != null) {
                        FahAsyncStreamPipe.this.exceptionListener.onError((Throwable)ex);
                    }
                    if (dataBlock == null) break block5;
                    dataBlock.onStageCompleted(CDCStageEnum.Completed, false);
                }
            }
            return processCnt;
        }
    }

    public abstract class AbstractPipeConsumerThread<DATA>
    implements Callable<Integer> {
        protected final int consumerIndex;
        protected final BiConsumer<Integer, DATA> consumer;

        protected AbstractPipeConsumerThread(int consumerIndex, BiConsumer<Integer, DATA> consumer) {
            this.consumerIndex = consumerIndex;
            this.consumer = consumer;
        }

        protected abstract int processQueueData(ConcurrentLinkedQueue<? extends IFahIAsyncStreamDataBlock<E>> var1);

        @Override
        public Integer call() throws Exception {
            int checkCnt = ((FahAsyncStreamPipe)FahAsyncStreamPipe.this).pipeCfgInfo.EmptyQueue_ReCheckTimes;
            while (true) {
                if (FahAsyncStreamPipe.this.isRunning() && checkCnt > 0) {
                    if (this.processQueueData(FahAsyncStreamPipe.this.dataQueue) > 0) continue;
                    FahAsyncStreamPipe.this.__waitDataQueueChange(((FahAsyncStreamPipe)FahAsyncStreamPipe.this).pipeCfgInfo.ConsumerOnEmptyQueue_SleepTime);
                    --checkCnt;
                    continue;
                }
                int result = FahAsyncStreamPipe.this.activeConsumerCnt.decrementAndGet();
                if (!FahAsyncStreamPipe.this.isRunning() || FahAsyncStreamPipe.this.isEmpty() && FahAsyncStreamPipe.this.isRunning()) {
                    return result;
                }
                checkCnt = ((FahAsyncStreamPipe)FahAsyncStreamPipe.this).pipeCfgInfo.EmptyQueue_ReCheckTimes;
                FahAsyncStreamPipe.this.activeConsumerCnt.incrementAndGet();
            }
        }
    }
}

