/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.utils.pipe;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import kd.fi.bd.indexing.constant.CDCStageEnum;
import kd.fi.bd.util.pipe.datablock.SimpleAsyncStreamDataBlock;
import kd.fi.v2.fah.utils.pipe.IFahIAsyncStreamDataBlock;

public class FahSimpleAsyncStreamDataBlock<E>
extends SimpleAsyncStreamDataBlock<E>
implements IFahIAsyncStreamDataBlock<E> {
    protected ReentrantLock lock = new ReentrantLock();
    protected AtomicBoolean completed = new AtomicBoolean(false);
    private final transient Object __waitMonitor = new Object();

    public FahSimpleAsyncStreamDataBlock(Object groupId, E data, int requiredNewPage, int requiredFlush, boolean last) {
        super(groupId, data, requiredNewPage, requiredFlush, last);
    }

    public FahSimpleAsyncStreamDataBlock(Object groupId, E data, boolean last) {
        super(groupId, data, last);
    }

    public FahSimpleAsyncStreamDataBlock(Object groupId, E data) {
        super(groupId, data);
    }

    public FahSimpleAsyncStreamDataBlock(E data) {
        super(data);
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean lock() {
        if (this.completed.get()) {
            return false;
        }
        boolean lockResult = this.lock.tryLock();
        if (lockResult && this.completed.get()) {
            this.lock.unlock();
            return false;
        }
        return lockResult;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isDone() {
        return this.completed.get();
    }

    public void onStageCompleted(CDCStageEnum completedStageCode, boolean success) {
        if (!this.completed.get()) {
            switch (completedStageCode) {
                case Completed: 
                case Canceled: {
                    this.completed.set(true);
                    break;
                }
            }
        }
        super.onStageCompleted(completedStageCode, success);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.completed.set(true);
        this.stage_Code.set(CDCStageEnum.Canceled.getValue());
        return false;
    }

    @Override
    @JSONField(serialize=false)
    @JsonIgnore
    public boolean isCancelled() {
        return this.isDone() && this.stage_Code.get() == CDCStageEnum.Canceled.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForCompleted(long timeout, TimeUnit unit) {
        long expectTime;
        boolean infinityWait = timeout < 0L;
        long l = expectTime = infinityWait ? -1L : unit.toMillis(timeout);
        while (!this.isDone() && (infinityWait || System.currentTimeMillis() < expectTime)) {
            Object object = this.__waitMonitor;
            synchronized (object) {
                try {
                    this.__waitMonitor.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.isDone();
    }
}

