/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validator;

import kd.bos.dataentity.resource.ResManager;
import kd.fi.v2.fah.models.dynamic.SimpleDynamicObject;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;

public class MsgInfo {
    private static final String SAVE_DEFAULT = "savedefault";
    private String msg;
    private DataModelFieldCfg fieldCfg;
    private SimpleDynamicObject sdo;
    private Object fieldValue;

    public MsgInfo(String msg, DataModelFieldCfg fieldCfg, SimpleDynamicObject sdo, Object fieldValue) {
        this.msg = msg;
        this.fieldCfg = fieldCfg;
        this.sdo = sdo;
        this.fieldValue = fieldValue;
    }

    public String toString() {
        return "MsgInfo{msg='" + this.msg + '\'' + '}';
    }

    public Long getDataId() {
        return (Long)this.sdo.getRoot().getPkValue();
    }

    public Long getFieldId() {
        return (Long)this.fieldCfg.getId();
    }

    public String getOriValue() {
        if (null == this.fieldValue) {
            return "";
        }
        String value = String.valueOf(this.fieldValue);
        if (value.length() > 100) {
            return value.substring(0, 100);
        }
        return value;
    }

    public String getMsg() {
        String rowMsg;
        if (null == this.sdo.getParent()) {
            rowMsg = "";
        } else if (null == this.sdo.getParent().getParent()) {
            String mainNumber = this.sdo.getDynamicObjectType().getName();
            String mainName = this.fieldCfg.getParent().getName();
            String mainEntry = this.getEntryName(mainName, mainNumber);
            rowMsg = String.format(ResManager.loadKDString((String)"\u4e3b\u5206\u5f55\u201c%1$s\u201d\u7b2c\u201c%2$d\u201d\u884c", (String)"MsgInfo_3", (String)"fi-ai-common", (Object[])new Object[0]), mainEntry, this.sdo.getInt("seq"));
        } else {
            String sonNumber = this.sdo.getDynamicObjectType().getName();
            String sonName = this.fieldCfg.getParent().getName();
            String sonEntry = this.getEntryName(sonName, sonNumber);
            String mainEntry = "";
            DataModelFieldCollection parentGroup = this.fieldCfg.getParent().getParentGroup();
            if (parentGroup != null) {
                String mainNumber = this.sdo.getParent().getDynamicObjectType().getName();
                String mainName = parentGroup.getName();
                mainEntry = this.getEntryName(mainName, mainNumber);
            }
            rowMsg = String.format(ResManager.loadKDString((String)"\u4e3b\u5206\u5f55\u201c%1$s\u201d\u7b2c\u201c%2$d\u201d\u884c\u7684\u5b50\u5206\u5f55\u201c%3$s\u201d\u7b2c\u201c%4$d\u201d\u884c", (String)"MsgInfo_1", (String)"fi-ai-common", (Object[])new Object[0]), mainEntry, this.sdo.getParent().getInt("seq"), sonEntry, this.sdo.getInt("seq"));
        }
        String field = this.getEntryName(this.fieldCfg.getName(), this.fieldCfg.getNumber());
        return String.format(ResManager.loadKDString((String)"%1$s%2$s\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c%3$s\u3002", (String)"MsgInfo_4", (String)"fi-ai-common", (Object[])new Object[0]), rowMsg, field, this.msg);
    }

    private String getEntryName(String name, String number) {
        return "\u3010" + name + "\u3011(" + number + ")";
    }

    public String getExtDataNum() {
        return this.sdo.getRoot().getString("number");
    }

    public String getModelNum() {
        return this.fieldCfg.getParent().getParent().getNumber();
    }

    public Long getOrgId() {
        return this.sdo.getRoot().getLong("org_id");
    }

    public boolean getSaveFlag() {
        return this.sdo.getRoot().getBoolean(SAVE_DEFAULT);
    }
}

