/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.validator.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.fi.v2.fah.constant.MasterDataGroupTypeEnum;
import kd.fi.v2.fah.validator.IUpdatableRef;

public class BasePropReferenceInfo<DATA_VALUE, REF extends IUpdatableRef<DATA_VALUE>>
implements Serializable {
    protected DATA_VALUE currentValue;
    protected DATA_VALUE oldValue;
    protected LinkedList<DATA_VALUE> updatedNewValues;
    protected Object param1;
    protected List<REF> references;
    protected int updatedCnt = 0;

    public BasePropReferenceInfo() {
    }

    public BasePropReferenceInfo(DATA_VALUE oldValue, Object param1) {
        this();
        this.oldValue = oldValue;
        this.param1 = param1;
    }

    public DATA_VALUE getCurrentValue() {
        return this.currentValue;
    }

    public DATA_VALUE getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(DATA_VALUE oldValue) {
        this.oldValue = oldValue;
    }

    public List<REF> getReferences() {
        return this.references == null ? Collections.emptyList() : this.references;
    }

    public void addReference(REF reference) {
        if (reference == null) {
            return;
        }
        if (this.references == null) {
            this.references = new LinkedList<REF>();
        }
        this.references.add(reference);
    }

    public Object getParam1() {
        return this.param1;
    }

    public void setParam1(Object param1) {
        this.param1 = param1;
    }

    public boolean updateValue(DATA_VALUE newValue, boolean needUpdateRef, Object ... additionalParams) {
        if (this.currentValue != null && !this.currentValue.equals(newValue)) {
            if (this.updatedNewValues == null) {
                this.updatedNewValues = new LinkedList();
            }
            this.updatedNewValues.add(newValue);
        }
        this.currentValue = newValue;
        ++this.updatedCnt;
        if (needUpdateRef && this.references != null && !this.references.isEmpty()) {
            this.references.forEach(v -> v.updateReference(this.currentValue, newValue));
            return true;
        }
        return false;
    }

    public LinkedList<DATA_VALUE> getUpdatedNewValues() {
        return this.updatedNewValues;
    }

    public int getUpdatedCnt() {
        return this.updatedCnt;
    }

    public Collection<String> collectUpdateErrorMsg(MasterDataGroupTypeEnum masterDataGrpType, Object dateTypeKey) {
        LinkedList<String> errorMsg = new LinkedList<String>();
        if (this.references != null && !this.references.isEmpty()) {
            this.references.forEach(v -> {
                String updateErrorMsg = v.getUpdateErrorMsg(masterDataGrpType, dateTypeKey, this);
                if (null != updateErrorMsg) {
                    errorMsg.add(updateErrorMsg);
                }
            });
        }
        return errorMsg;
    }
}

