/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.dap;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.AcctBook;
import kd.fi.ai.AppBookConfig;
import kd.fi.ai.BizBook;
import kd.fi.ai.dap.DapCache;
import kd.fi.bd.business.service.GLAccountBookService;

public class DapBookHelper4BizBook {
    private Map<String, Set<AcctBook>> bizBook2AcctBookCache;

    public DapBookHelper4BizBook(Map<String, Set<AcctBook>> bizBook2AcctBookCache) {
        this.bizBook2AcctBookCache = bizBook2AcctBookCache;
    }

    public Set<Long> getSingleBillAcctBook(String billTypeKey, Long billid, String billNo, BizBook bizBook, String orgField) {
        Set<AcctBook> bookSet = null;
        String bizBookStr = bizBook.toString();
        if (this.bizBook2AcctBookCache.containsKey(bizBookStr)) {
            bookSet = this.bizBook2AcctBookCache.get(bizBookStr);
        } else {
            if (bizBook.getBookID() != 0L || bizBook.getBookTypeID() != 0L) {
                bookSet = this.getAcctBookFromBizBook(bizBook, billTypeKey, orgField);
            }
            this.bizBook2AcctBookCache.put(bizBookStr, bookSet);
        }
        if (bookSet == null || bookSet.size() == 0) {
            return null;
        }
        HashSet<Long> bookIdSet = new HashSet<Long>(16);
        for (AcctBook ab : bookSet) {
            bookIdSet.add(ab.getBookID());
        }
        return bookIdSet;
    }

    private Set<AcctBook> getAcctBookFromBizBook(BizBook bizBook, String billTypeKey, String orgField) {
        if (bizBook.getBookID() != 0L) {
            String appNumber = DapCache.getBillEntityAppNumber((String)billTypeKey);
            AppBookConfig appconfig = DapCache.appConfig.get(appNumber);
            QFilter orgFilter = new QFilter(appconfig.bookEntityOrgField, "=", (Object)bizBook.getAcctOrgID());
            QFilter idFilter = new QFilter("id", "=", (Object)bizBook.getBookID());
            boolean exist = QueryServiceHelper.exists((String)appconfig.bookEntity, (QFilter[])new QFilter[]{idFilter, orgFilter});
            if (!exist) {
                return null;
            }
            return this.queryGLBook(bizBook.getBookID(), appconfig, bizBook.getAcctOrgID(), orgField);
        }
        String appNumber = DapCache.getBillEntityAppNumber((String)billTypeKey);
        AppBookConfig appconfig = DapCache.appConfig.get(appNumber);
        QFilter orgFilter = new QFilter(appconfig.bookEntityOrgField, "=", (Object)bizBook.getAcctOrgID());
        QFilter typeFilter = new QFilter(appconfig.bookEntityTypeField, "=", (Object)bizBook.getBookTypeID());
        DynamicObject bizBookObj = BusinessDataServiceHelper.loadSingle((String)appconfig.bookEntity, (String)"id", (QFilter[])new QFilter[]{orgFilter, typeFilter});
        return this.queryGLBook(bizBookObj.getLong("id"), appconfig, bizBook.getAcctOrgID(), orgField);
    }

    private Set<AcctBook> queryGLBook(long bizBookID, AppBookConfig appconfig, long bizOrgID, String orgField) {
        AppInfo app = AppMetadataCache.getAppInfo((String)appconfig.appNumber);
        Set glBookids = GLAccountBookService.queryGlAccountBook((String)app.getId(), (Long)bizBookID, (Long)0L);
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org,bookstype", (QFilter[])new QFilter("id", "in", (Object)glBookids).toArray());
        HashSet<AcctBook> res = new HashSet<AcctBook>(16);
        for (DynamicObject glb : books) {
            res.add(new AcctBook(glb.getLong("org"), glb.getLong("bookstype"), glb.getLong("id"), bizOrgID, orgField));
        }
        return res;
    }
}

