/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.compiler;

import java.util.HashMap;
import java.util.Map;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;

public class AbstractCompiler {
    protected IBuildVchContext context;
    protected ISingleTaskContext taskContext;
    protected boolean compilerFinished = false;
    protected Map<String, IVariableMode> selectedFields = new HashMap<String, IVariableMode>();

    public AbstractCompiler(ISingleTaskContext taskContext) {
        this.taskContext = taskContext;
        this.context = taskContext.getBuildVchContext();
    }

    public ISingleTaskContext getTaskContext() {
        return this.taskContext;
    }

    public void setTaskContext(ISingleTaskContext taskContext) {
        this.taskContext = taskContext;
        this.context = taskContext.getBuildVchContext();
    }

    public Map<String, IVariableMode> getSelectedFields() {
        return this.selectedFields;
    }

    public void Compolier() {
        if (!this.compilerFinished) {
            this.DoCompolier();
            this.DoParseFields();
        }
        this.compilerFinished = true;
    }

    protected void DoParseFields() {
    }

    protected void DoCompolier() {
    }

    protected void WriteInfoLog(String message) {
        this.context.getLogger().info(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), message);
    }

    protected void WriteWarnLog(String message) {
        this.context.getLogger().warn(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), message);
    }

    protected void WriteErrorLog(String message) {
        this.context.getLogger().error(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), message);
    }

    protected void WriteErrorLog(Throwable exp) {
        this.context.getLogger().error(this.taskContext.getTaskId(), this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber(), this.taskContext.getTemplateName(), exp);
    }

    protected void addErrorReport(VoucherCheckItem checkItem, String msg) {
        this.context.getReporter().AddErrorReport(this.taskContext.getBookInfo(), this.taskContext.getSourceBill(), (Object)0L, null, this.taskContext.getTemplate() == null ? null : this.taskContext.getTemplate().getId(), checkItem, VoucherErrLevel.Warning, msg, this.taskContext.getBuildType(), this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "");
    }
}

