/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.compiler;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fs.util.StringUtils;
import kd.fi.ai.AbstractVchTplItemMap;
import kd.fi.ai.AsstactType;
import kd.fi.ai.VchFlexMappingItem;
import kd.fi.ai.VchTplAsstDimFactorSource;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.compiler.AbstractCompiler;
import kd.fi.ai.mservice.builder.getvaluehandle.AcctItemGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.AsstLongDirectoryGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.AsstMapDataGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.CheckAcctItemFilterHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.FormulaGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.IGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.VchFlexMappingGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.helper.BuildHelper;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class AcctItemCompiler
extends AbstractCompiler {
    private String flexName;
    private String valueType;
    private CheckAcctItemFilterHandle checkFilterHandle;
    private IGetValueHandle<?> getItemHandle;
    private AbstractVchTplItemMap acctItemMap;
    private List<VchTplAsstDimFactorSource> assSourceList;
    private String info;
    private boolean isBizVoucher = false;
    private VchFlexMappingItem flexMappingItem;

    public AcctItemCompiler(ISingleTaskContext taskContext, AbstractVchTplItemMap itemMap, List<VchTplAsstDimFactorSource> assSourceList) {
        super(taskContext);
        this.acctItemMap = itemMap;
        this.assSourceList = assSourceList;
    }

    public AcctItemCompiler(ISingleTaskContext taskContext, AbstractVchTplItemMap itemMap, List<VchTplAsstDimFactorSource> assSourceList, VchFlexMappingItem flexMappingItem) {
        this(taskContext, itemMap, assSourceList);
        this.flexMappingItem = flexMappingItem;
    }

    public AcctItemCompiler(ISingleTaskContext taskContext, AbstractVchTplItemMap itemMap, List<VchTplAsstDimFactorSource> assSourceList, boolean isBizVoucher) {
        this(taskContext, itemMap, assSourceList);
        this.isBizVoucher = isBizVoucher;
    }

    public AcctItemCompiler(ISingleTaskContext taskContext, AbstractVchTplItemMap itemMap, List<VchTplAsstDimFactorSource> assSourceList, boolean isBizVoucher, VchFlexMappingItem flexMappingItem) {
        this(taskContext, itemMap, assSourceList, isBizVoucher);
        this.flexMappingItem = flexMappingItem;
    }

    public AbstractVchTplItemMap getAcctItemMap() {
        return this.acctItemMap;
    }

    @Override
    protected void DoParseFields() {
        super.DoParseFields();
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.getItemHandle.getVars());
        if (!this.isBizVoucher) {
            BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.checkFilterHandle.getVars());
        }
    }

    @Override
    protected void DoCompolier() {
        super.DoCompolier();
        StringBuilder infoJilu = new StringBuilder();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u7f16\u8bd1\u6838\u7b97\u9879\u76ee\u53d6\u503c\u914d\u7f6e", (String)"AcctItemCompiler_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        String propName = this.acctItemMap.getSourceFieldKey();
        String condition = "";
        String itemTypeid = this.acctItemMap.getItemClass();
        AsstactType at = null;
        at = this.isBizVoucher ? BaseDataLoader.loadBizAsstactType((IBuildVchContext)this.getTaskContext().getBuildVchContext(), (Long)Long.valueOf(itemTypeid)) : BaseDataLoader.loadAsstactType((IBuildVchContext)this.getTaskContext().getBuildVchContext(), (String)itemTypeid, () -> String.format(ResManager.loadKDString((String)"ID\u4e3a\u201c%1$s\u201d\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u79d1\u76ee\u6216\u6838\u7b97\u7ef4\u5ea6\u662f\u5426\u5b58\u5728\u4fee\u6539\u3002", (String)"AcctItemCompiler_2", (String)"fi-ai-mservice", (Object[])new Object[0]), itemTypeid));
        this.flexName = at.getFlexName();
        this.valueType = at.getValueType();
        String constValue = this.acctItemMap.getConstValue();
        if ("3".equalsIgnoreCase(this.valueType)) {
            constValue = this.acctItemMap.getConstName();
        }
        long asstDimMapID = this.acctItemMap.getAsstDimMapID();
        infoJilu.append("getDataConfig:---propName:");
        infoJilu.append(propName);
        infoJilu.append(" ;---itemTypeid:");
        infoJilu.append(itemTypeid);
        infoJilu.append(" ;---flexName:");
        infoJilu.append(this.flexName);
        infoJilu.append(" ;---valueType:");
        infoJilu.append(this.valueType);
        infoJilu.append(" ;---source:");
        infoJilu.append(at.getValuesourceID());
        infoJilu.append(" ;---constValue:");
        infoJilu.append(constValue);
        infoJilu.append(" ;---asstDimMapID:");
        infoJilu.append(asstDimMapID);
        infoJilu.append(" ;---exp:");
        infoJilu.append(this.acctItemMap.getExp());
        infoJilu.append(" ;---tplAGrssName:");
        infoJilu.append(this.acctItemMap.getVchTplAgrssName());
        infoJilu.append("\n");
        this.info = infoJilu.toString();
        if (0L != asstDimMapID) {
            this.getItemHandle = new AsstMapDataGetHandle(this.taskContext, asstDimMapID, this.assSourceList);
        } else if (StringUtils.isNotEmpty((String)this.acctItemMap.getExp())) {
            this.getItemHandle = new FormulaGetHandle<Object>(this.taskContext, this.acctItemMap.getExp(), null);
        } else if (StringUtils.isNotEmpty((String)this.acctItemMap.getVchTplAgrssName())) {
            this.getItemHandle = new AsstLongDirectoryGetHandle(this.taskContext, this.acctItemMap.getVchTplAgrss());
        } else if (this.acctItemMap.getFlexMappingid() != 0L) {
            this.getItemHandle = new VchFlexMappingGetHandle(this.taskContext, this.flexMappingItem, this.acctItemMap.getFlexMappingid(), VchFlexMappingGetHandle.FlexMappingType.ASSIST, this.acctItemMap.getItemClass());
        } else if (Long.class.getName().equalsIgnoreCase(this.acctItemMap.getConstType())) {
            if (StringUtils.isEmpty((String)constValue.trim())) {
                constValue = "0";
            }
            this.getItemHandle = new AcctItemGetHandle<Long>(this.taskContext, propName, Long.parseLong(constValue));
        } else {
            this.getItemHandle = new AcctItemGetHandle<String>(this.taskContext, propName, constValue);
        }
        if (!this.isBizVoucher) {
            this.checkFilterHandle = new CheckAcctItemFilterHandle(this.taskContext, condition);
        }
        String logMessage = ResManager.loadKDString((String)"\u6838\u7b97\u9879\u76ee\uff1a{0}\uff0c\u53d6\u503c\u6761\u4ef6\uff1a{1}\uff0c\u53d6\u503c\u516c\u5f0f\uff1a{2}\uff0c\u53d6\u503c\u5b57\u6bb5\uff1a{3}\uff0c\u5e38\u91cf\u503c\uff1a{4}", (String)"AcctItemCompiler_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
        logMessage = MessageFormat.format(logMessage, this.flexName, condition, this.acctItemMap.getExp(), propName, constValue);
        this.WriteInfoLog(logMessage);
    }

    public String getFlexName() {
        return this.flexName;
    }

    public void setFlexName(String flexName) {
        this.flexName = flexName;
    }

    public CheckAcctItemFilterHandle getCheckFilterHandle() {
        return this.checkFilterHandle;
    }

    public void setCheckFilterHandle(CheckAcctItemFilterHandle checkFilterHandle) {
        this.checkFilterHandle = checkFilterHandle;
    }

    public IGetValueHandle<?> getGetItemHandle() {
        return this.getItemHandle;
    }

    public void setGetItemHandle(IGetValueHandle<?> getItemHandle) {
        this.getItemHandle = getItemHandle;
    }

    public List<VchTplAsstDimFactorSource> getAssSourceList() {
        return this.assSourceList;
    }

    public void setAssSourceList(List<VchTplAsstDimFactorSource> assSourceList) {
        this.assSourceList = assSourceList;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getInfo() {
        return this.info;
    }
}

