/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.compiler;

import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.compiler.TplCompiler;
import kd.fi.ai.mservice.builder.setvaluehandle.AccountSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.AmountSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.AttachmentSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.BizAssistSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.CreatorSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.CreditTotalSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.DebitTotalSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.ExplanationSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.QtySetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.SetEntryExpandValueHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.SetHeaderExpandValueHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.VchDateSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.VchDescriptionSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.VchHeadConstSetHandle;
import kd.fi.ai.mservice.builder.setvaluehandle.VchTypeSetHandle;

public class SetValueHelper {
    private ISingleTaskContext taskContext;
    private SingleTaskResult taskResult;
    private TplCompiler tplCompiler;
    private VchHeadConstSetHandle vchConstHandle;
    private VchTypeSetHandle vchTypeHandle;
    private VchDateSetHandle vchDateHandle;
    private CreditTotalSetHandle creditTotalHandle;
    private DebitTotalSetHandle debitTotalHandle;
    private AccountSetHandle accoutHandle;
    private BizAssistSetHandle bizAssistSetHandle;
    private AmountSetHandle amountHandle;
    private QtySetHandle qtyHandle;
    private ExplanationSetHandle explanationHandle;
    private VchDescriptionSetHandle vchDescriptionSetHandle;
    private CreatorSetHandle creatorSetHandle;
    private AttachmentSetHandle attachmentHandle;
    private SetHeaderExpandValueHandle setHeaderExpandValueHandle;
    private SetEntryExpandValueHandle setEntryExpandValueHandle;
    private boolean isBizVoucher = false;

    public SetValueHelper(ISingleTaskContext taskContext, SingleTaskResult taskResult, TplCompiler tplCompiler) {
        this.taskContext = taskContext;
        this.taskResult = taskResult;
        this.tplCompiler = tplCompiler;
        this.isBizVoucher = taskContext.isEnableBizVoucherByOrg();
        this.CreateFldHandles();
    }

    private void CreateFldHandles() {
        this.vchConstHandle = new VchHeadConstSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.vchDescriptionSetHandle = new VchDescriptionSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.vchTypeHandle = new VchTypeSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.vchDateHandle = new VchDateSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.creditTotalHandle = new CreditTotalSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.debitTotalHandle = new DebitTotalSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.accoutHandle = new AccountSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        if (this.isBizVoucher) {
            this.bizAssistSetHandle = new BizAssistSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        }
        this.amountHandle = new AmountSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.qtyHandle = new QtySetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.explanationHandle = new ExplanationSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.attachmentHandle = new AttachmentSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.creatorSetHandle = new CreatorSetHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.setHeaderExpandValueHandle = new SetHeaderExpandValueHandle(this.taskContext, this.taskResult, this.tplCompiler);
        this.setEntryExpandValueHandle = new SetEntryExpandValueHandle(this.taskContext, this.taskResult, this.tplCompiler);
    }

    public VchTypeSetHandle getVchTypeHandle() {
        return this.vchTypeHandle;
    }

    public VchDateSetHandle getVchDateHandle() {
        return this.vchDateHandle;
    }

    public VchHeadConstSetHandle getVchConstHandle() {
        return this.vchConstHandle;
    }

    public CreditTotalSetHandle getCreditTotalHandle() {
        return this.creditTotalHandle;
    }

    public DebitTotalSetHandle getDebitTotalHandle() {
        return this.debitTotalHandle;
    }

    public AccountSetHandle getAccoutHandle() {
        return this.accoutHandle;
    }

    public AmountSetHandle getAmountHandle() {
        return this.amountHandle;
    }

    public QtySetHandle getQtyHandle() {
        return this.qtyHandle;
    }

    public ExplanationSetHandle getExplanationHandle() {
        return this.explanationHandle;
    }

    public VchDescriptionSetHandle getVchDescriptionSetHandle() {
        return this.vchDescriptionSetHandle;
    }

    public AttachmentSetHandle getAttachmentHandle() {
        return this.attachmentHandle;
    }

    public void setAttachmentHandle(AttachmentSetHandle attachmentHandle) {
        this.attachmentHandle = attachmentHandle;
    }

    public CreatorSetHandle getCreatorSetHandle() {
        return this.creatorSetHandle;
    }

    public SetHeaderExpandValueHandle getSetHeaderExpandValueHandle() {
        return this.setHeaderExpandValueHandle;
    }

    public void setSetHeaderExpandValueHandle(SetHeaderExpandValueHandle setHeaderExpandValueHandle) {
        this.setHeaderExpandValueHandle = setHeaderExpandValueHandle;
    }

    public SetEntryExpandValueHandle getSetEntryExpandValueHandle() {
        return this.setEntryExpandValueHandle;
    }

    public void setSetEntryExpandValueHandle(SetEntryExpandValueHandle setEntryExpandValueHandle) {
        this.setEntryExpandValueHandle = setEntryExpandValueHandle;
    }

    public BizAssistSetHandle getBizAssistSetHandle() {
        return this.bizAssistSetHandle;
    }
}

