/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.ai.builder.plugin.field.VchTplField;
import kd.bos.ext.fi.ai.builder.plugin.fieldenum.VchTplFieldSort;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.DataType;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchTplAcctItemMap;
import kd.fi.ai.VchTplBizAssists;
import kd.fi.ai.VchTplEntry;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.plugin.events.PlugCustEntity;
import kd.fi.ai.builder.plugin.events.PlugCustField;
import kd.fi.ai.dap.DapConfig;
import kd.fi.ai.mservice.builder.compiler.AbstractCompiler;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.AccountDirectoryGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.AcctGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.AmountGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.AsstGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.BizAssistGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.BusinessNumGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.CashflowGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.CheckEntryFilterHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.ComAssistHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.DCDirectoryGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.ExchangeRateGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.ExchangeRateTypeGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.ExplanationGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.GetValueHandleFactory;
import kd.fi.ai.mservice.builder.getvaluehandle.MainAsstGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.MeasureUnitGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.OriAmountGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.OriCurrencyGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.PriceGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.ProfitRowFlagGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.QtyGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.SuppcfitemGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.VchExpireDateGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.CustFieldMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.ai.mservice.builder.helper.BuildHelper;
import kd.fi.ai.util.AiCommonFieldUtils;
import kd.fi.ai.util.FieldReplaceUtil;

public class TplEntryCompiler
extends AbstractCompiler {
    private VchTplEntry vchTempEntry;
    private EntityType selectedSourceEntity = null;
    private PlugCustEntity selectedCustEntity = null;
    private HashSet<String> selectedEntityKeys = new HashSet();
    private String billName = "";
    private Map<String, IVariableMode> sumFields = new HashMap<String, IVariableMode>();
    private Map<String, IVariableMode> groupFields = new HashMap<String, IVariableMode>();
    private boolean compileError = false;
    private ProfitRowFlagGetHandle profitRowFlagGetHandle;
    private AcctGetHandle acctGetHandle;
    private DCDirectoryGetHandle dcGetHandle;
    private AmountGetHandle amountGetHandle;
    private AccountDirectoryGetHandle accountGetHandle;
    private CheckEntryFilterHandle checkFilterHandle;
    private ExchangeRateTypeGetHandle rateTypeGetHandle;
    private ExchangeRateGetHandle rateGetHandle;
    private ExplanationGetHandle explanationGetHandle;
    private BusinessNumGetHandle businessNumGetHandle;
    private OriAmountGetHandle oriAmountGetHandle;
    private OriCurrencyGetHandle oriCurrencyGetHandle;
    private PriceGetHandle priceGetHandle;
    private QtyGetHandle qtyGetHandle;
    private CashflowGetHandle cashflowGetHandle;
    private MeasureUnitGetHandle measureUnitGetHandle;
    private AsstGetHandle asstGetHandle;
    private BizAssistGetHandle bizAssistGetHandle;
    private VchExpireDateGetHandle expireGetHandle;
    private MainAsstGetHandle mainAsstGetHandle;
    private SuppcfitemGetHandle suppcfitemGetHandle;
    private ComAssistHandle comAssistHandle;
    private Map<String, AbstractGetValueHandle<?>> expandMap = new HashMap();
    private boolean isBizVoucher = false;
    private boolean needBuildEvent = false;

    public Map<String, IVariableMode> getSumFields() {
        return this.sumFields;
    }

    public void setSumFields(Map<String, IVariableMode> sumFields) {
        this.sumFields = sumFields;
    }

    public Map<String, IVariableMode> getGroupFields() {
        return this.groupFields;
    }

    public void setGroupFields(Map<String, IVariableMode> groupFields) {
        this.groupFields = groupFields;
    }

    public TplEntryCompiler(ISingleTaskContext taskContext, VchTplEntry vchTempEntry) {
        super(taskContext);
        this.vchTempEntry = vchTempEntry;
        this.isBizVoucher = taskContext.isEnableBizVoucherByOrg();
        DapConfig dapConfig = taskContext.getDapConfig();
        boolean delaybuildevent = dapConfig != null ? dapConfig.isDelaybuildevent() : false;
        this.needBuildEvent = this.isBizVoucher && (!delaybuildevent || taskContext.isBuildBizvoucherFromMidle());
    }

    public VchTplEntry getVchTempEntry() {
        return this.vchTempEntry;
    }

    public EntityType getSelectedSourceEntity() {
        return this.selectedSourceEntity;
    }

    public PlugCustEntity getSelectedCustEntity() {
        return this.selectedCustEntity;
    }

    public String getSelectedEntityKeys() {
        String entityKeys = StringUtils.join((Object[])this.selectedEntityKeys.toArray(), (String)",");
        return entityKeys;
    }

    public boolean isCompileError() {
        return this.compileError;
    }

    public CheckEntryFilterHandle getCheckFilterHandle() {
        return this.checkFilterHandle;
    }

    public ProfitRowFlagGetHandle getProfitRowFlagGetHandle() {
        return this.profitRowFlagGetHandle;
    }

    public AcctGetHandle getAcctGetHandle() {
        return this.acctGetHandle;
    }

    public DCDirectoryGetHandle getDcGetHandle() {
        return this.dcGetHandle;
    }

    public AccountDirectoryGetHandle getAccountGetHandle() {
        return this.accountGetHandle;
    }

    public OriCurrencyGetHandle getOriCurrencyGetHandle() {
        return this.oriCurrencyGetHandle;
    }

    public OriAmountGetHandle getOriAmountGetHandle() {
        return this.oriAmountGetHandle;
    }

    public ExchangeRateTypeGetHandle getRateTypeGetHandle() {
        return this.rateTypeGetHandle;
    }

    public ExchangeRateGetHandle getRateGetHandle() {
        return this.rateGetHandle;
    }

    public AmountGetHandle getAmountGetHandle() {
        return this.amountGetHandle;
    }

    public ExplanationGetHandle getExpanationGetHandle() {
        return this.explanationGetHandle;
    }

    public BusinessNumGetHandle getBusinessNumGetHandle() {
        return this.businessNumGetHandle;
    }

    public PriceGetHandle getPriceGetHandle() {
        return this.priceGetHandle;
    }

    public QtyGetHandle getQtyGetHandle() {
        return this.qtyGetHandle;
    }

    @Override
    protected void DoParseFields() {
        super.DoParseFields();
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.acctGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.dcGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.accountGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.amountGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.checkFilterHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.rateTypeGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.rateGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.explanationGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.businessNumGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.oriAmountGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.oriCurrencyGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.priceGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.qtyGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.measureUnitGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.cashflowGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.asstGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.comAssistHandle.getVars());
        if (this.needBuildEvent) {
            BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.bizAssistGetHandle.getVars());
        }
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.expireGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.mainAsstGetHandle.getVars());
        BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, this.suppcfitemGetHandle.getVars());
        for (Map.Entry<String, AbstractGetValueHandle<?>> expandGetHandle : this.expandMap.entrySet()) {
            BuildHelper.AddVarsToFldList((Map<String, IVariableMode>)this.selectedFields, expandGetHandle.getValue().getVars());
        }
        this.DoParseEntity();
    }

    @Override
    protected void DoCompolier() {
        String acctOrgFldKey;
        String expression;
        this.billName = StringUtils.isNotBlank((CharSequence)this.vchTempEntry.getBelongSources()) ? this.vchTempEntry.getBelongSources() : this.vchTempEntry.getBelongSource();
        this.billName = AiCommonFieldUtils.getRebillVoucherName((String)this.billName);
        MainEntityType oldType = null;
        if (!"null".equals(this.billName) && StringUtils.isNotBlank((CharSequence)this.billName) && !Objects.equals(this.billName, this.taskContext.getSrcEntityType().getName())) {
            oldType = this.taskContext.getSrcEntityType();
            this.taskContext.setSrcEntityType(MetadataServiceHelper.getDataEntityType((String)this.billName));
        }
        this.profitRowFlagGetHandle = new ProfitRowFlagGetHandle(this.taskContext, this.vchTempEntry);
        String logMessage = String.format(ResManager.loadKDString((String)"\u6c47\u5151\u635f\u76ca\u884c\u5224\u65ad\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_0", (String)"fi-ai-mservice", (Object[])new Object[0]), this.profitRowFlagGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.acctGetHandle = new AcctGetHandle(this.taskContext, this.vchTempEntry.getAcctsSet());
        this.asstGetHandle = new AsstGetHandle(this.taskContext, this.vchTempEntry.getAsst());
        if (this.needBuildEvent) {
            String billType = this.billName;
            if (StringUtils.isEmpty((CharSequence)billType)) {
                billType = this.taskContext.getSrcEntityType().getName();
            }
            VchTplBizAssists vchTplBizAssists = this.getVchTplBizAssists(billType);
            this.bizAssistGetHandle = new BizAssistGetHandle(this.taskContext, vchTplBizAssists);
        }
        this.cashflowGetHandle = new CashflowGetHandle(this.taskContext, this.vchTempEntry.getCashflow());
        this.suppcfitemGetHandle = new SuppcfitemGetHandle(this.taskContext, this.vchTempEntry.getCashflow());
        logMessage = String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_1", (String)"fi-ai-mservice", (Object[])new Object[0]), this.cashflowGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.comAssistHandle = new ComAssistHandle(this.taskContext, this.vchTempEntry.getComassist());
        this.mainAsstGetHandle = new MainAsstGetHandle(this.taskContext, this.vchTempEntry.getMainAsst());
        this.dcGetHandle = new DCDirectoryGetHandle(this.taskContext, this.vchTempEntry.getDcs());
        logMessage = String.format(ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u5411\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_2", (String)"fi-ai-mservice", (Object[])new Object[0]), this.dcGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.accountGetHandle = new AccountDirectoryGetHandle(this.taskContext, this.vchTempEntry.getAcctsSet().getVchTplAcccounts());
        logMessage = String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_3", (String)"fi-ai-mservice", (Object[])new Object[0]), this.accountGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.amountGetHandle = new AmountGetHandle(this.taskContext, this.vchTempEntry.getLocalAmountSet());
        logMessage = String.format(ResManager.loadKDString((String)"\u8bb0\u8d26\u672c\u4f4d\u5e01\u91d1\u989d\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_4", (String)"fi-ai-mservice", (Object[])new Object[0]), this.amountGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        String oriExp = expression = this.vchTempEntry.getDataScope().getExpression();
        Map commonAndSourceFieldcol = this.taskContext.getCommonAndSourceFieldcol();
        if (!commonAndSourceFieldcol.isEmpty()) {
            VchTplExpression filterSet = FieldReplaceUtil.replaceFilterSet((VchTplExpression)this.vchTempEntry.getDataScope(), (Map)commonAndSourceFieldcol);
            this.vchTempEntry.setDataScope(filterSet);
        }
        if (this.vchTempEntry.getDataScope().getFilterCondition() != null) {
            expression = this.vchTempEntry.getDataScope().buildFullFormula(this.taskContext.getSrcEntityType());
        }
        if (StringUtils.isNotBlank((CharSequence)(acctOrgFldKey = this.taskContext.getTemplate().getAcctOrgSet()))) {
            BasedataProp orgPro = (BasedataProp)this.taskContext.getSrcEntityType().getProperties().get((Object)acctOrgFldKey);
            if (orgPro != null && "bos_costcenter".equals(orgPro.getBaseEntityId())) {
                acctOrgFldKey = acctOrgFldKey + ".accountorg";
            }
            if (StringUtils.isEmpty((CharSequence)this.billName) || Objects.equals(this.taskContext.getTemplate().getSourceBill(), this.billName)) {
                expression = StringUtils.isNotBlank((CharSequence)expression) ? expression + " and (" + acctOrgFldKey + "=" + this.taskContext.getBookInfo().getBizOrgId() + ")" : "(" + acctOrgFldKey + "=" + this.taskContext.getBookInfo().getBizOrgId() + ")";
            }
        }
        this.checkFilterHandle = new CheckEntryFilterHandle(this.taskContext, expression, oriExp);
        logMessage = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u6570\u636e\u7b5b\u9009\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_5", (String)"fi-ai-mservice", (Object[])new Object[0]), this.checkFilterHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.rateTypeGetHandle = new ExchangeRateTypeGetHandle(this.taskContext, "");
        logMessage = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u7c7b\u578b\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_6", (String)"fi-ai-mservice", (Object[])new Object[0]), this.rateTypeGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        String rate = StringUtils.isNotEmpty((CharSequence)this.vchTempEntry.getRateNew()) ? this.vchTempEntry.getRateNew() : this.vchTempEntry.getRateSet();
        this.rateGetHandle = new ExchangeRateGetHandle(this.taskContext, rate);
        logMessage = String.format(ResManager.loadKDString((String)"\u6c47\u7387\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_7", (String)"fi-ai-mservice", (Object[])new Object[0]), this.rateGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.explanationGetHandle = new ExplanationGetHandle(this.taskContext, this.vchTempEntry.getExplanationSet(), "");
        logMessage = String.format(ResManager.loadKDString((String)"\u6458\u8981\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_8", (String)"fi-ai-mservice", (Object[])new Object[0]), this.explanationGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.businessNumGetHandle = new BusinessNumGetHandle(this.taskContext, this.vchTempEntry.getBusinessNumSet(), "");
        logMessage = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7f16\u53f7\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_14", (String)"fi-ai-mservice", (Object[])new Object[0]), this.explanationGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.oriAmountGetHandle = new OriAmountGetHandle(this.taskContext, this.vchTempEntry.getOriAmountSet());
        logMessage = String.format(ResManager.loadKDString((String)"\u539f\u59cb\u5e01\u79cd\u91d1\u989d\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_9", (String)"fi-ai-mservice", (Object[])new Object[0]), this.oriAmountGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.oriCurrencyGetHandle = new OriCurrencyGetHandle(this.taskContext, this.vchTempEntry.getOriCurrencySet());
        logMessage = String.format(ResManager.loadKDString((String)"\u539f\u59cb\u5e01\u79cd\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_10", (String)"fi-ai-mservice", (Object[])new Object[0]), this.oriCurrencyGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.priceGetHandle = new PriceGetHandle(this.taskContext, this.vchTempEntry.getPriceSet());
        logMessage = String.format(ResManager.loadKDString((String)"\u5355\u4ef7\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_11", (String)"fi-ai-mservice", (Object[])new Object[0]), this.priceGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        this.qtyGetHandle = new QtyGetHandle(this.taskContext, this.vchTempEntry.getQuantitySet());
        logMessage = String.format(ResManager.loadKDString((String)"\u6570\u91cf\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_12", (String)"fi-ai-mservice", (Object[])new Object[0]), this.qtyGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        if (this.vchTempEntry.getExpireDate() == null) {
            this.vchTempEntry.setExpireDate(new VchExpireDate());
        }
        this.expireGetHandle = new VchExpireDateGetHandle(this.taskContext, this.vchTempEntry.getExpireDate());
        this.measureUnitGetHandle = new MeasureUnitGetHandle(this.taskContext, this.vchTempEntry.getMeasureunit());
        logMessage = String.format(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u53d6\u503c\u89c4\u5219\uff1a%s", (String)"TplEntryCompiler_13", (String)"fi-ai-mservice", (Object[])new Object[0]), this.measureUnitGetHandle.getDescription());
        this.WriteInfoLog(logMessage);
        List expandFields = this.vchTempEntry.getExtVchTplEntryField();
        for (VchTplField vchTplField : expandFields) {
            if (!VchTplFieldSort.Entry.equals((Object)vchTplField.getVchTplFieldSort())) continue;
            this.expandMap.put(vchTplField.getFieldName(), GetValueHandleFactory.getGetValueHandler(this.taskContext, vchTplField));
        }
        if (oldType != null) {
            this.taskContext.setSrcEntityType(oldType);
        }
    }

    private VchTplBizAssists getVchTplBizAssists(String billtype) {
        long eventClassId = this.getTaskContext().getTemplate().getEventClassId();
        String vchTplBizAssistsstr = (String)ThreadCache.get((Object)(billtype + "-" + eventClassId), () -> {
            VchTplBizAssists vchTplBizAssists = new VchTplBizAssists();
            DynamicObject standardevent = null;
            standardevent = eventClassId == 0L ? BusinessDataServiceHelper.loadSingleFromCache((String)"ai_standardevent", (QFilter[])new QFilter("billtype.fbasedataid", "=", (Object)billtype).and(new QFilter("enable", "=", (Object)Character.valueOf('1'))).toArray()) : BusinessDataServiceHelper.loadSingleFromCache((String)"ai_standardevent", (QFilter[])new QFilter("eventtype.fbasedataid", "=", (Object)eventClassId).and(new QFilter("enable", "=", (Object)Character.valueOf('1'))).toArray());
            if (standardevent != null) {
                DynamicObjectCollection entrys = standardevent.getDynamicObjectCollection("entryentity");
                for (DynamicObject subentry : entrys) {
                    String entrybilltype = subentry.getString("billno");
                    if (!billtype.equals(entrybilltype)) continue;
                    VchTplAcctItemMap item = new VchTplAcctItemMap();
                    DynamicObject assttype = subentry.getDynamicObject("asstacttypeid");
                    if (null == assttype) continue;
                    item.setItemClass(assttype.getPkValue().toString());
                    item.setItemName(assttype.getString("name"));
                    String datatype = assttype.getString("datatype");
                    item.setItemType(datatype);
                    if (DataType.BASEDATA.getValue().equals(datatype)) {
                        item.setItemNumber(assttype.getString("valuesource.id"));
                    } else if (DataType.ASSISTANT.getValue().equals(datatype)) {
                        item.setItemNumber(assttype.getString("assistanttype.number"));
                    }
                    item.setExp(subentry.getString("exp"));
                    item.setSourceFieldKey(subentry.getString("field"));
                    vchTplBizAssists.getItemClassMaps().add(item);
                }
            }
            return SerializationUtils.toJsonString((Object)vchTplBizAssists);
        });
        if (StringUtils.isNotEmpty((CharSequence)vchTplBizAssistsstr)) {
            return (VchTplBizAssists)SerializationUtils.fromJsonString((String)vchTplBizAssistsstr, VchTplBizAssists.class);
        }
        return new VchTplBizAssists();
    }

    private void DoParseEntity() {
        HashMap<String, IVariableMode> amountFlds = new HashMap<String, IVariableMode>();
        BuildHelper.AddVarsToFldList(amountFlds, this.oriAmountGetHandle.getVars());
        BuildHelper.AddVarsToFldList(amountFlds, this.amountGetHandle.getVars());
        this.sumFields.putAll(amountFlds);
        BuildHelper.AddVarsToFldList(this.sumFields, this.qtyGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.checkFilterHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.acctGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.dcGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.rateGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.explanationGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.oriCurrencyGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.priceGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.measureUnitGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.cashflowGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.suppcfitemGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.asstGetHandle.getVars());
        BuildHelper.AddVarsToFldList(this.groupFields, this.comAssistHandle.getVars());
        if (amountFlds.size() == 0) {
            amountFlds.putAll(this.selectedFields);
        }
        if (this.needBuildEvent) {
            BuildHelper.AddVarsToFldList(this.groupFields, this.bizAssistGetHandle.getVars());
        }
        PlugCustEntity custEntity = null;
        MainEntityType mainEntityType = null;
        mainEntityType = !"null".equals(this.billName) && !Objects.equals(this.billName, this.taskContext.getSrcEntityType().getName()) && StringUtils.isNotBlank((CharSequence)this.billName) ? MetadataServiceHelper.getDataEntityType((String)this.billName) : this.taskContext.getSrcEntityType();
        MainEntityType entity1 = mainEntityType;
        for (Map.Entry varItem : amountFlds.entrySet()) {
            IVariableMode var = (IVariableMode)varItem.getValue();
            EntityType entity2 = null;
            if (var instanceof CustFieldMode) {
                PlugCustField custField = ((CustFieldMode)var).getCustField();
                custEntity = (PlugCustEntity)this.taskContext.getCustEntities().get(custField.getEntityKey());
                if (custEntity.getParentEntityKey().equalsIgnoreCase(mainEntityType.getName())) {
                    entity2 = mainEntityType;
                } else {
                    EntryProp entryProp = (EntryProp)mainEntityType.findProperty(custEntity.getParentEntityKey());
                    entity2 = (EntityType)entryProp.getItemType();
                }
            } else if (var instanceof SourceBillFieldMode) {
                entity2 = (EntityType)((SourceBillFieldMode)var).getSourceField().getParent();
            }
            entity1 = BuildHelper.ComparerEntity((EntityType)entity1, entity2);
        }
        this.selectedSourceEntity = entity1;
        this.selectedCustEntity = custEntity;
        this.selectedEntityKeys.add(mainEntityType.getName());
        if (entity1 instanceof SubEntryType) {
            this.selectedEntityKeys.add(entity1.getParent().getName());
        }
        if (entity1 != null) {
            BuildHelper.AddRange(this.selectedEntityKeys, entity1.getName());
        }
        if (this.needBuildEvent) {
            this.setIsNeedGetValueByBizasst();
        }
    }

    private void setIsNeedGetValueByBizasst() {
        Map isNeedGetValueByBizasst = this.taskContext.getIsNeedGetValueByBizasst();
        List<IVariableMode> vars = this.bizAssistGetHandle.getVars();
        for (IVariableMode var : vars) {
            String key;
            EntityType entity = null;
            if (var instanceof SourceBillFieldMode) {
                entity = (EntityType)((SourceBillFieldMode)var).getSourceField().getParent();
            }
            if (this.selectedSourceEntity == null || entity == null || !(var instanceof SourceBillFieldMode) || isNeedGetValueByBizasst.containsKey(key = this.selectedSourceEntity.getName() + "-" + entity.getName() + "-" + ((SourceBillFieldMode)var).getFullPropName())) continue;
            isNeedGetValueByBizasst.put(key, BuildHelper.comparerEntityForBizasst(this.selectedSourceEntity, entity));
        }
        this.taskContext.getIsNeedGetValueByBizasst().putAll(isNeedGetValueByBizasst);
    }

    private void CheckSelectedFields() {
        this.compileError = false;
    }

    public CashflowGetHandle getCashflowGetHandle() {
        return this.cashflowGetHandle;
    }

    public SuppcfitemGetHandle getSuppcfitemGetHandle() {
        return this.suppcfitemGetHandle;
    }

    public MeasureUnitGetHandle getMeasureUnitGetHandle() {
        return this.measureUnitGetHandle;
    }

    public AsstGetHandle getAsstGetHandle() {
        return this.asstGetHandle;
    }

    public BizAssistGetHandle getBizAssistGetHandle() {
        return this.bizAssistGetHandle;
    }

    public void setAsstGetHandle(AsstGetHandle asstGetHandle) {
        this.asstGetHandle = asstGetHandle;
    }

    public VchExpireDateGetHandle getExpireGetHandle() {
        return this.expireGetHandle;
    }

    public MainAsstGetHandle getMainAsstGetHandle() {
        return this.mainAsstGetHandle;
    }

    public Map<String, AbstractGetValueHandle<?>> getExpandMap() {
        return this.expandMap;
    }

    public void setExpandMap(Map<String, AbstractGetValueHandle<?>> expandMap) {
        this.expandMap = expandMap;
    }

    public String getBillName() {
        return this.billName;
    }

    public ComAssistHandle getComAssistHandle() {
        return this.comAssistHandle;
    }

    public void setComAssistHandle(ComAssistHandle comAssistHandle) {
        this.comAssistHandle = comAssistHandle;
    }

    public String getSourceEntityKey(TplEntryCompiler tplEntryCompiler, VCHTemplate template) {
        String entityName = tplEntryCompiler.getVchTempEntry().getBelongSource();
        String relationshipSourcebill = template.getRelationshipSourcebill();
        HashSet relationshipSourcebillcol = new HashSet(template.getRelationshipSourcebillcol());
        if (StringUtils.isEmpty((CharSequence)entityName) || StringUtils.isEmpty((CharSequence)relationshipSourcebill)) {
            entityName = tplEntryCompiler.getSelectedSourceEntity().getName();
        }
        if (!StringUtils.isEmpty((CharSequence)relationshipSourcebill)) {
            String string = entityName = relationshipSourcebill.equals(entityName) ? tplEntryCompiler.getSelectedSourceEntity().getName() + relationshipSourcebill : tplEntryCompiler.getSelectedSourceEntity().getName();
        }
        if (!relationshipSourcebillcol.isEmpty()) {
            entityName = relationshipSourcebillcol.contains(tplEntryCompiler.getVchTempEntry().getBelongSources()) || relationshipSourcebillcol.contains(AiCommonFieldUtils.getRebillEntityName((String)tplEntryCompiler.getVchTempEntry().getBelongSources())) ? "multi" + entityName + tplEntryCompiler.getVchTempEntry().getBelongSources() : entityName;
        }
        return entityName;
    }
}

