/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.factory;

import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.AccountView;
import kd.fi.ai.VchTplEntryNewSortOption;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.builder.factory.BaseSortCompareUtil;
import kd.fi.ai.mservice.builder.factory.IVoucherEntrySort;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class NewFirstDebitEntrySortImpl
implements IVoucherEntrySort {
    public ISingleTaskContext taskContext;
    public VchTplEntryNewSortOption op = new VchTplEntryNewSortOption();

    public NewFirstDebitEntrySortImpl(ISingleTaskContext taskContext, VchTplEntryNewSortOption op) {
        this.taskContext = taskContext;
        this.op = op;
    }

    @Override
    public void SortVchEntryRows(IVoucher<?> voucher) {
        List entryRows = voucher.getEntryRows();
        entryRows.sort(new Comparator<IVoucherEntry>(){

            @Override
            public int compare(IVoucherEntry x, IVoucherEntry y) {
                int xDc = x.getDcDirectory();
                int yDc = y.getDcDirectory();
                if (xDc > 0 && yDc > 0) {
                    if (NewFirstDebitEntrySortImpl.this.op != null) {
                        if (NewFirstDebitEntrySortImpl.this.op.isSecondOrder2()) {
                            if (x instanceof GLVoucherEntry && y instanceof GLVoucherEntry) {
                                return NewFirstDebitEntrySortImpl.this.compareByOriginalNoByGL((GLVoucherEntry)x, (GLVoucherEntry)y);
                            }
                            return NewFirstDebitEntrySortImpl.this.compareByOriginalNo(x, y);
                        }
                        if (NewFirstDebitEntrySortImpl.this.op.isSecondOrder3()) {
                            return NewFirstDebitEntrySortImpl.this.compareByAcctNumber(x, y, NewFirstDebitEntrySortImpl.this.taskContext);
                        }
                        if (NewFirstDebitEntrySortImpl.this.op.isSecondOrder4()) {
                            return NewFirstDebitEntrySortImpl.this.compareByTemplateOrder(x, y);
                        }
                    }
                    return 0;
                }
                if (xDc > 0) {
                    return -1;
                }
                if (yDc > 0) {
                    return 1;
                }
                if (NewFirstDebitEntrySortImpl.this.op != null) {
                    if (NewFirstDebitEntrySortImpl.this.op.isSecondOrder2()) {
                        if (x instanceof GLVoucherEntry && y instanceof GLVoucherEntry) {
                            return NewFirstDebitEntrySortImpl.this.compareByOriginalNoByGL((GLVoucherEntry)x, (GLVoucherEntry)y);
                        }
                        return NewFirstDebitEntrySortImpl.this.compareByOriginalNo(x, y);
                    }
                    if (NewFirstDebitEntrySortImpl.this.op.isSecondOrder3()) {
                        return NewFirstDebitEntrySortImpl.this.compareByAcctNumber(x, y, NewFirstDebitEntrySortImpl.this.taskContext);
                    }
                    if (NewFirstDebitEntrySortImpl.this.op.isSecondOrder4()) {
                        return NewFirstDebitEntrySortImpl.this.compareByTemplateOrder(x, y);
                    }
                }
                return 0;
            }
        });
    }

    private int compareByAcctNumber(IVoucherEntry x, IVoucherEntry y, ISingleTaskContext taskContext) {
        boolean flag = false;
        Long xId = x.getAccountId();
        Long yId = y.getAccountId();
        AccountView xObject = BaseDataLoader.loadAccount((IBuildVchContext)taskContext.getBuildVchContext(), (Long)xId);
        AccountView yObject = BaseDataLoader.loadAccount((IBuildVchContext)taskContext.getBuildVchContext(), (Long)yId);
        String xNo = xObject.getNumber();
        String yNo = yObject.getNumber();
        if (StringUtils.isBlank((CharSequence)xNo)) {
            xNo = "";
            flag = true;
        }
        if (StringUtils.isBlank((CharSequence)yNo)) {
            yNo = "";
            flag = true;
        }
        if (flag) {
            return yNo.compareTo(xNo);
        }
        return xNo.compareTo(yNo);
    }

    private int compareByOriginalNo(IVoucherEntry x, IVoucherEntry y) {
        int ySeq;
        int xSeq = x.getSeq();
        if (xSeq == (ySeq = y.getSeq())) {
            return 0;
        }
        if (xSeq < ySeq) {
            return -1;
        }
        return 1;
    }

    private int compareByOriginalNoByGL(GLVoucherEntry x, GLVoucherEntry y) {
        int compareRet = BaseSortCompareUtil.getCompareResult(x.getSourceBillNo(), y.getSourceBillNo());
        if (compareRet == 0) {
            return 0;
        }
        if (compareRet < 0) {
            return -1;
        }
        return 1;
    }

    private int compareByTemplateOrder(IVoucherEntry x, IVoucherEntry y) {
        int ySeq;
        int xSeq = x.getTplEntrySeq();
        if (xSeq > (ySeq = y.getTplEntrySeq())) {
            return 1;
        }
        if (xSeq < ySeq) {
            return -1;
        }
        return 0;
    }
}

