/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.factory;

import java.util.Comparator;
import java.util.List;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.builder.factory.BaseSortCompareUtil;
import kd.fi.ai.mservice.builder.factory.IVoucherEntrySort;

public class OriginalOrderEntrySortImpl
implements IVoucherEntrySort {
    @Override
    public void SortVchEntryRows(IVoucher<?> voucher) {
        List entryRows = voucher.getEntryRows();
        if (voucher instanceof GLVoucher) {
            List glEntryRows = entryRows;
            glEntryRows.sort(new Comparator<GLVoucherEntry>(){

                @Override
                public int compare(GLVoucherEntry x, GLVoucherEntry y) {
                    int xDc = x.getDcDirectory();
                    int yDc = y.getDcDirectory();
                    if (xDc > 0 && yDc > 0) {
                        return this.compareByNumberByGL(x, y);
                    }
                    if (xDc > 0) {
                        return -1;
                    }
                    if (yDc > 0) {
                        return 1;
                    }
                    return this.compareByNumberByGL(x, y);
                }

                private int compareByNumberByGL(GLVoucherEntry x, GLVoucherEntry y) {
                    int compareRet = BaseSortCompareUtil.getCompareResult(x.getSourceBillNo(), y.getSourceBillNo());
                    if (compareRet == 0) {
                        int ySeq;
                        int xSeq = x.getTplEntrySeq();
                        if (xSeq == (ySeq = y.getTplEntrySeq())) {
                            return 0;
                        }
                        if (xSeq < ySeq) {
                            return -1;
                        }
                        return 1;
                    }
                    if (compareRet < 0) {
                        return -1;
                    }
                    return 1;
                }
            });
        } else {
            entryRows.sort(new Comparator<IVoucherEntry>(){

                @Override
                public int compare(IVoucherEntry x, IVoucherEntry y) {
                    int xDc = x.getDcDirectory();
                    int yDc = y.getDcDirectory();
                    if (xDc > 0 && yDc > 0) {
                        return this.compareByNumberByIV(x, y);
                    }
                    if (xDc > 0) {
                        return -1;
                    }
                    if (yDc > 0) {
                        return 1;
                    }
                    return this.compareByNumberByIV(x, y);
                }

                private int compareByNumberByIV(IVoucherEntry x, IVoucherEntry y) {
                    int ySeq;
                    int xSeq = x.getSeq();
                    if (xSeq == (ySeq = y.getSeq())) {
                        return 0;
                    }
                    if (xSeq < ySeq) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
    }
}

